#include "palm_sync.h"

static DBusHandlerResult
filter_test_message (DBusConnection     *connection,
                     DBusMessage        *message,
                     void               *user_data)
{

  //print_message (message);

  if (dbus_message_is_signal (message,
                              "org.multisync.test",
                              "Disconnected"))
    exit (0);

	printf("blubb\n");
	return DBUS_HANDLER_RESULT_HANDLED;
}

static void new_conn(DBusServer     *server,
                         DBusConnection *new_connection,
                         void           *user_data)
{

	printf("new conn\n");
	dbus_connection_ref (new_connection);
	printf("test1\n");
	dbus_connection_setup_with_g_main (new_connection, NULL);
	printf("test1\n");
	dbus_connection_add_filter (new_connection,filter_test_message, NULL, NULL);
	printf("test1\n");
}

int startDBus() {
	DBusServer *server;
	DBusError derror;

	dbus_error_init (&derror);

	server = dbus_server_listen("unix:path=/tmp/palmsync-dbus", &derror);
	if (!server) {
		printf ("Failed: %s\n", derror.message);
		dbus_error_free (&derror);
		return 1;
	}

	dbus_server_set_new_connection_function(server, (DBusNewConnectionFunction) new_conn, NULL, NULL);  	

	dbus_server_setup_with_g_main(server, NULL);

	return 0;
}