/*
 * Decompiled with CFR 0.152.
 */
package viewer.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import viewer.common.Dialogs;

public class Launcher {
    private static String FileSeparator = "/";
    private static String PathSeparator = ":";
    private static String JavaHome = null;
    private static String ClassPath = null;
    private static String UserHome = null;
    private static final String SETUP_FILENAME = ".jumpshot_launcher.conf";
    private static String JVM = "java";
    private static String JVM_OPTIONS = "-Xms64m -Xmx256m";
    private static String VIEWER_JAR = "jumpshot.jar";
    private static final String CONFIGURATION_HEADER = "# Jumpshot-4 Launcher setup file.\n#JVM: Java Virtual Machine name, can be absolute path.\n#JVM_OPTIONS: JVM launch parameters.\n#VIEWER_JAR: executable jar file to be launched.";

    private static void initializeSystemProperties() {
        Properties properties = System.getProperties();
        FileSeparator = properties.getProperty("file.separator");
        PathSeparator = properties.getProperty("path.separator");
        JavaHome = properties.getProperty("java.home");
        ClassPath = properties.getProperty("java.class.path");
        UserHome = properties.getProperty("user.home");
    }

    private static void initializeLauncherConstants() {
        JVM = FileSeparator.equals("/") ? "java" : "javaw.exe";
    }

    private static boolean readLauncherConstants() {
        String string = UserHome + FileSeparator + SETUP_FILENAME;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            JVM = properties.getProperty("JVM");
            JVM_OPTIONS = properties.getProperty("JVM_OPTIONS");
            VIEWER_JAR = properties.getProperty("VIEWER_JAR");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        return true;
    }

    private static void writeLauncherConstants() {
        String string = UserHome + FileSeparator + SETUP_FILENAME;
        Properties properties = new Properties();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.setProperty("JVM", JVM);
            properties.setProperty("JVM_OPTIONS", JVM_OPTIONS);
            properties.setProperty("VIEWER_JAR", VIEWER_JAR);
            properties.store(fileOutputStream, CONFIGURATION_HEADER);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static String getDefaultPathToJVM() {
        String string = null;
        File file = new File(JVM);
        string = file.isAbsolute() ? JVM : JavaHome + FileSeparator + "bin" + FileSeparator + JVM;
        return string;
    }

    private static String getDefaultPathToJarDir() {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(ClassPath, PathSeparator);
        while (stringTokenizer.hasMoreTokens() && string == null) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.lastIndexOf(FileSeparator);
            if (n < 0) continue;
            string = string2.substring(0, n);
        }
        return string;
    }

    private static String getDefaultJarPath(String string) {
        if (string != null && string.length() > 0) {
            return string + FileSeparator + VIEWER_JAR;
        }
        return VIEWER_JAR;
    }

    private String exec(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n = 0;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(string);
            InputStreamThread inputStreamThread = new InputStreamThread(process.getErrorStream(), "Error", stringBuffer);
            InputStreamThread inputStreamThread2 = new InputStreamThread(process.getInputStream(), "Output", stringBuffer2);
            inputStreamThread.start();
            inputStreamThread2.start();
            n = process.waitFor();
            inputStreamThread.stopRunning();
            inputStreamThread = null;
            inputStreamThread2.stopRunning();
            inputStreamThread2 = null;
            if (n != 0) {
                return stringBuffer.toString();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static final void main(String[] stringArray) {
        String string;
        File file;
        String string2;
        String string3;
        File file2;
        Launcher.initializeSystemProperties();
        Launcher.initializeLauncherConstants();
        if (!Launcher.readLauncherConstants()) {
            Dialogs.info(null, "This is your first time using the launcher.\nA launcher setup file will be written to\nyour home directory " + UserHome + ".", null);
            Launcher.writeLauncherConstants();
        }
        if (!(file2 = new File(string3 = Launcher.getDefaultJarPath(string2 = Launcher.getDefaultPathToJarDir()))).exists()) {
            Dialogs.error(null, string3 + " does not exist!\n" + "Make sure that " + VIEWER_JAR + " is in " + "the same directory as this launcher.\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!file2.canRead()) {
            Dialogs.error(null, string3 + " is NOT readable!\n" + "Reset the read privilege of the file, " + VIEWER_JAR + ".\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!(file = new File(string = Launcher.getDefaultPathToJVM())).exists()) {
            Dialogs.error(null, string + " does not exist!\n" + "Make sure that " + string + " exists.\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!file.canRead()) {
            Dialogs.error(null, string + " is NOT readable!\n" + "Reset the read privilege of the file, " + string + ".\n" + "Then restart this program again.");
            System.exit(1);
        }
        String string4 = JVM_OPTIONS;
        Launcher launcher = new Launcher();
        String string5 = string + " " + string4 + " -jar " + string3;
        String string6 = launcher.exec(string5);
        if (string6 != null) {
            Dialogs.error(null, "The following process exits with error:\n" + string5 + "\n" + string6);
            System.exit(1);
        }
        System.exit(0);
    }

    private class InputStreamThread
    extends Thread {
        private InputStream ins;
        private String prefix;
        private StringBuffer outbuffer;
        private boolean isRunning;

        public InputStreamThread(InputStream inputStream, String string, StringBuffer stringBuffer) {
            this.ins = inputStream;
            this.prefix = string;
            this.outbuffer = stringBuffer;
            this.isRunning = true;
        }

        public void stopRunning() {
            this.isRunning = false;
        }

        public void run() {
            try {
                String string = null;
                InputStreamReader inputStreamReader = new InputStreamReader(this.ins);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while (this.isRunning && (string = bufferedReader.readLine()) != null) {
                    System.out.println(this.prefix + " > " + string);
                    if (this.outbuffer == null) continue;
                    this.outbuffer.append(string + "\n");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

