///////////////////////////////////////////////////////////////////////////////
// $Id: maptoolpoint.h,v 1.1 2004/03/28 20:44:09 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    maptoolpoint.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the point tool class for maps
*/

#ifndef MAPTOOLPOINT_H
#define MAPTOOLPOINT_H

// Qt includes
#include <qpoint.h>

// local includes
#include "maptool.h"

class MapToolPoint : public MapTool
{
public:
	MapToolPoint(MapDocument* doc);

	~MapToolPoint();

	void activate();

	bool usedMousePress(uint row, uint col, int button);
	bool usedMouseMove(uint row, uint col, int buttons);

	bool coversTileAt(uint row, uint col) const;

	QRect coverArea() const;

private:
	QPoint m_lastPoint;
};

#endif

// End of file
