/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

 /* $Id: mas_ppm.h,v 1.2 2003/10/07 14:31:02 silvio Exp $ */

#ifndef _MAS_PPM_H
#define _MAS_PPM_H

struct ppm_properties
{
    uint32 integration_ms;
    uint32 refresh_client; /* integer multiple of integration_ms */
    double decay_time;     /* down 90% in decay_time seconds */
    double db_cutoff;
};


extern int32
mas_ppm_get_properties( mas_device_t device, struct ppm_properties *prop );

extern int32
mas_ppm_set_properties( mas_device_t device, struct ppm_properties *prop );


#endif /* _MAS_PPM_H */

