/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/* GUI for spectrum analyzer config */
/* modified from the general version */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include "mas/mas.h"
#include "mas/mas_core.h"
#include "visual_config.h"


/* to avoid initial mas_get actions... */

#define SPIKES 2
#define SCALE_CUTOFF -60
#define N_BINS 30
#define DO_WORK 0

int16 values[4];


gint
do_mas_set( mas_device_t device )
{
    struct mas_package pkg;
    char pbuf[256];
    /*     static int16 prev_values; */

    if ( device == NULL )
        return FALSE;
    
    masc_setup_package( &pkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    if( values[0]==TRUE )
        masc_pushk_int16( &pkg, "do_work", 1 );
    else
        masc_pushk_int16( &pkg, "do_work", 0 );
    
    masc_finalize_package( &pkg );    
    mas_set( device, "do_work", &pkg );
    masc_strike_package( &pkg );

    
    masc_setup_package( &pkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    masc_pushk_int16( &pkg, "spikes", values[1] );
    masc_finalize_package( &pkg );    
    mas_set( device, "spikes", &pkg );
    masc_strike_package( &pkg );


    masc_setup_package( &pkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    masc_pushk_int16( &pkg, "n_bins", values[2] );
    masc_finalize_package( &pkg );    
    mas_set( device, "n_bins", &pkg );
    masc_strike_package( &pkg );

    masc_setup_package( &pkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    masc_pushk_int16( &pkg, "scale_cutoff", values[3] );
    masc_finalize_package( &pkg );    
    mas_set( device, "scale_cutoff", &pkg );
    masc_strike_package( &pkg );
    
    return TRUE;
}



static gint
cb_int16( GtkSpinButton *sb, gpointer data )
{
    int16 *val;

    val = (int16*)data;

    *val = gtk_spin_button_get_value( sb );
    
    return TRUE;
}


static gint
cb_bool( GtkToggleButton *tg, gpointer data )
{
    int16 *val;

    val = (int16*)data;

    *val = gtk_toggle_button_get_active( tg );
    
    return TRUE;
}



GtkWidget
*create_int16( char *name, int16 *value, int16 lower, int16 upper )
{
    GtkWidget *hbox;
    GtkWidget *label;    
    GtkWidget *spin;
    GtkObject *adj;


    adj = gtk_adjustment_new( *value, lower, upper, 1, 10, 10 );

    spin = gtk_spin_button_new ( GTK_ADJUSTMENT(adj), 1, 0 );
    gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin), TRUE);
    g_signal_connect( G_OBJECT(spin), "value-changed",
                      G_CALLBACK (cb_int16), (gpointer) value );

    label = gtk_label_new( name );

    hbox = gtk_hbox_new( TRUE, 10 );

    gtk_box_pack_start( GTK_BOX(hbox), label, TRUE, TRUE, 0 );
    gtk_box_pack_start( GTK_BOX(hbox), spin, TRUE, TRUE, 0 );
    
    return hbox;
}


GtkWidget
*create_bool( char *name, int16 *value )
{
    GtkWidget *hbox;
    GtkWidget *label;    
    GtkWidget *check;


    check = gtk_check_button_new( );
    
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(check),
                                   (gboolean)(*value) );
    
    g_signal_connect( G_OBJECT(check), "toggled",
                      G_CALLBACK (cb_bool), (gpointer)value );

    label = gtk_label_new( name );

    hbox = gtk_hbox_new( TRUE, 10 );

    gtk_box_pack_start( GTK_BOX(hbox), label, TRUE, TRUE, 0 );
    gtk_box_pack_start( GTK_BOX(hbox), check, TRUE, TRUE, 0 );
    
    return hbox;
}



    
GtkWidget*
make_visual_widget( void )
{
    GtkWidget *w;
    GtkWidget *vbox;
    int i;

    vbox = gtk_vbox_new( TRUE, 10 );

    gtk_container_set_border_width( GTK_CONTAINER(vbox), 10 );


    
    if( DO_WORK )
        values[0] = TRUE;
    else
        values[0] = FALSE;
    
    w = create_bool( "enabled", &(values[0]) );
    
    gtk_box_pack_start( GTK_BOX(vbox), w, TRUE, TRUE, 0 );



    values[1] = SPIKES;
    w = create_int16( "spikes/boxes", &(values[1]), 0, 100 );
    gtk_box_pack_start( GTK_BOX(vbox), w, TRUE, TRUE, 0 );


    
    values[2] = N_BINS;
    w = create_int16( "number of bins ", &(values[2]), 1, 1000 );
    gtk_box_pack_start( GTK_BOX(vbox), w, TRUE, TRUE, 0 );

    

    values[3] = SCALE_CUTOFF;
    w = create_int16( "db cut off", &(values[3]), -1000, 1000 );
    gtk_box_pack_start( GTK_BOX(vbox), w, TRUE, TRUE, 0 );

    
    return vbox;
}
