/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_AUDIO_BASIC_H
#define	_MAS_AUDIO_BASIC_H

#include "mas_common.h"

#define MAS_LINEAR_FMT  0
#define MAS_ULINEAR_FMT 1
#define MAS_ULAW_FMT    2
#define MAS_ALAW_FMT    3

#define MAS_NO_ENDIAN_FMT     0
#define MAS_HOST_ENDIAN_FMT   1
#define MAS_LITTLE_ENDIAN_FMT 2
#define MAS_BIG_ENDIAN_FMT    3

extern struct mas_data_characteristic* masc_make_audio_basic_dc( uint8 format, uint32 srate, uint8 resolution, uint8 channels, uint8 endian );
extern int32 masc_scan_audio_basic_dc( struct mas_data_characteristic* dc, uint8* format, uint32* srate, uint8* resolution, uint8* channels, uint8* endian );
extern int32 masc_get_audio_basic_bpstc( uint8 resolution, uint8 channels );

#endif /* _MAS_AUDIO_BASIC_H */

