/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This program takes a rule file and compiles it to an intermediate code 
 * file. */

/* Includes. ================================================================*/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <locale.h>
#include <setjmp.h>
#include "basic.h"
#include "pools.h"
#include "values.h"
#include "symbols.h"
#include "scanner.h"
#include "files.h"
#include "rule_type.h"
#include "rule_code.h"
#include "rule_compiler.h"
#include "patterns.h"
#include "hangul.h"

/* Functions. ===============================================================*/

int 
main( int argc, char *argv[] )
/* The main function of "malrul". */
{
  string_t rule_file, object_file, symbol_file;
  int_t file_type = 0, i;

  init_basic( "malrul" );
  if (argc == 2) 
  { 
    if (strcmp_no_case( argv[1], "--version" ) == 0
	|| strcmp_no_case( argv[1], "-version" ) == 0
	|| strcmp_no_case( argv[1], "-v" ) == 0) 
    { 
      program_message();
      exit(0);
    } 
    else if (strcmp_no_case( argv[1], "--help" ) == 0
	     || strcmp_no_case( argv[1], "-help" ) == 0
	     || strcmp_no_case( argv[1], "-h" ) == 0) 
    { 
      printf( "Compile a rule file of a Malaga grammar.\n\n"
	      "Usage:\n"
	      "malrul SYM_FILE RULE_FILE "
	      "-- Compile RULE_FILE using SYM_FILE.\n"
	      "malrul -v[ersion]         "
	      "-- Print version information.\n"
	      "malrul -h[elp]            "
	      "-- Print this help.\n\n"
	      "SYM_FILE may end on \".sym\" or \".esym\".\n"
	      "RULE_FILE may end on \".all\", \".mor\", or \".syn\".\n" );
      exit(0);
    }
  }
  rule_file = object_file = symbol_file = NULL;
  for (i = 1; i < argc; i++) 
  { 
    if (has_extension( argv[i], "all" )) 
    { 
      set_file_name( &rule_file, argv[i] );
      set_binary_file_name( &object_file, argv[i] );
      file_type = ALLO_RULE_FILE;
    } 
    else if (has_extension( argv[i], "mor" )) 
    { 
      set_file_name( &rule_file, argv[i] );
      set_binary_file_name( &object_file, argv[i] );
      file_type = MORPHO_RULE_FILE;
    }
    else if (has_extension( argv[i], "syn" )) 
    { 
      set_file_name( &rule_file, argv[i] );
      set_binary_file_name( &object_file, argv[i] );
      file_type = SYNTAX_RULE_FILE;
    }
    else if (has_extension( argv[i], "sym" )) 
      set_binary_file_name( &symbol_file, argv[i] );
    else if (has_extension( argv[i], "esym" ))
      set_binary_file_name( &symbol_file, argv[i] );
    else 
      complain( "Illegal argument \"%s\".", argv[i] );
  }
  if (object_file == NULL) 
    complain( "No file to compile." );
  if (symbol_file == NULL) 
    complain( "Missing symbol file name." );

  init_values();
  init_symbols( symbol_file );
  init_hangul();
  init_scanner();

  compile_rule_file( rule_file, object_file, file_type );

  terminate_hangul();
  terminate_symbols();
  terminate_values();
  terminate_scanner();
  terminate_patterns();
  free_mem( &symbol_file );

  free_mem( &object_file );
  free_mem( &rule_file );
  terminate_basic();

  return 0;
}

/* End of file. =============================================================*/
