/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* Debugger functions. */

/* Types. ===================================================================*/

typedef enum /* Debugger modes (set by "set_debug_mode"). */
{ 
  RUN_MODE, /* Ignore breakpoints. */
  GO_MODE, /* Stop at breakpoints. */
  WALK_MODE, /* Stop at breakpoints and rule starts. */
  NEXT_MODE, /* Stop at new source lines; walk over subrules. */
  STEP_MODE, /* Stop at new source lines. */
  FINISH_MODE /* Stop at return from current rule or subrule */
} debug_mode_t;

/* Variables ================================================================*/

extern bool_t in_debugger; /* TRUE iff in debugger loop. Read only! */

/* Functions. ===============================================================*/

extern void init_debugger( void (*my_display_where)( void ), 
			   command_t *my_debugger_commands[] );
/* Initialise the debugger module.
 * The function MY_DISPLAY_WHERE is a callback to display where rule 
 * execution currently stands at.
 * MY_DEBUGGER_COMMANDS is an array of commands that can be invoked
 * in debug mode. */

extern void terminate_debugger( void );
/* Terminate the run time environment. */

extern void set_debug_mode( debug_mode_t debug_mode, rule_sys_t *rule_sys );
/* Set debug mode DEBUG_MODE for RULE_SYS. */

extern debug_mode_t get_debug_mode( void );
/* Get the current debug mode. */

extern void assert_not_in_debug_mode( void );
/* Make sure we are _not_ in debug mode. */

extern void assert_in_debug_mode( void );
/* Make sure we _are_ in debug mode. */

/* Commands. ================================================================*/

extern command_t variables_command;
/* Generate variables file and start program to display variables. */

extern command_t run_command; /* Execute rules in non-debugging mode. */

extern command_t walk_command; /* Execute rules until different rule. */

extern command_t continue_command; /* Execute rules until breakpoint. */

extern command_t step_command; /* Execute rules until different line. */

extern command_t next_command; /* Execute rules until different line,
                                * but jump over subrules. */

extern command_t finish_command; /* Stop at end off current rule or subrule. */

extern command_t print_command; /* Print the values of variables. */

extern command_t frame_command; /* Select a new frame for debugging. */

extern command_t down_command; /* Go to called frame. */

extern command_t up_command; /* Go to calling frame. */

extern command_t backtrace_command;
/* Print all active subrules and rules in reverse order. */

extern command_t where_command;
/* Print where rule execution currently stands at. */

/* End of file. =============================================================*/
