/* Generated by GOB (v2.0.11) on Sun Mar  6 22:34:28 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-shell.h"

#include "mn-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "mn-shell.gob"

#include "config.h"
#include <errno.h>
#include <gnome.h>
#include <eel/eel.h>
#include "mn-properties-dialog.h"
#include "mn-util.h"
#include "mn-conf.h"
#include "mn-mailboxes.h"
#include "mn-unsupported-mailbox.h"
#include "mn-about-dialog.h"
#include "mn-summary-popup.h"
#include "mn-main-window.h"
#include "mn-message-view.h"

  MNShell *mn_shell = NULL;

#line 45 "mn-shell.c"
/* self casting macros */
#define SELF(x) MN_SHELL(x)
#define SELF_CONST(x) MN_SHELL_CONST(x)
#define IS_SELF(x) MN_IS_SHELL(x)
#define TYPE_SELF MN_TYPE_SHELL
#define SELF_CLASS(x) MN_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) MN_SHELL_GET_CLASS(x)

/* self typedefs */
typedef MNShell Self;
typedef MNShellClass SelfClass;

/* here are local prototypes */
static void mn_shell_class_init (MNShellClass * c) G_GNUC_UNUSED;
static void mn_shell_init (MNShell * self) G_GNUC_UNUSED;
static void ___2_mn_shell_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_init_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_summary_tooltip_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_main_window_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_update_sensitivity (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_tooltip (MNShell * self) G_GNUC_UNUSED;
static int mn_shell_new_mailboxes_compare_func (gconstpointer a, gconstpointer b) G_GNUC_UNUSED;
static time_t mn_shell_get_latest_sent_time (MNMailbox * mailbox) G_GNUC_UNUSED;
static int mn_shell_mailboxes_compare_by_name_func (gconstpointer a, gconstpointer b) G_GNUC_UNUSED;
static GtkWidget * mn_shell_tooltip_section_new (GtkVBox * vbox, const char * title) G_GNUC_UNUSED;
static void mn_shell_tooltip_text_section_new (GtkVBox * vbox, const char * title, const char * text) G_GNUC_UNUSED;
static void mn_shell_welcome_response_h (GtkDialog * dialog, int response, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_messages_changed_h mn_shell_messages_changed_h
#define self_mailbox_removed_h mn_shell_mailbox_removed_h
#define self_init_icon mn_shell_init_icon
#define self_notify_blink_on_errors_cb mn_shell_notify_blink_on_errors_cb
#define self_notify_mail_reader_cb mn_shell_notify_mail_reader_cb
#define self_notify_summary_tooltip_cb mn_shell_notify_summary_tooltip_cb
#define self_icon_activate_h mn_shell_icon_activate_h
#define self_icon_activate_main_window_h mn_shell_icon_activate_main_window_h
#define self_icon_activate_mail_reader_h mn_shell_icon_activate_mail_reader_h
#define self_icon_activate_update_h mn_shell_icon_activate_update_h
#define self_icon_activate_properties_h mn_shell_icon_activate_properties_h
#define self_icon_activate_help_h mn_shell_icon_activate_help_h
#define self_icon_activate_about_h mn_shell_icon_activate_about_h
#define self_icon_activate_remove_h mn_shell_icon_activate_remove_h
#define self_icon_destroy_h mn_shell_icon_destroy_h
#define self_update_sensitivity mn_shell_update_sensitivity
#define self_update_icon mn_shell_update_icon
#define self_update_tooltip mn_shell_update_tooltip
#define self_new_mailboxes_compare_func mn_shell_new_mailboxes_compare_func
#define self_get_latest_sent_time mn_shell_get_latest_sent_time
#define self_mailboxes_compare_by_name_func mn_shell_mailboxes_compare_by_name_func
#define self_tooltip_section_new mn_shell_tooltip_section_new
#define self_tooltip_text_section_new mn_shell_tooltip_text_section_new
#define self_new mn_shell_new
#define self_display_about_dialog mn_shell_display_about_dialog
#define self_display_welcome_dialog mn_shell_display_welcome_dialog
#define self_welcome_response_h mn_shell_welcome_response_h
#define self_report mn_shell_report
#define self_add_mailbox_properties_dialog mn_shell_add_mailbox_properties_dialog
#define self_mailbox_properties_dialog_weak_notify_cb mn_shell_mailbox_properties_dialog_weak_notify_cb
#define self_get_mailbox_properties_dialog mn_shell_get_mailbox_properties_dialog
GType
mn_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNShell *)g_object_new(mn_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNShell *
GET_NEW_VARG (const char *first, ...)
{
	MNShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNShell *)g_object_new_valist (mn_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::dispose"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 49 "mn-shell.gob"
	if(self->mailboxes) { g_object_unref ((gpointer) self->mailboxes); self->mailboxes = NULL; }
#line 176 "mn-shell.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 80 "mn-shell.gob"
	___2_mn_shell_finalize(obj_self);
#line 189 "mn-shell.c"
}
#undef __GOB_FUNCTION__

static void 
mn_shell_class_init (MNShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 80 "mn-shell.gob"
	g_object_class->finalize = ___finalize;
#line 205 "mn-shell.c"
	g_object_class->dispose = ___dispose;
}
#undef __GOB_FUNCTION__
#line 55 "mn-shell.gob"
static void 
mn_shell_init (MNShell * self G_GNUC_UNUSED)
#line 212 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,MNShellPrivate);
#line 49 "mn-shell.gob"
	self->mailboxes = mn_mailboxes_new();
#line 218 "mn-shell.c"
 {
#line 56 "mn-shell.gob"

    g_return_if_fail(mn_shell == NULL);
    mn_shell = self;
    eel_add_weak_pointer(&mn_shell);

    self_init_icon(self);

    eel_gconf_notification_add(MN_CONF_BLINK_ON_ERRORS, self_notify_blink_on_errors_cb, self);
    eel_gconf_notification_add(MN_CONF_COMMANDS_MAIL_READER_NAMESPACE, self_notify_mail_reader_cb, self);
    eel_gconf_notification_add(MN_CONF_SUMMARY_TOOLTIP, self_notify_summary_tooltip_cb, self);

    g_object_connect(self->mailboxes,
		     "signal::messages-changed", self_messages_changed_h, self,
		     "signal::mailbox-removed", self_mailbox_removed_h, self,
		     "swapped-signal::notify::must-poll", self_update_sensitivity, self,
		     "swapped-signal::list-changed", self_update_tooltip, self,
		     "swapped-signal::list-changed", self_update_icon, self,
		     "swapped-signal::error-changed", self_update_tooltip, self,
		     "swapped-signal::error-changed", self_update_icon, self,
		     NULL);

    mn_summary_popup_init();
  
#line 244 "mn-shell.c"
 }
}
#undef __GOB_FUNCTION__



#line 80 "mn-shell.gob"
static void 
___2_mn_shell_finalize (GObject * object G_GNUC_UNUSED)
#line 254 "mn-shell.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
{
#line 82 "mn-shell.gob"
	
    gtk_main_quit();
    PARENT_HANDLER(object);
  }}
#line 266 "mn-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 87 "mn-shell.gob"
static void 
mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data)
#line 273 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::messages_changed_h"
#line 87 "mn-shell.gob"
	g_return_if_fail (mailboxes != NULL);
#line 87 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOXES (mailboxes));
#line 87 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 282 "mn-shell.c"
{
#line 91 "mn-shell.gob"
	
    Self *self = user_data;

    if (has_new)
      {
	gnome_triggers_do(_("You have new mail."), NULL, "mail-notification", "new-mail", NULL);
	if (mn_conf_has_command(MN_CONF_COMMANDS_NEW_MAIL_NAMESPACE))
	  mn_execute_command(MN_CONF_COMMANDS_NEW_MAIL_COMMAND);
      }

    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 298 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 105 "mn-shell.gob"
static void 
mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
#line 304 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_removed_h"
#line 105 "mn-shell.gob"
	g_return_if_fail (mailboxes != NULL);
#line 105 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOXES (mailboxes));
#line 105 "mn-shell.gob"
	g_return_if_fail (mailbox != NULL);
#line 105 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 105 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 317 "mn-shell.c"
{
#line 109 "mn-shell.gob"
	
    Self *self = user_data;
    MNMailboxPropertiesDialog *dialog;

    /* destroy the associated properties dialog, if any */
    dialog = self_get_mailbox_properties_dialog(self, mailbox->uri);
    if (dialog)
      gtk_widget_destroy(GTK_WIDGET(dialog));
  }}
#line 329 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 119 "mn-shell.gob"
static void 
mn_shell_init_icon (MNShell * self)
#line 335 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init_icon"
#line 119 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 119 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 342 "mn-shell.c"
{
#line 121 "mn-shell.gob"
	
    selfp->icon = MN_MAIL_ICON(mn_mail_icon_new());

    g_object_connect(selfp->icon,
		     "signal::activate", self_icon_activate_h, self,
		     "signal::activate-main-window", self_icon_activate_main_window_h, self,
		     "signal::activate-mail-reader", self_icon_activate_mail_reader_h, self,
		     "signal::activate-update", self_icon_activate_update_h, self,
		     "signal::activate-properties", self_icon_activate_properties_h, self,
		     "signal::activate-help", self_icon_activate_help_h, self,
		     "signal::activate-about", self_icon_activate_about_h, self,
		     "signal::activate-remove", self_icon_activate_remove_h, self,
		     "signal::destroy", self_icon_destroy_h, self,
		     NULL);
		     
    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 364 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 141 "mn-shell.gob"
static void 
mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 370 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_blink_on_errors_cb"
#line 141 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 375 "mn-shell.c"
{
#line 146 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_icon(self);
    GDK_THREADS_LEAVE();
  }}
#line 385 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 154 "mn-shell.gob"
static void 
mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 391 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_reader_cb"
#line 154 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 396 "mn-shell.c"
{
#line 159 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_sensitivity(self);
    GDK_THREADS_LEAVE();
  }}
#line 406 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 167 "mn-shell.gob"
static void 
mn_shell_notify_summary_tooltip_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 412 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_summary_tooltip_cb"
#line 167 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 417 "mn-shell.c"
{
#line 172 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_tooltip(self);
    GDK_THREADS_LEAVE();
  }}
#line 427 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 180 "mn-shell.gob"
static void 
mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data)
#line 433 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_h"
#line 180 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 180 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 180 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 442 "mn-shell.c"
{
#line 183 "mn-shell.gob"
	
    MNShell *self = user_data;
    MNAction action;

    action = mn_conf_get_enum_value(MN_TYPE_ACTION, MN_CONF_DOUBLE_CLICK_ACTION_2);

    switch (action)
      {
      case MN_ACTION_DISPLAY_MAIN_WINDOW:
	mn_main_window_display();
	break;

      case MN_ACTION_LAUNCH_MAIL_READER:
	if (mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READER_NAMESPACE))
	  mn_execute_command(MN_CONF_COMMANDS_MAIL_READER_COMMAND);
	break;

      case MN_ACTION_UPDATE_MAIL_STATUS:
	mn_mailboxes_check(self->mailboxes);
	break;

      default:
	g_return_if_reached();
      }
  }}
#line 470 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 209 "mn-shell.gob"
static void 
mn_shell_icon_activate_main_window_h (MNMailIcon * icon, gpointer user_data)
#line 476 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_main_window_h"
#line 209 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 209 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 209 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 485 "mn-shell.c"
{
#line 212 "mn-shell.gob"
	
    mn_main_window_display();
  }}
#line 491 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 216 "mn-shell.gob"
static void 
mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data)
#line 497 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_mail_reader_h"
#line 216 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 216 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 216 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 506 "mn-shell.c"
{
#line 219 "mn-shell.gob"
	
    mn_execute_command(MN_CONF_COMMANDS_MAIL_READER_COMMAND);
  }}
#line 512 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 223 "mn-shell.gob"
static void 
mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data)
#line 518 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_update_h"
#line 223 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 223 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 223 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 527 "mn-shell.c"
{
#line 226 "mn-shell.gob"
	
    Self *self = user_data;
    mn_mailboxes_check(self->mailboxes);
  }}
#line 534 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 231 "mn-shell.gob"
static void 
mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data)
#line 540 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_properties_h"
#line 231 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 231 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 231 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 549 "mn-shell.c"
{
#line 234 "mn-shell.gob"
	
    mn_properties_dialog_display();
  }}
#line 555 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 238 "mn-shell.gob"
static void 
mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data)
#line 561 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_help_h"
#line 238 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 238 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 238 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 570 "mn-shell.c"
{
#line 241 "mn-shell.gob"
	
    mn_display_help(NULL, NULL);
  }}
#line 576 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 245 "mn-shell.gob"
static void 
mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data)
#line 582 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_about_h"
#line 245 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 245 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 245 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 591 "mn-shell.c"
{
#line 248 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_about_dialog(self);
  }}
#line 598 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 253 "mn-shell.gob"
static void 
mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data)
#line 604 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_remove_h"
#line 253 "mn-shell.gob"
	g_return_if_fail (icon != NULL);
#line 253 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAIL_ICON (icon));
#line 253 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 613 "mn-shell.c"
{
#line 256 "mn-shell.gob"
	
    Self *self = user_data;
    g_object_unref(self);
  }}
#line 620 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 261 "mn-shell.gob"
static void 
mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data)
#line 626 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_destroy_h"
#line 261 "mn-shell.gob"
	g_return_if_fail (object != NULL);
#line 261 "mn-shell.gob"
	g_return_if_fail (GTK_IS_OBJECT (object));
#line 261 "mn-shell.gob"
	g_return_if_fail (user_data != NULL);
#line 635 "mn-shell.c"
{
#line 264 "mn-shell.gob"
	
    Self *self = user_data;

    /* The Notification Area applet has been terminated. Recreate the icon. */
    self_init_icon(self);
  }}
#line 644 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 271 "mn-shell.gob"
static void 
mn_shell_update_sensitivity (MNShell * self)
#line 650 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_sensitivity"
#line 271 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 271 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 657 "mn-shell.c"
{
#line 273 "mn-shell.gob"
	
    gtk_widget_set_sensitive(selfp->icon->mail_reader_item, mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READER_NAMESPACE));
    gtk_widget_set_sensitive(selfp->icon->update_item, mn_mailboxes_get_must_poll(self->mailboxes));
  }}
#line 664 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 278 "mn-shell.gob"
static void 
mn_shell_update_icon (MNShell * self)
#line 670 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_icon"
#line 278 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 278 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 677 "mn-shell.c"
{
#line 280 "mn-shell.gob"
	
    GSList *l;
    gboolean has_new = FALSE;
    gboolean blink = FALSE;

    MN_LIST_FOREACH(l, mn_mailboxes_get(self->mailboxes))
      {
	MNMailbox *mailbox = l->data;

	if (mn_mailbox_get_messages(mailbox))
	  has_new = TRUE;
	if (mn_mailbox_get_error(mailbox) || MN_IS_UNSUPPORTED_MAILBOX(mailbox))
	  blink = TRUE;
      }

    if (selfp->has_new && ! has_new && mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READ_NAMESPACE))
      mn_execute_command(MN_CONF_COMMANDS_MAIL_READ_COMMAND);
    selfp->has_new = has_new;
    
    if (blink && ! eel_gconf_get_boolean(MN_CONF_BLINK_ON_ERRORS))
      blink = FALSE;

    if (has_new || blink)
      {
	mn_blinking_image_set_blinking(MN_BLINKING_IMAGE(selfp->icon->image), blink);
	gtk_widget_show(GTK_WIDGET(selfp->icon));
      }
    else
      gtk_widget_hide(GTK_WIDGET(selfp->icon));
  }}
#line 710 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 311 "mn-shell.gob"
static void 
mn_shell_update_tooltip (MNShell * self)
#line 716 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_tooltip"
#line 311 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 311 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 723 "mn-shell.c"
{
#line 313 "mn-shell.gob"
	
    GtkWidget *vbox;
    GSList *mailboxes;

    vbox = gtk_vbox_new(FALSE, 18);

    mailboxes = mn_mailboxes_get(self->mailboxes);
    if (mailboxes)
      {
	GSList *l;
	GSList *new_mailboxes = NULL;
	GSList *error_mailboxes = NULL;
	GSList *unsupported_mailboxes = NULL;

	MN_LIST_FOREACH(l, mailboxes)
          {
	    MNMailbox *mailbox = l->data;
	    
	    if (mn_mailbox_get_messages(mailbox))
	      new_mailboxes = g_slist_append(new_mailboxes, mailbox);

	    if (mn_mailbox_get_error(mailbox))
	      error_mailboxes = g_slist_append(error_mailboxes, mailbox);

	    if (MN_IS_UNSUPPORTED_MAILBOX(mailbox))
	      unsupported_mailboxes = g_slist_append(unsupported_mailboxes, mailbox);
	  }

	if (new_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    new_mailboxes = g_slist_sort(new_mailboxes, self_new_mailboxes_compare_func);
	    MN_LIST_FOREACH(l, new_mailboxes)
	      {
		MNMailbox *mailbox = l->data;
		int n_messages;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append(string, mn_mailbox_get_name(mailbox));
		
		n_messages = g_slist_length(mn_mailbox_get_messages(mailbox));
		if (n_messages > 0)
		  g_string_append_printf(string, " (%i)", n_messages);
	      }
	    g_slist_free(new_mailboxes);
	    
	    self_tooltip_text_section_new(GTK_VBOX(vbox), _("Mailboxes Having New Mail"), string->str);
	    g_string_free(string, TRUE);
	  }

	if (error_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    error_mailboxes = g_slist_sort(error_mailboxes, self_mailboxes_compare_by_name_func);
	    MN_LIST_FOREACH(l, error_mailboxes)
	      {
		MNMailbox *mailbox = l->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append_printf(string, "%s: %s",
				       mn_mailbox_get_name(mailbox),
				       mn_mailbox_get_error(mailbox));
	      }
	    g_slist_free(error_mailboxes);

	    self_tooltip_text_section_new(GTK_VBOX(vbox), _("Errors"), string->str);
	    g_string_free(string, TRUE);
	  }
	
	if (unsupported_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    unsupported_mailboxes = g_slist_sort(unsupported_mailboxes, self_mailboxes_compare_by_name_func);
	    MN_LIST_FOREACH(l, unsupported_mailboxes)
	      {
		MNMailbox *mailbox = l->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append_printf(string, "%s: %s",
				       mn_mailbox_get_name(mailbox),
				       mn_unsupported_mailbox_get_reason(MN_UNSUPPORTED_MAILBOX(mailbox)));
	      }
	    g_slist_free(unsupported_mailboxes);
	    
	    self_tooltip_text_section_new(GTK_VBOX(vbox), _("Unsupported Mailboxes"), string->str);
	    g_string_free(string, TRUE);
	  }
      }

    if (eel_gconf_get_boolean(MN_CONF_SUMMARY_TOOLTIP))
      {
	GSList *messages;
	
	messages = mn_mailboxes_get_messages(mn_shell->mailboxes);
	if (messages)
	  {
	    GtkWidget *alignment;
	    GtkWidget *message_view;
	
	    alignment = self_tooltip_section_new(GTK_VBOX(vbox), _("Mail Summary"));
	    
	    message_view = mn_message_view_new(TRUE, FALSE);
	    gtk_widget_set_name(message_view, "mn-message-view");
	    
	    mn_message_view_set_messages(MN_MESSAGE_VIEW(message_view), messages);
	    mn_g_object_slist_free(messages);
	    
	    gtk_container_add(GTK_CONTAINER(alignment), message_view);
	  }
      }

    gtk_widget_show_all(vbox);
    mn_mail_icon_set_tip_widget(selfp->icon, vbox);
  }}
#line 846 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 434 "mn-shell.gob"
static int 
mn_shell_new_mailboxes_compare_func (gconstpointer a, gconstpointer b)
#line 852 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new_mailboxes_compare_func"
{
#line 436 "mn-shell.gob"
	
    MNMailbox *mailbox_a = (MNMailbox *) a;
    MNMailbox *mailbox_b = (MNMailbox *) b;
    int cmp;

    /* sort by sent time (descending order) */
    cmp = self_get_latest_sent_time(mailbox_b) - self_get_latest_sent_time(mailbox_a);
    /* else sort by number of messages (descending order) */
    if (cmp == 0)
      cmp = g_slist_length(mn_mailbox_get_messages(mailbox_b)) - g_slist_length(mn_mailbox_get_messages(mailbox_a));
    /* else sort by name (ascending order) */
    if (cmp == 0)
      cmp = self_mailboxes_compare_by_name_func(a, b);

    return cmp;
  }}
#line 873 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 453 "mn-shell.gob"
static time_t 
mn_shell_get_latest_sent_time (MNMailbox * mailbox)
#line 879 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_latest_sent_time"
#line 453 "mn-shell.gob"
	g_return_val_if_fail (mailbox != NULL, (time_t )0);
#line 453 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (time_t )0);
#line 886 "mn-shell.c"
{
#line 455 "mn-shell.gob"
	
    GSList *l;
    time_t latest = 0;

    MN_LIST_FOREACH(l, mn_mailbox_get_messages(mailbox))
      {
	MNMessage *message = l->data;

	if (message->sent_time > latest)
	  latest = message->sent_time;
      }

    return latest;
  }}
#line 903 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 470 "mn-shell.gob"
static int 
mn_shell_mailboxes_compare_by_name_func (gconstpointer a, gconstpointer b)
#line 909 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailboxes_compare_by_name_func"
{
#line 472 "mn-shell.gob"
	
    MNMailbox *mailbox_a = (MNMailbox *) a;
    MNMailbox *mailbox_b = (MNMailbox *) b;

    return mn_utf8_strcasecoll(mn_mailbox_get_name(mailbox_a),
			       mn_mailbox_get_name(mailbox_b));
  }}
#line 921 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 480 "mn-shell.gob"
static GtkWidget * 
mn_shell_tooltip_section_new (GtkVBox * vbox, const char * title)
#line 927 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_section_new"
#line 480 "mn-shell.gob"
	g_return_val_if_fail (vbox != NULL, (GtkWidget * )0);
#line 480 "mn-shell.gob"
	g_return_val_if_fail (GTK_IS_VBOX (vbox), (GtkWidget * )0);
#line 480 "mn-shell.gob"
	g_return_val_if_fail (title != NULL, (GtkWidget * )0);
#line 936 "mn-shell.c"
{
#line 483 "mn-shell.gob"
	
    GtkWidget *child_vbox;
    char *markup;
    GtkWidget *alignment;
    GtkWidget *label;

    child_vbox = gtk_vbox_new(FALSE, 6);

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>", title);
    label = gtk_label_new(markup);
    g_free(markup);

    gtk_widget_set_name(label, "mn-tooltip-section-title");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_label_set_use_markup(GTK_LABEL(label), TRUE);

    gtk_box_pack_start(GTK_BOX(child_vbox), label, FALSE, FALSE, 0);

    alignment = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
    gtk_alignment_set_padding(GTK_ALIGNMENT(alignment), 0, 0, 12, 0);

    gtk_box_pack_start(GTK_BOX(child_vbox), alignment, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), child_vbox, TRUE, TRUE, 0);

    return alignment;
  }}
#line 965 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 510 "mn-shell.gob"
static void 
mn_shell_tooltip_text_section_new (GtkVBox * vbox, const char * title, const char * text)
#line 971 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_text_section_new"
#line 510 "mn-shell.gob"
	g_return_if_fail (vbox != NULL);
#line 510 "mn-shell.gob"
	g_return_if_fail (GTK_IS_VBOX (vbox));
#line 510 "mn-shell.gob"
	g_return_if_fail (title != NULL);
#line 510 "mn-shell.gob"
	g_return_if_fail (text != NULL);
#line 982 "mn-shell.c"
{
#line 514 "mn-shell.gob"
	
    GtkWidget *alignment;
    GtkWidget *label;

    alignment = self_tooltip_section_new(GTK_VBOX(vbox), title);

    label = gtk_label_new(text);
    gtk_widget_set_name(label, "mn-tooltip-section-body");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

    gtk_container_add(GTK_CONTAINER(alignment), label);
  }}
#line 997 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 527 "mn-shell.gob"
MNShell * 
mn_shell_new (void)
#line 1003 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new"
{
#line 529 "mn-shell.gob"
	
    return GET_NEW;
  }}
#line 1011 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 533 "mn-shell.gob"
void 
mn_shell_display_about_dialog (MNShell * self)
#line 1017 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_about_dialog"
#line 533 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 533 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1024 "mn-shell.c"
{
#line 535 "mn-shell.gob"
	
    if (selfp->about)
      {
	gtk_window_present(GTK_WINDOW(selfp->about));
	return;
      }
    
    selfp->about = mn_about_dialog_new();
    eel_add_weak_pointer(&selfp->about);
    
    mn_main_window_add_transient(GTK_WINDOW(selfp->about));
    gtk_widget_show(GTK_WIDGET(selfp->about));
  }}
#line 1040 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 549 "mn-shell.gob"
void 
mn_shell_display_welcome_dialog (MNShell * self)
#line 1046 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_welcome_dialog"
#line 549 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 549 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1053 "mn-shell.c"
{
#line 551 "mn-shell.gob"
	
    GtkWidget *dialog;

    mn_create_interface(MN_INTERFACE_FILE("welcome.glade"), "dialog", &dialog, NULL);
    gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_OK);

    g_signal_connect(dialog, "response", G_CALLBACK(self_welcome_response_h), NULL);
    gtk_widget_show(dialog);
  }}
#line 1065 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 561 "mn-shell.gob"
static void 
mn_shell_welcome_response_h (GtkDialog * dialog, int response, gpointer user_data)
#line 1071 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::welcome_response_h"
#line 561 "mn-shell.gob"
	g_return_if_fail (dialog != NULL);
#line 561 "mn-shell.gob"
	g_return_if_fail (GTK_IS_DIALOG (dialog));
#line 1078 "mn-shell.c"
{
#line 565 "mn-shell.gob"
	
    gtk_widget_destroy(GTK_WIDGET(dialog));
    if (response == GTK_RESPONSE_OK)
      mn_properties_dialog_display();
  }}
#line 1086 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 571 "mn-shell.gob"
void 
mn_shell_report (MNShell * self, char ** report)
#line 1092 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::report"
#line 571 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 571 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 571 "mn-shell.gob"
	g_return_if_fail (report != NULL);
#line 1101 "mn-shell.c"
{
#line 573 "mn-shell.gob"
	
    GString *string;
    GSList *l;

    string = g_string_new(NULL);
    MN_LIST_FOREACH(l, mn_mailboxes_get(self->mailboxes))
      {
	MNMailbox *mailbox = l->data;
	const char *error;

	error = mn_mailbox_get_error(mailbox);

	g_string_append_printf(string, "%s\n", mailbox->uri->text);

	if (mn_mailbox_get_messages(mailbox))
	  g_string_append(string, " has-new\n");
	if (error)
	  g_string_append_printf(string, " error %s\n", error);
	if (MN_IS_UNSUPPORTED_MAILBOX(mailbox))
	  g_string_append_printf(string, " unsupported %s\n", mn_unsupported_mailbox_get_reason(MN_UNSUPPORTED_MAILBOX(mailbox)));
      }

    *report = string->str;
    g_string_free(string, FALSE);
  }}
#line 1129 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 599 "mn-shell.gob"
void 
mn_shell_add_mailbox_properties_dialog (MNShell * self, MNMailboxPropertiesDialog * dialog)
#line 1135 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::add_mailbox_properties_dialog"
#line 599 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 599 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 599 "mn-shell.gob"
	g_return_if_fail (dialog != NULL);
#line 599 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (dialog));
#line 1146 "mn-shell.c"
{
#line 601 "mn-shell.gob"
	
    g_return_if_fail(mn_mailbox_properties_dialog_get_uri(dialog) != NULL);

    selfp->mailbox_properties_dialogs = g_slist_append(selfp->mailbox_properties_dialogs, dialog);
    g_object_weak_ref(G_OBJECT(dialog), self_mailbox_properties_dialog_weak_notify_cb, self);
  }}
#line 1155 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 608 "mn-shell.gob"
static void 
mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object)
#line 1161 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_properties_dialog_weak_notify_cb"
#line 608 "mn-shell.gob"
	g_return_if_fail (data != NULL);
#line 1166 "mn-shell.c"
{
#line 611 "mn-shell.gob"
	
    Self *self = data;

    selfp->mailbox_properties_dialogs = g_slist_remove(selfp->mailbox_properties_dialogs, former_object);
  }}
#line 1174 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 617 "mn-shell.gob"
MNMailboxPropertiesDialog * 
mn_shell_get_mailbox_properties_dialog (MNShell * self, MNURI * uri)
#line 1180 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_mailbox_properties_dialog"
#line 617 "mn-shell.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxPropertiesDialog * )0);
#line 617 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (MNMailboxPropertiesDialog * )0);
#line 617 "mn-shell.gob"
	g_return_val_if_fail (uri != NULL, (MNMailboxPropertiesDialog * )0);
#line 617 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (MNMailboxPropertiesDialog * )0);
#line 1191 "mn-shell.c"
{
#line 619 "mn-shell.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->mailbox_properties_dialogs)
      {
	MNMailboxPropertiesDialog *dialog = l->data;
	MNURI *this_uri;

	this_uri = mn_mailbox_properties_dialog_get_uri(dialog);
	if (! strcmp(this_uri->text, uri->text))
	  return dialog;
      }

    return NULL;
  }}
#line 1209 "mn-shell.c"
#undef __GOB_FUNCTION__
static const GEnumValue _mn_position_values[] = {
	{ MN_POSITION_TOP_LEFT, (char *)"MN_POSITION_TOP_LEFT", (char *)"top-left" },
	{ MN_POSITION_TOP_RIGHT, (char *)"MN_POSITION_TOP_RIGHT", (char *)"top-right" },
	{ MN_POSITION_BOTTOM_LEFT, (char *)"MN_POSITION_BOTTOM_LEFT", (char *)"bottom-left" },
	{ MN_POSITION_BOTTOM_RIGHT, (char *)"MN_POSITION_BOTTOM_RIGHT", (char *)"bottom-right" },
	{ 0, NULL, NULL }
};

GType
mn_position_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPosition", _mn_position_values);
	return type;
}

static const GEnumValue _mn_action_values[] = {
	{ MN_ACTION_DISPLAY_MAIN_WINDOW, (char *)"MN_ACTION_DISPLAY_MAIN_WINDOW", (char *)"display-main-window" },
	{ MN_ACTION_LAUNCH_MAIL_READER, (char *)"MN_ACTION_LAUNCH_MAIL_READER", (char *)"launch-mail-reader" },
	{ MN_ACTION_UPDATE_MAIL_STATUS, (char *)"MN_ACTION_UPDATE_MAIL_STATUS", (char *)"update-mail-status" },
	{ 0, NULL, NULL }
};

GType
mn_action_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAction", _mn_action_values);
	return type;
}

static const GEnumValue _mn_toolbar_style_values[] = {
	{ MN_TOOLBAR_STYLE_ICONS, (char *)"MN_TOOLBAR_STYLE_ICONS", (char *)"icons" },
	{ MN_TOOLBAR_STYLE_TEXT, (char *)"MN_TOOLBAR_STYLE_TEXT", (char *)"text" },
	{ MN_TOOLBAR_STYLE_BOTH, (char *)"MN_TOOLBAR_STYLE_BOTH", (char *)"both" },
	{ MN_TOOLBAR_STYLE_BOTH_HORIZ, (char *)"MN_TOOLBAR_STYLE_BOTH_HORIZ", (char *)"both-horiz" },
	{ MN_TOOLBAR_STYLE_DESKTOP_DEFAULT, (char *)"MN_TOOLBAR_STYLE_DESKTOP_DEFAULT", (char *)"desktop-default" },
	{ 0, NULL, NULL }
};

GType
mn_toolbar_style_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNToolbarStyle", _mn_toolbar_style_values);
	return type;
}

static const GEnumValue _mn_aspect_source_values[] = {
	{ MN_ASPECT_SOURCE_THEME, (char *)"MN_ASPECT_SOURCE_THEME", (char *)"theme" },
	{ MN_ASPECT_SOURCE_CUSTOM, (char *)"MN_ASPECT_SOURCE_CUSTOM", (char *)"custom" },
	{ 0, NULL, NULL }
};

GType
mn_aspect_source_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAspectSource", _mn_aspect_source_values);
	return type;
}

