/***************************************************************************
                          hbciseg.h  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifndef HBCISEG_H
#define HBCISEG_H


#include <string>

#include <openhbci/pointer.h>
#include <openhbci/user.h>

using namespace std;

namespace HBCI {

/**
 * @short Abstract base class for any segment used in OpenHBCI.
 * @author fabian Kaiser (adapted by Martin Preuss<openhbci@aquamaniac.de>)
 */
class DLLIMPORT Seg {
protected:
    Pointer<Customer> _customer;
    //Pointer<User> _user;
    Pointer<Bank> _bank;
    int _hbciversion;
    int _segnumber;

    Seg();
public:
    Seg(Pointer<Customer> cust);
    virtual ~Seg();

    virtual string toString(int segnr) {return "";};
    virtual bool parse(const string &segment, unsigned int pos) 
        { return false;};

    /**
     * This method allowes to parse a HBCI-KTV-element. 
     * KTV stands for "Kontoverbindung" and contains the account number, 
     * an account suffix (optional, since hbci_210), the bank code and
     * the bank's country code. 
     * @author Fabian Kaiser 
     */
    static bool parse_ktv(const string& de, 
		   string& accountNumber, 
		   string& accountSuffix, 
		   string& bankCode, 
		   int& countryCode);

    /**
     * This is used to switch between the different segmentversions in
     * the different hbciversions. The result is written into
     * versionMin and versionMax. */
    static void segment_number(int &versionMin, int &versionMax, 
			int hbciVersion, 
			int min201, int max201, 
			int min210, int max210, 
			int min220, int max220);
    
};

} /* namespace HBCI */

#endif

