/***************************************************************************
                          hbci.cpp  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "hbci.h"

#include <string>
#include <stdio.h>
#include <list>

#include "assert.h"
#include "error.h"
#include "pointer.h"
#include "auth.h"
#include "interactor.h"
#include "hbcistring.h"

namespace HBCI {


int Hbci::_debugLevel=0;

int Hbci::debugLevel() {
    return _debugLevel;
}


void Hbci::setDebugLevel(int l) {
    _debugLevel=l;
}

static string numToOneChar(unsigned int num)
{
    return (num < 10 ?
	    // from 0 to 9 return the one-digit number
	    String::num2string(num) :
	    (num < 10 + 26 ?
	     // from 10 to 35 return a lower case character
	     string(1, 'a' + (num - 10)) :
	     (num < 10 + 26 + 23 ?
	      // from 36 to 59 return an upper case character
	      string(1, 'A' + (num - 36)) :
	      // 60 and up: give up and return upper case X
	      "X")));
}
    

Hbci::Hbci(bool readonly, bool retrievalonly)
    : _readonly(readonly)
    , _retrievalOnly(retrievalonly)
{

    // set the system name and version to default values
    setSystemName(HBCI_SYSTEM_NAME);
    // set the system version -- we cannot use OPENHBCI_VERSION_STRING
    // directly because that one might easily be longer than 5
    // characters.
    setSystemVersion(String::num2string(OPENHBCI_VERSION_MAJOR)
		     + "." 
		     + numToOneChar(OPENHBCI_VERSION_MINOR)
		     + "."
		     + numToOneChar(OPENHBCI_VERSION_PATCHLEVEL));

    /* this is a default authentificator, this may be overwritten by the
     * main program.*/
    _auther.setDescription("HBCI::authentificator (HBCIAuth)");
    _auther=new Auth(this);
    _auther.setObjectDescription("HBCIAuth");

    _interactor.setDescription("HBCI::interactor");
    _interactor=new Interactor();
    _interactor.setObjectDescription("HBCIInteractor");
}


Hbci::~Hbci(){
}

void Hbci::libraryVersion(int &major,
			  int &minor,
			  int &patchlevel) {
    major=OPENHBCI_VERSION_MAJOR;
    minor=OPENHBCI_VERSION_MINOR;
    patchlevel=OPENHBCI_VERSION_PATCHLEVEL;
};
void Hbci::libraryVersion(int &major,
			  int &minor,
			  int &patchlevel,
			  int &build) {
    libraryVersion(major,minor,patchlevel);
    build=OPENHBCI_VERSION_BUILD;
};


void Hbci::setSystemName(const string &n) {
  // only use 25 characters starting from index 0 here
  _systemName=n.substr(0,25);
};


void Hbci::setSystemVersion(const string &s) {
  // only use 5 characters starting from index 0 here
  _systemVersion=s.substr(0,5);
};


} // namespace HBCI

// ----------- C Wrappers

void HBCI_Hbci_setInteractor(HBCI_Hbci *h, HBCI_Interactor *inter, 
			int autoDelete)
{
    assert(h);
    HBCI::Pointer<HBCI_Interactor> ip = inter;
    ip.setAutoDelete(autoDelete); 
    h->setInteractor(ip);
}
HBCI_Interactor *HBCI_Hbci_interactor(const HBCI_Hbci *h)
{
    assert(h);
    return h->interactor().ptr();
}
void HBCI_Hbci_libraryVersion(int *major, int *minor, int *plevel)
{
    assert(major);
    assert(minor);
    assert(plevel);
    HBCI::Hbci::libraryVersion(*major, *minor, *plevel);
}
void HBCI_Hbci_libraryVersion_build(int *major, int *minor, int *plevel,
				    int *pbuild)
{
    assert(major);
    assert(minor);
    assert(plevel);
    assert(pbuild);
    HBCI::Hbci::libraryVersion(*major, *minor, *plevel, *pbuild);
}
const char *HBCI_Hbci_systemName(const HBCI_Hbci *h)
{
    assert(h);
    return h->systemName().c_str();
}
void HBCI_Hbci_setSystemName(HBCI_Hbci *h, const char *n)
{
    assert(h);
    h->setSystemName(string(n ? n : ""));
}
const char *HBCI_Hbci_systemVersion(const HBCI_Hbci *h)
{
    assert(h);
    return h->systemVersion().c_str();
}
void HBCI_Hbci_setSystemVersion(HBCI_Hbci *h, const char *n)
{
    assert(h);
    h->setSystemVersion(string(n ? n : ""));
}
void HBCI_Hbci_setDebugLevel(int l)
{
    HBCI::Hbci::setDebugLevel(l);
}


