dnl $Id: acinclude.m4,v 1.4 2003/06/25 13:22:03 aquamaniac Exp $
dnl Author of this file: Martin Preuss<openhbci@aquamaniac.de>

AC_DEFUN(AQ_SEARCH_FOR_PATH,
[
dnl searches for a file in a path
dnl $1 = file to search
dnl $2 = paths to search in
dnl returns the directory where the file is found (found_dir)
found_dir=""
ls=$1
ld="$2"
for li in $ld; do
    if test -r "$li/$ls"; then
        found_dir="$li"
        break
    fi
done
])

AC_DEFUN(AQ_SEARCH_FILES,
[
dnl searches a dir for some files
dnl $1 = path where to search
dnl $2 = files to find
dnl returns the name of the file found (found_file)
found_file=""
ls="$1"
ld="$2"
lf=""
for li in $ld; do
#    lf2=`find "$ls" -maxdepth 1 -name "$li" 2>/dev/null`
    lf2=`ls $ls/$li 2>/dev/null`
    lf="$lf $lf2"
done
for li in $lf; do
    if test -r "$li"; then
	found_file=`basename "$li"`
	break
    fi
done
])

AC_DEFUN(AC_TYPE_SOCKLEN_T,
[AC_CACHE_CHECK([for socklen_t], ac_cv_type_socklen_t,
[
  AC_TRY_COMPILE(
  [#include <sys/socket.h>],
  [socklen_t len = 42; return len;],
  ac_cv_type_socklen_t=yes,
  ac_cv_type_socklen_t=no)
])
  if test $ac_cv_type_socklen_t != yes; then
    AC_DEFINE(socklen_t, int, [define to the type of the last arg of getsockopt])
  fi
])


dnl as-scrub-include.m4 0.0.1
dnl autostars m4 macro for scrubbing CFLAGS of system include dirs
dnl because gcc 3.x complains about including system including dirs
dnl
dnl thomas@apestaart.org
dnl
dnl This macro uses output of cpp -v and expects it to contain text that 
dnl looks a little bit like this:
dnl #include <...> search starts here:
dnl  /usr/local/include
dnl  /usr/lib/gcc-lib/i386-redhat-linux/3.2/include
dnl  /usr/include
dnl End of search list.

dnl AS_SCRUB_INCLUDE(VAR)
dnl example
dnl AS_SCRUB_INCLUDE(CFLAGS)
dnl will remove all system include dirs from the given CFLAGS

AC_DEFUN(AS_SCRUB_INCLUDE,
[
  GIVEN_CFLAGS=$[$1]
  INCLUDE_DIRS=`echo | cpp -v 2>&1`

  dnl remove everything from this output between the "starts here" and "End of"
  dnl line
  INCLUDE_DIRS=`echo $INCLUDE_DIRS | sed -e 's/.*<...> search starts here://' | sed -e 's/End of search list.*//'`
  for dir in $INCLUDE_DIRS; do
    GIVEN_CFLAGS=$(echo $GIVEN_CFLAGS | sed -e "s;-I$dir ;;" | sed -e "s;-I$dir$;;")
  done
  [$1]=$GIVEN_CFLAGS
])
