dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_rpi_ib_setup.m4,v 1.3 2004/01/02 22:43:35 vsahay Exp $
dnl

AC_DEFUN([LAM_RPI_IB_SETUP],[
#
# Arguments: none
#
# Dependencies: None
#
# Setup the ib RPI
#
# Sets:
#
# IBSHORT: subst
# IBTINY: subst
# IBPORT: subst
#

#
# Where is vapi.h/libvapi located?
#

IBDIR=
AC_ARG_WITH(ib, 
	    AC_HELP_STRING([--with-ib],
			   [obsolete synonym for --with-rpi-ib]),
            [IBDIR=$withval])
AC_ARG_WITH(rpi-ib, 
	    AC_HELP_STRING([--with-rpi-ib],
			   [directory where the ib software was installed]),
            [IBDIR=$withval])

#
# Check that we have all the right flags to compile with ib
#

WRAPPER_EXTRA_LDFLAGS=
WRAPPER_EXTRA_LIBS=" -lmosal -lmpga -lmtl_common -lvapi"

if test -n "$IBDIR"; then
    CPPFLAGS="$CPPFLAGS -I$IBDIR/include"
    AC_CHECK_HEADERS(vapi.h,,
	AC_MSG_ERROR([*** Cannot find working vapi.h.]))

    # Note that it is possible to find the library even if -L is not
    # specified, if the LD_LIBRARY_PATH includes the directory where
    # the shared ib library is kept.  Hence, we unset LD_LIBRARY_PATH
    # before running this test.

    LD_LIBRARY_PATH_save="$LD_LIBRARY_PATH"
    unset LD_LIBRARY_PATH

    LIBS_save="$LIBS"
    LDFLAGS_save="$LDFLAGS"
    WRAPPER_EXTRA_LDFLAGS="-L$IBDIR/lib"
    LIBS="$LIBS  -lmosal -lmpga -lmtl_common"
    LDFLAGS="$LDFLAGS $WRAPPER_EXTRA_LDFLAGS"
    AC_CHECK_LIB(vapi, VAPI_open_hca, [],
      AC_MSG_ERROR([*** Cannot find working libvapi.]) )
    LD_LIBRARY_PATH="$LD_LIBRARY_PATH_save"
#    LIBS="$LIBS_save"
else
    AC_CHECK_LIB(vapi, VAPI_open_hca,[],
      AC_MSG_ERROR([*** Cannot find working libvapi.]))
    AC_CHECK_HEADERS(vapi.h,,
      AC_MSG_ERROR([*** Cannot find working vapi.h]))
fi

AC_SUBST(WRAPPER_EXTRA_LDFLAGS)
AC_SUBST(WRAPPER_EXTRA_LIBS)

## Check command line args
## config/lam_rpi_ib_params.m4

LAM_SSI_RPI_IB_PARAMS
])dnl
