/***************************************************************************
                          kfvproject.cpp  -  description
                             -------------------
    begin                : Thu Aug 30 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfvproject.h"
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qframe.h>

#include <klineeditdlg.h>

#include "kfocustask.h"
#include "kfocuslogentry.h"
#include "kfocustasklist.h"
#include "kfocuslogbook.h"
#include "kfmproject.h"

#include "kfocuslogentriesview.h"
#include "kfocustasksview.h"
#include "kfocusdialogcompletetask.h"

KFVProject::KFVProject(QWidget *parent, const char *name ) : QFrame(parent,name) {
	project_ = NULL;
	
	createWidgets();
	
}

KFVProject::~KFVProject(){
}
	
	
/////////////////////////////////////////////////////////////
// Private methods

void KFVProject::createNameWidgets(QLayout* l){
		QHBoxLayout* hbl = new QHBoxLayout(l);
			hbl->setSpacing(5);
			
			QLabel* lName = new QLabel("Name ", this);
				hbl->addWidget(lName);
		
			leName_ = new QLineEdit("", this);
				leName_->setReadOnly(true);
				hbl->addWidget(leName_);
			
			hbl->addWidget(new QWidget(this));
			
			pbChange_ = new QPushButton("&Change", this);
				connect(pbChange_, SIGNAL(clicked()), this, SLOT(changeName()));
				hbl->addWidget(pbChange_);
}

void KFVProject::createContentWidgets(QLayout* l){
	QHBoxLayout* hbl = new QHBoxLayout(l);
	
		twContent_ = new QTabWidget(this);
			twContent_->setMargin(5);
			vTaskList_ = new KFVTaskList(twContent_);
				twContent_->addTab(vTaskList_, "Tasks");
			vLogBook_ = new KFVLogBook(twContent_);
				twContent_->addTab(vLogBook_, "Logs");
	
			hbl->addWidget(twContent_);	
}
	
void KFVProject::createWidgets(){
	setEnabled(false);

	QVBoxLayout* vbl1 = new QVBoxLayout(this);
	{
		vbl1->setSpacing(5);
		vbl1->setMargin(5);
		
		createNameWidgets(vbl1);
		
		QFrame* frame = new QFrame(this);
			frame->setFrameStyle(QFrame::HLine | QFrame::Raised);
			vbl1->addWidget(frame);
		
		createContentWidgets(vbl1);
	}
}


/** Slot to receive taskCompleted signal from KFVTaskList */
void KFVProject::onTaskCompleted(KFMTask* task){

	KFDCompleteTask dlg(project()->taskList()->size()-1, this);
	dlg.completedTask(task);
	
	if (dlg.exec() == QDialog::Accepted) {
		if (dlg.log() != NULL) {
			project()->logBook()->addEntry(new KFMLog(dlg.log()));
		}
		
		if (dlg.followupTask() != NULL) {
			project()->taskList()->insertTask(new KFMTask(dlg.followupTask()));
		}

		// Remove the task only after inserting the followup so that
		// the followup appears in its place.		
		project()->taskList()->removeTask(task);		
	}
}


////////////////////////////////////////////////////////////////////////
// Public methods

KFMProject* KFVProject::project() const{
	return project_;
}

void KFVProject::project(KFMProject* project){
	if (project != project_) {
		if (project_  != NULL) {
			// Do stuff to clear the project
			vLogBook_->logBook(NULL);
			

			disconnect(vTaskList_, 0, this, 0);
			vTaskList_->taskList(NULL);
			
			leName_->setText("");
			
			setEnabled(false);
		}
		
		project_ = project;
		
		if (project_ != NULL) {
			// Do stuff to activate the project
			setEnabled(true);
			
			leName_->setText(project_->name());
			
			vTaskList_->taskList(project_->taskList());
			connect(vTaskList_, SIGNAL( taskCompleted(KFMTask*) ), this,
				SLOT( onTaskCompleted(KFMTask*) ));	
			
			vLogBook_->logBook(project_->logBook());
		}
	}
}


void KFVProject::changeName(){
	bool ok;
	
	QString name =
		KLineEditDlg::getText("Enter a project name:", project_->name(), &ok, this);
		
	if (ok) {
		project_->name(name);
		
		// Update the lineedit.  However, project may become null due to signals
		// emitted when name is changed, so check it first.
		if (project_ != NULL) {
			leName_->setText(project_->name());
		}
	}
}
