//$Id: depthlist.cc,v 1.1 2004/01/26 22:08:38 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "depthlist.h"

#include "config.h"
#include <libgnome/libgnome.h>

using namespace Guikachu::GUI;

DepthList::DepthList (Resources::BitmapFamily *res_):
    res (res_),
    type (Resources::Bitmap::TYPE_COLOR_256),
    update_block (false)
{
    set_selection_mode (GTK_SELECTION_BROWSE);

    res->changed.connect (SigC::slot (this, &DepthList::update));
    update ();
}

void DepthList::update ()
{
    update_block = true;
    
    items ().clear ();
    
    add_item (Resources::Bitmap::TYPE_MONO,      _("Monochrome"));
    add_item (Resources::Bitmap::TYPE_GREY_4,    _("Greyscale (4 shades)"));
    add_item (Resources::Bitmap::TYPE_GREY_16,   _("Greyscale (16 shades)"));
    add_item (Resources::Bitmap::TYPE_COLOR_16,  _("Color (16 colors)"));
    add_item (Resources::Bitmap::TYPE_COLOR_256, _("Color (256 colors)"));
    add_item (Resources::Bitmap::TYPE_COLOR_16K, _("High Color (16k colors)"));    

//    std::cerr << "Type: " << type << std::endl;
//    select_item (type);

    update_block = false;
}

void DepthList::add_item (Resources::Bitmap::BitmapType item_type, const std::string &label)
{
    Gtk::ListItem *item;
    if (res->get_image (item_type).isValid ())
    {
        item = new Gtk::ListItem (label);
    } else {
        char *label_str = g_strdup_printf (_("%s (unset)"), label.c_str ());
        item = new Gtk::ListItem (label_str);
        g_free (label_str);
    }
    
    item->show ();
    add (*manage (item));

    if (item_type == type)
        item->select ();
    item->select.connect (SigC::bind (SigC::slot (this, &DepthList::item_select_cb), item_type));
}

void DepthList::item_select_cb (Resources::Bitmap::BitmapType item_type)
{
    if (update_block)
        return;

    type = item_type;
    type_changed.emit (type);
}
