#!/bin/sh

# generate Makefile.am from the directory contents

echo "## This file was automatically generated by Makefile.sh" > Makefile.am
echo >> Makefile.am
echo "pkgdatadir = @GPUTILS_LKR_PATH@" >> Makefile.am
echo >> Makefile.am
echo "LKR_FILES =\\" >> Makefile.am

# count the number of items in the list
let count=0
for x in `ls *.lkr | sort`
  do
    let count=count+1
  done

# output the file list
let pass=0
for x in `ls *.lkr | sort`
  do
    let pass=pass+1
    if [ $pass -eq $count ]; then
      echo "	$x" >> Makefile.am
    else
      echo "	$x \\" >> Makefile.am
    fi
  done
 
echo >> Makefile.am
echo "pkgdata_DATA = \$(LKR_FILES)" >> Makefile.am
echo >> Makefile.am
echo "EXTRA_DIST = \$(LKR_FILES) Makefile.sh" >> Makefile.am
