/**
 ** song_find.c - dialog that finds mp3 for the user
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "song_find.h"
#include "all_list.h"
#include "mp3info.h"

song_find_t song_find;

/*
 * Display the dialog that asks the user how to search for mp3s
 */
void song_find_load_dialog(char *filename)
{
    GladeXML *xml;
    
    /* load the main_window decsription */
    xml = glade_xml_new( gnomp3.glade_file, "find_dialog");
    /* in case we can't load the interface, bail */
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
    
    gnomp3.find_dialog = glade_xml_get_widget(xml, "find_dialog");
    
    STORE_SONG_FIND_WIDGET(song_find, path_entry );
    STORE_SONG_FIND_WIDGET(song_find, locate_button );
    STORE_SONG_FIND_WIDGET(song_find, search_label );
    
    gtk_entry_set_text( GTK_ENTRY(song_find.path_entry), 
			gnomp3.song_search_path );
    
    /* autoconnect any signals */
    glade_xml_signal_autoconnect(xml);
    
    /* we don't need the GladeXML object any more, so unref it
       to save some memory */
    gtk_object_unref(GTK_OBJECT(xml));
    
    strncpy( song_find.filename, filename, MAX_PATH );
    song_find.pfp = NULL;
}

/*
 * Called when search is finnhed
 */
void song_find_finish()
{
    gtk_widget_destroy( gnomp3.find_dialog);
    if( song_find.pfp ){
	gdk_input_remove(song_find.io_id);
	pclose(song_find.pfp); 
	mp3list_add_songs();
	//mp3list_add_songs_from_file(song_find.filename);
    }
}

/*
 * Update the display of progress
 */
void song_find_io_cb( gpointer data, gint source, GdkInputCondition condition )
{
    char buff[MAX_PATH];

    if( fgets( buff, MAX_PATH, song_find.pfp )){
	//printf("File: >>>> %s\n", buff);
	g_strstrip( buff );
	
	if( strlen(buff) > 30 )
	    gtk_label_set_text( GTK_LABEL(song_find.search_label), 
				&buff[strlen(buff) - 30]);
	else
	    gtk_label_set_text( GTK_LABEL(song_find.search_label), buff );
    }else{ /* finished find/locate */
	song_find_finish();
    }

    while(gtk_events_pending())
	gtk_main_iteration();
}

/*
 * Search for songs using locate or find.
 * Songs are put in a file which is loaded when the search is finihed
 */
void song_find_do()
{
    char command[MAX_PATH];

    if( GTK_TOGGLE_BUTTON(song_find.locate_button)->active)
	g_snprintf( command, MAX_PATH, "locate .mp3 |grep %s |tee %s",
		    gtk_entry_get_text(GTK_ENTRY(song_find.path_entry)),
		    song_find.filename );
    else
	g_snprintf( command, MAX_PATH, "find %s -name \"*.mp3\" | tee %s", 
		    gtk_entry_get_text(GTK_ENTRY(song_find.path_entry)),
		    song_find.filename);

    song_find.pfp = popen( command, "r" );
    setlinebuf(song_find.pfp);

    song_find.length = 0;
    song_find.io_id = gdk_input_add( fileno(song_find.pfp), GDK_INPUT_READ,
				     song_find_io_cb, NULL);
    gtk_label_set_text( GTK_LABEL(song_find.search_label), "Searching...");
}



