#include <string.h>
#include <gnome.h>
#include <glade/glade.h>

#ifndef GNOMP3_H
#define GNOMP3_H

#define VERSION "0.1.7"

#define MAX_PATH 512

#ifndef DEFAULT_GLADE_FILE
#define DEFAULT_GLADE_FILE "gnomp3.glade"
#endif

#define GNOMP3_TASK_ICON "/usr/share/pixmaps/gnome-audio2.png"

typedef struct{
    int none;

    /*seetings stuff */
    char glade_file[MAX_PATH];

    int use_id3;
    int use_xmms;
    int song_search; /* if set find mp3s in search path else load from list */
    int dynamic_list_size;
    int tight_xmms;
    char song_search_path[MAX_PATH];
    char song_list_file[MAX_PATH];

    char playlist_loaded[MAX_PATH];
    char playlist_dir[MAX_PATH];
    
    char add_song_dir[MAX_PATH];

    /* colours */
    GdkColor playing_fg_color;
    GdkColor playing_bg_color;
    GdkColor played_fg_color;
    GdkColor played_bg_color;
    GdkColor in_playlist_fg_color;
    GdkColor in_playlist_bg_color;

    /* main window */
    GtkWidget *gnomp3;
    GtkWidget *hpaned;
    GtkWidget *mp3_toolbar;
    GtkWidget *add_button;

    /* playlist stuff */
    GtkWidget *play_vbox;
    GtkWidget *play_clist;
    GtkWidget *playlist_combo;
    GtkWidget *sort_button;

    /* mp3 player bit */
    GtkWidget *mp3_control_frame;
    GtkWidget *mp3_hscale;
    GtkWidget *mp3_control_label;
    GtkWidget *gnomp3_toolbar;
    GtkWidget *random_button;
    GtkWidget *repeat_button;
    GtkWidget *mp3_control_song_name;
    
    /* mp3 add stuff */
    GtkWidget *song_ctree;
    GtkWidget *search_clist;
    GtkWidget *all_clist;
    GtkWidget *time_clist;
    GtkWidget *dir_clist;
    GtkWidget *days_spin;

    /* dialogs */
    GtkWidget *find_dialog;
    GtkWidget *gnomp3_preferences;

    /* rule dialog */
    GtkWidget *rule_clist;
    GList *rule_list;

    /* pixmaps */
    GnomePixmap *playing_pixmap;
    GnomePixmap *finished_pixmap;
    GnomePixmap *rule_pixmap;
    GnomePixmap *rule_big;
    GnomePixmap *finished_rule;
    GnomePixmap *music_pixmap;
}gnomp3_t; 

extern gnomp3_t gnomp3;

void pixmaps_load();

#endif

