'\"
'\" Copyright (c) 1997 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) datefield.n 1.0 97/04/30 16:04:44
'/" 
.so man.macros
.HS datefield iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
datefield \- Create and manipulate a date field widget
.SH SYNOPSIS
\fBdatefield\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- LabeledWidget <- datefield
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBexportSelection\fR
\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBjustify\fR	\fBrelief\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the 
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBchildSitePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-childsitepos\fR
.fi
.IP
Specifies the position of the child site in the date field: \fBn\fR, 
\fBs\fR, \fBe\fR, or \fBw\fR.  The default is e.
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-command\fR
.fi
.IP
Specifies a Tcl command to be executed upon detection of a Return key 
press event.
.LP
.nf
Name:	\fBiq\fR
Class:	\fBIq\fR
Command-Line Switch:	\fB-iq\fR
.fi
.IP
Specifies the level of intelligence to be shown in the actions
taken by the datefield during the processing of keypress events.
Valid settings include \fBhigh\fR, \fBaverage\fR, and \fBlow\fR.  
With a high iq,the date prevents the user from typing in an 
invalid date.  For example, if the current date is 05/31/1997 and 
the user changes the month to 04, then the day will be instantly 
modified for them to be 30.  In addition, leap years are fully 
taken into account.  With average iq, the month is limited to the 
values of 01-12, but it is possible to type in an invalid day.  
A setting of low iq instructs the widget to do no validity 
checking at all during date entry.  With both average and low 
iq levels, it is assumed that the validity will be determined 
at a later time using the date's \fBisvalid\fR command.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB-state\fR
.fi
.IP
Specifies one of two states for the datefield: \fBnormal\fR or \fBdisabled\fR.
If the datefield is disabled then input is not accepted.  The default is
normal.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-textbackground\fR
.fi
.IP
Background color for inside textual portion of the entry field.  The value
may be given in any of the forms acceptable to \fBTk_GetColor\fR.
.LP
.nf
Name:	\fBtextFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-textfont\fR
.fi
.IP
Name of font to use for display of text in datefield.  The value
may be given in any of the forms acceptable to \fBTk_GetFont\fR.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBdatefield\fR command creates an enhanced text entry widget for
the purpose of date entry with various degrees of built-in intelligence.
.DE

.SH "METHODS"
.PP
The \fBdatefield\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for datefield widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBdatefield\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBdatefield\fR
command.
.TP
\fIpathName \fBget\fR ?\fBformat\fR?
Returns the current contents of the datefield in a format of 
string or as an integer clock value using the \fB-string\fR and \fB-clicks\fR
format options respectively.  The default is by string.  Reference the 
clock command for more information on obtaining dates and their 
formats.
.TP
\fIpathName \fBisvalid\fR
Returns a boolean indication of the validity of the currently
displayed date value.  For example, 03/03/1960 is valid whereas
02/29/1997 is invalid.
.TP
\fIpathName \fBshow\fR \fIdate\fR
Changes the currently displayed date to be that of the date 
argument.  The date may be specified either as a string, an
integer clock value or the keyword "now".  Reference the clock 
command for more information on obtaining dates and their formats.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBdate\fR
Class:	\fBEntry\fR
.fi
.IP
The date component provides the entry field for date input and display.
See the "entry" widget manual entry for details on the date component item.
.fi

.SH EXAMPLE
.DS
 proc returnCmd {} {
   puts [.df get]
 }

 datefield .df -command returnCmd
 pack .df -fill x -expand yes -padx 10 -pady 10
.DE
.SH AUTHOR
Mark L. Ulferts
.LP
.SH KEYWORDS
datefield, widget
