'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) ScrolledListBox.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS scrolledframe iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scrolledframe \- Create and manipulate scrolled frame widgets
.SH SYNOPSIS
\fBscrolledframe\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Labeledwidget <- scrolledframe
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBfont\fR	\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR
\fBrelief\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR	\fBselectBackground\fR
\fBselectBorderWidth\fR	\fBselectForeground\fR	
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" manual entry for details on the associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBLabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the scrolled frame widget in any of the forms acceptable to \fBTk_GetPixels\fR.  The default height is 100 pixels.
.LP
.nf
Name:	\fBhscrollMode\fR
Class:	\fBScrollMode\fR
Command-Line Switch:	\fB-hscrollmode\fR
.fi
.IP
Specifies the the display mode to be used for the horizontal
scrollbar: \fBstatic\fR, \fBdynamic\fR, or \fBnone\fR.  In static mode, the 
scroll bar is displayed at all times.  Dynamic mode displays the
scroll bar as required, and none disables the scroll bar display.  The 
default is static.
.LP
.nf
Name:	\fBsbWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-sbwidth\fR
.fi
.IP
Specifies the width of the scrollbar in any of the forms acceptable 
to \fBTk_GetPixels\fR.  The default width is 15 pixels.
.LP
.nf
Name:	\fBscrollMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-scrollmargin\fR
.fi
.IP
Specifies the distance between the frame and scrollbar in any of the
forms acceptable to \fBTk_GetPixels\fR.  The default is 3 pixels.
.LP
.nf
Name:	\fBvscrollMode\fR
Class:	\fBScrollMode\fR
Command-Line Switch:	\fB-vscrollmode\fR
.fi
.IP
Specifies the the display mode to be used for the vertical
scrollbar: \fBstatic\fR, \fBdynamic\fR, or \fBnone\fR.  In static mode, the 
scroll bar is displayed at all times.  Dynamic mode displays the 
scroll bar as required, and none disables the scroll bar display.  The 
default is static.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the scrolled frame widget in any of the forms
acceptable to \fBTk_GetPixels\fR.  The default height is 100 pixels.
.BE

.SH DESCRIPTION
.PP
The \fBscrolledframe\fR combines the functionallity of scrolling with that 
of a typical frame widget to implement a clipable viewing area whose visible 
region may be modified with the scroll bars. This enables the contruction 
of visually larger areas than which could normally be displayed, containing 
a heterogenous mix of other widgets. Options exist which allow full control
over which scrollbars are displayed and the method, i.e. statically or
dynamically. The frame itself may be accessed by the \fBchildsite\fR
method and then filled with other widget combinations.

.SH "METHODS"
.PP
The \fBscrolledframe\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrolledframe widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBxview\fR	\fByview\fR
.fi
.LP
See the "canvas" manual entry for details on the associated methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBscrolledframe\fR
command.
.TP
\fIpathName \fBchildsite\fR
Return the path name of the child site.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscrolledframe\fR
command.
.TP
\fIpathName \fBjustify \fIdirection\fR
Justifies the frame contents via the scroll bars in one of four directions:
\fBleft\fR, \fBright\fR, \fBtop\fR, or \fBbottom\fR.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBcanvasFrame\fR
Class:	\fBFrame\fR
.fi
.IP
The canvasFrame component provides relief for the scrCanvas component.  See 
the "frame" widget manual entry for details on the canvasFrame component item.
.LP
.nf
Name:	\fBscrCanvas\fR
Class:	\fBCanvas\fR
.fi
.IP
The scrCanvas component provides the scrolling region for the scrolled frame.
See the "canvas" widget manual entry for details on the scrCanvas component
item.
.LP
.nf
Name:	\fBscrFrame\fR
Class:	\fBFrame\fR
.fi
.IP
The scrFrame component is internal to the scrCanvas component, providing a
container for children of the scrolled frame.  See the "frame" widget 
manual entry for details on the scrFrame component item.
.LP
.nf
Name:	\fBhSB\fR
Class:	\fBScrollbar\fR
.fi
.IP
The hSB component is the horizontal scroll bar.  See the "ScrollBar" widget 
manual entry for details on the hSB component item.
.LP
.nf
Name:	\fBvSB\fR
Class:	\fBScrollbar\fR
.fi
.IP
The vSB component is the vertical scroll bar.  See the "ScrollBar" widget 
manual entry for details on the vSB component item.
.fi

.SH EXAMPLE
.DS
scrolledframe .sf -width 150 -height 180 -labelon yes -labeltext scrolledframe

set cs [.sf childsite]
pack [button $cs.b1 -text Hello] -pady 10
pack [button $cs.b2 -text World] -pady 10
pack [button $cs.b3 -text "This is a test"] -pady 10
pack [button $cs.b4 -text "This is a really big button"] -pady 10
pack [button $cs.b5 -text "This is another really big button"] -pady 10
pack [button $cs.b6 -text "This is the last really big button"] -pady 10

pack .sf -expand yes -fill both -padx 10 -pady 10
.DE
.SH AUTHOR
.TP
Sue Yockey
.TP
Mark L. Ulferts
.SH KEYWORDS
scrolledframe, frame, widget
