#include <netdb.h>
#include "getservice.h"
#include "fireflier.h"
std::string getService(const u_int16_t port, const char *protocol, bool withaliases)
{
	struct servent *se;
	u_int16_t temp;
	std::string servicename="Unknown";

    temp=port;
    netbswap(temp);
	se=getservbyport(temp, protocol);
	if (se)
	{
		servicename=se->s_name;
		if (withaliases)
		{
			for (int i=0;se->s_aliases[i]!=0;i++)
			{
				servicename+=", ";
                servicename+=se->s_aliases[i];
			}
		}
	}
    return servicename;
}

std::string getService(const u_int16_t port, const u_int16_t protocol, bool withaliases)
{
	struct protoent *pe;

	pe=getprotobynumber(protocol);
	if (!pe)
		return "Unknown";
    return (getService(port, pe->p_name, withaliases));
}
