// generated 2002/9/29 23:35:33 CEST by triendl.kj@triendl.kj.(none)
// using glademm V1.1.0c
//
// newer (non customized) versions of this file go to CFireFlierClient.cc_new

// This file is for your program, I won't touch it again!

#include "config.h"
#include "CFireFlierClient.hh"
#include "CFireFlierClientApp.hh"
#include "getservice.h"
#include "sigc++/sigc++.h"
#include <list>
#if FF_DEBUG
#include <iostream>
#endif
#include <sstream>
#include <list>
#include "fireflierstrings.h"
#ifdef WITHGNOME
#include <libgnomeuimm.h>
#include <libgnomeuimm/stock.h>
#else
#include <gtkmm.h>
#endif

using namespace std;


CFireFlierClient::CFireFlierClient()
	: m_bAuthOpen(false)
	, m_bProcessing(false)
	, m_resSrcThread()
	, m_resDstThread()
{
	initGUI();

	Glib::signal_idle().connect(SigC::slot(*this, &CFireFlierClient::on_idle));
// network thread signaling
	ffIO.networkThread.signal_Connection().connect(m_signalConnection.slot());
	ffIO.networkThread.signal_Authentication().connect(m_signalAuthentication.slot());
	ffIO.networkThread.signal_Packet_avail().connect(m_signalPacketAvail.slot());
	ffIO.networkThread.signal_finished().connect(m_signalNetworkThreadFinished.slot());
	ffIO.networkThread.signal_error().connect(m_signalNetworkThreadError.slot());

	m_signalConnection.connect(SigC::slot(*this, &CFireFlierClient::on_Connection));
	m_signalAuthentication.connect(SigC::slot(*this, &CFireFlierClient::on_Authentication));
	m_signalPacketAvail.connect(SigC::slot(*this, &CFireFlierClient::on_Packet_avail));
	m_signalNetworkThreadFinished.connect(SigC::slot(*this, &CFireFlierClient::on_NetworkThread_finished));
	m_signalNetworkThreadError.connect(SigC::slot(*this, &CFireFlierClient::on_networkthread_error));

// resolver thread signaling
	m_resSrcThread.signal_resolved().connect(m_signalResolvedSrc.slot(true));
	m_resDstThread.signal_resolved().connect(m_signalResolvedDst.slot(true));

	m_signalResolvedSrc.connect(SigC::bind <Gtk::Label*> (SigC::slot(*this, &CFireFlierClient::on_resolved), m_labelHostSrcValue));
	m_signalResolvedDst.connect(SigC::bind <Gtk::Label*> (SigC::slot(*this, &CFireFlierClient::on_resolved), m_labelHostDstValue));

	
	m_mapTimeout[strTimeoutForever]	= 0;
	m_mapTimeout[strTimeout01]		= 5*60; // 5min
	m_mapTimeout[strTimeout02]		= 60*60; // 1h
	m_mapTimeout[strTimeout03]		= 12*60*60; // 12h
	m_mapTimeout[strTimeout04]		= 24*60*60; // 1d

	m_resSrcThread.start();
	m_resDstThread.start();
	
	clearInterface();
	m_pStatusbar->pop();
	m_pStatusbar->push(strConnecting);
}


CFireFlierClient::~CFireFlierClient()
{
	// let's be nice, but don't join because resolving could block
	m_resSrcThread.finish();
	m_resDstThread.finish();
	
	std::list <SigC::Connection>::iterator it = m_signalList.begin();
	for (; it != m_signalList.end(); it++)
		it->disconnect();

#ifdef WITHGCONF
	if (m_gconfUI[strGConfUIMainWindow_remember].get_bool())
	{
		if (is_visible())
			save_pos_and_size();
		m_gconfUI.write();
	}
#endif
}


void CFireFlierClient::initGUI()
{  
	m_pStatusbar = manage(new Gtk::Statusbar);

/* menu */
/* =-=-=-=-=-=-=-=-=- */
	Gtk::Menu *menuFile_menu = manage(new Gtk::Menu());
	Gtk::Menu *menuView_menu = manage(new Gtk::Menu());
#ifdef ALREADY_12
	Gtk::Menu *menuSettings_menu = manage(new Gtk::Menu());
#endif // ALREADY_12
	Gtk::Menu *menuHelp_menu = manage(new Gtk::Menu());
	Gtk::MenuBar *menuBarFireFlier = manage(new Gtk::MenuBar());

	menuFile_menu->items().push_back(Gtk::Menu_Helpers::MenuElem("_log in", Gtk::Menu_Helpers::AccelKey("<Ctrl>l"), SigC::slot(*this, &CFireFlierClient::on_login)));
	m_menuItemLogin = (Gtk::MenuItem*) &menuFile_menu->items().back();
	menuFile_menu->items().push_back(Gtk::Menu_Helpers::SeparatorElem());
#ifdef WITHGCONF
	menuFile_menu->items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT, SigC::slot(*this, &CFireFlierClient::on_quit)));
#else
	menuFile_menu->items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT, SigC::slot(*this, &CFireFlierClient::hide)));
#endif
	menuView_menu->items().push_back(Gtk::Menu_Helpers::ImageMenuElem("_Source", Gtk::Menu_Helpers::AccelKey("<Ctrl>s"), *manage(new Gtk::Image(ustring(PACKAGE_PIXMAPS_DIR)+"/menuicon_packet_source.png")), SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_Request), ff::CMD_SOURCE)));
	m_menuItemViewSrc = (Gtk::MenuItem *) &menuView_menu->items().back();
	m_menuItemViewSrc->set_sensitive(false);
	menuView_menu->items().push_back(Gtk::Menu_Helpers::ImageMenuElem("_IPTables Rules", Gtk::Menu_Helpers::AccelKey("<Ctrl>i"), *manage(new Gtk::Image(ustring(PACKAGE_PIXMAPS_DIR)+"/menuicon_iptables_rules.png")), SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_Request), ff::CMD_RULES)));
	m_menuItemViewIPTablesRules = (Gtk::MenuItem *) &menuView_menu->items().back();
	m_menuItemViewIPTablesRules->set_sensitive(false);
	menuView_menu->items().push_back(Gtk::Menu_Helpers::ImageMenuElem("_Userspace Rules", Gtk::Menu_Helpers::AccelKey("<Ctrl>u"), *manage(new Gtk::Image(ustring(PACKAGE_PIXMAPS_DIR)+"/menuicon_userspace_rules.png")), SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_Request), ff::CMD_URULES)));
	m_menuItemViewUSpaceRules = (Gtk::MenuItem *) &menuView_menu->items().back();
	m_menuItemViewUSpaceRules->set_sensitive(false);

#ifdef ALREADY_12
	menuSettings_menu->items().push_back(Gtk::Menu_Helpers::CheckMenuElem("drop _incoming packets", SigC::bind(SigC::slot(*this, &CFireFlierClient::on_dropAuto_toggled), ff::CHAIN_INPUT)));
	m_menuItemDropInAuto = (Gtk::CheckMenuItem*) &menuSettings_menu->items().back();
	menuSettings_menu->items().push_back(Gtk::Menu_Helpers::CheckMenuElem("drop packets to _forward", SigC::bind(SigC::slot(*this, &CFireFlierClient::on_dropAuto_toggled), ff::CHAIN_FORWARD)));
	m_menuItemDropFwdAuto = (Gtk::CheckMenuItem*) &menuSettings_menu->items().back();
	menuSettings_menu->items().push_back(Gtk::Menu_Helpers::CheckMenuElem("drop _outgoing packets", SigC::bind(SigC::slot(*this, &CFireFlierClient::on_dropAuto_toggled), ff::CHAIN_OUTPUT)));
	m_menuItemDropOutAuto = (Gtk::CheckMenuItem*) &menuSettings_menu->items().back();
#endif // ALREADY_12

#ifdef WITHGNOME
	/*menuHelp_menu->items().push_back(Gtk::Menu_Helpers::StockMenuElem(
		Gnome::UI::Stock::ABOUT, 
		Gtk::Menu_Helpers::AccelKey("<Ctrl>a"), 
		SigC::slot(*this, &CFireFlierClient::on_about)));*/
	menuHelp_menu->items().push_back(Gtk::Menu_Helpers::MenuElem("about", Gtk::Menu_Helpers::AccelKey("<Ctrl>a"), SigC::slot(*this, &CFireFlierClient::on_about)));
#else
	menuHelp_menu->items().push_back(Gtk::Menu_Helpers::MenuElem("about", Gtk::Menu_Helpers::AccelKey("<Ctrl>a"), SigC::slot(*this, &CFireFlierClient::on_about)));
#endif


	menuBarFireFlier->items().push_back(Gtk::Menu_Helpers::MenuElem("_File", *menuFile_menu));
	menuBarFireFlier->items().push_back(Gtk::Menu_Helpers::MenuElem("_View", *menuView_menu));
#ifdef ALREADY_12
	menuBarFireFlier->items().push_back(Gtk::Menu_Helpers::MenuElem("_Settings", *menuSettings_menu));
#endif // ALREADY_12
	menuBarFireFlier->items().push_back(Gtk::Menu_Helpers::MenuElem("_Help", *menuHelp_menu));
/* =-=-=-=-=-=-=-=-=- */


/* toolbar */
/* =-=-=-=-=-=-=-=-=- */
	toolbarFireFlier = manage(new Gtk::Toolbar());
	Gtk::Toolbar::ToolList& tl = toolbarFireFlier->tools();

	tl.push_back(Gtk::Toolbar_Helpers::ButtonElem(*manage(new Gtk::Image(ustring(PACKAGE_PIXMAPS_DIR)+"/toolbaricon_packet_source.png")), SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_Request), ff::CMD_SOURCE), "view the source of the current packet"));
	m_butViewSrc = static_cast <Gtk::Image*> (tl.back().get_widget());
	m_butViewSrc->set_sensitive(false);
	tl.push_back(Gtk::Toolbar_Helpers::ButtonElem(*manage(new Gtk::Image(ustring(PACKAGE_PIXMAPS_DIR)+"/toolbaricon_iptables_rules.png")), SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_Request), ff::CMD_RULES), "view the iptables rules"));
	m_butViewIPTablesRules = static_cast <Gtk::Image*> (tl.back().get_widget());
	m_butViewIPTablesRules->set_sensitive(false);
	tl.push_back(Gtk::Toolbar_Helpers::ButtonElem(*manage(new Gtk::Image(ustring(PACKAGE_PIXMAPS_DIR)+"/toolbaricon_userspace_rules.png")), SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_Request), ff::CMD_URULES), "view the userspace rules"));
	m_butViewUSpaceRules = static_cast <Gtk::Image*> (tl.back().get_widget());
	m_butViewUSpaceRules->set_sensitive(false);
	toolbarFireFlier->set_tooltips(true);
/* =-=-=-=-=-=-=-=-=- */

	
/* radio buttons */
/* =-=-=-=-=-=-=-=-=- */
	Gtk::RadioButton::Group _RadioBGroup_;
	m_radioThisPacket = manage(new Gtk::RadioButton(_RadioBGroup_, strThisPacket, true));
	m_radioThisPacket->set_flags(Gtk::CAN_FOCUS);
	m_radioThisPacket->set_relief(Gtk::RELIEF_NORMAL);
	m_radioThisPacket->set_mode(true);
	m_radioThisPacket->set_active(true);

	m_radioQueuedPackets = manage(new Gtk::RadioButton(_RadioBGroup_, strQueuedpackets, true));
	m_radioQueuedPackets->set_flags(Gtk::CAN_FOCUS);
	m_radioQueuedPackets->set_relief(Gtk::RELIEF_NORMAL);
	m_radioQueuedPackets->set_mode(true);
	m_radioQueuedPackets->set_active(false);
	
	m_radioCreateRule = manage(new Gtk::RadioButton(_RadioBGroup_, strCreateRule, true));
	m_radioCreateRule->set_flags(Gtk::CAN_FOCUS);
	m_radioCreateRule->set_relief(Gtk::RELIEF_NORMAL);
	m_radioCreateRule->set_mode(true);
	m_radioCreateRule->set_active(false);
/* =-=-=-=-=-=-=-=-=- */


/* general packet characteristics */
/* =-=-=-=-=-=-=-=-=- */
	m_labelChain = manage(new Gtk::Label(strChain, Gtk::ALIGN_LEFT));
	m_labelChain->set_line_wrap(false);
	m_labelChainValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelChainValue->set_line_wrap(false);

	m_labelLen = manage(new Gtk::Label(strLen, Gtk::ALIGN_LEFT));
	m_labelLen->set_line_wrap(false);
	m_labelLenValue= manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelLenValue->set_line_wrap(false);
	
	m_labelMAC = manage(new Gtk::Label(strMAC, Gtk::ALIGN_LEFT));
	m_labelMAC->set_line_wrap(false);
	m_labelMACValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelMACValue->set_line_wrap(false);
	
	m_chkProgram = manage(new Gtk::CheckButton(strProgramName, true));
	m_chkProgram->set_flags(Gtk::CAN_FOCUS);
	m_chkProgram->set_relief(Gtk::RELIEF_NORMAL);
	m_chkProgram->set_mode(true);
	m_chkProgram->set_active(false);
	m_labelProgramValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelProgramValue->set_line_wrap(false);

	m_labelTimestamp = manage(new Gtk::Label(strTimestamp, Gtk::ALIGN_LEFT));
	m_labelTimestamp->set_line_wrap(false);
	m_labelTimestampValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelTimestampValue->set_line_wrap(false);
	
	m_labelTCPFlags = manage(new Gtk::Label(strTCPFlags, Gtk::ALIGN_LEFT));
	m_labelTCPFlags->set_line_wrap(false);
	m_labelTCPFlagsValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelTCPFlags->set_line_wrap(false);
	
	m_labelICMPType = manage(new Gtk::Label(strICMPType, Gtk::ALIGN_LEFT));
	m_labelICMPType->set_line_wrap(false);
	m_labelICMPTypeValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelICMPTypeValue->set_line_wrap(false);
	
	m_chkProtocol = manage(new Gtk::CheckButton(strProtocol, true));
	m_chkProtocol->set_flags(Gtk::CAN_FOCUS);
	m_chkProtocol->set_relief(Gtk::RELIEF_NORMAL);
	m_chkProtocol->set_mode(true);
	m_chkProtocol->set_active(false);
	m_labelProtocolValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelProtocolValue->set_line_wrap(false);
/* =-=-=-=-=-=-=-=-=- */


/* src+dst info */
/* =-=-=-=-=-=-=-=-=- */
	m_chkIPSrc = manage(new Gtk::CheckButton(strIPSrc, true));
	m_chkIPSrc->set_flags(Gtk::CAN_FOCUS);
	m_chkIPSrc->set_relief(Gtk::RELIEF_NORMAL);
	m_chkIPSrc->set_mode(true);
	m_chkIPSrc->set_active(false);
	m_labelIPSrcValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelIPSrcValue->set_line_wrap(false);
	
	m_labelHostSrc = manage(new Gtk::Label(strHostSrc, Gtk::ALIGN_LEFT));
	m_labelHostSrc->set_line_wrap(false);
	m_labelHostSrcValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelHostSrcValue->set_line_wrap(false);
	
	m_chkPortSrc = manage(new Gtk::CheckButton(strPortSrc, true));
	m_chkPortSrc->set_flags(Gtk::CAN_FOCUS);
	m_chkPortSrc->set_relief(Gtk::RELIEF_NORMAL);
	m_chkPortSrc->set_mode(true);
	m_chkPortSrc->set_active(false);
	m_labelPortSrcValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelPortSrcValue->set_line_wrap(false);
	
	m_chkIFaceIn = manage(new Gtk::CheckButton(strIFaceIn, true));
	m_chkIFaceIn->set_flags(Gtk::CAN_FOCUS);
	m_chkIFaceIn->set_relief(Gtk::RELIEF_NORMAL);
	m_chkIFaceIn->set_mode(true);
	m_chkIFaceIn->set_active(false);
	m_labelIFaceInValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelIFaceInValue->set_line_wrap(false);
	
	m_chkIPDst = manage(new Gtk::CheckButton(strIPDst, true));
	m_chkIPDst->set_flags(Gtk::CAN_FOCUS);
	m_chkIPDst->set_relief(Gtk::RELIEF_NORMAL);
	m_chkIPDst->set_mode(true);
	m_chkIPDst->set_active(false);
	m_labelIPDstValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelIPDstValue->set_line_wrap(false);
	
	m_labelHostDst = manage(new Gtk::Label(strHostDst, Gtk::ALIGN_LEFT));
	m_labelHostDst->set_line_wrap(false);
	m_labelHostDstValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelHostDstValue->set_line_wrap(false);
	
	m_chkPortDst = manage(new Gtk::CheckButton(strPortDst, true));
	m_chkPortDst->set_flags(Gtk::CAN_FOCUS);
	m_chkPortDst->set_relief(Gtk::RELIEF_NORMAL);
	m_chkPortDst->set_mode(true);
	m_chkPortDst->set_active(false);
	m_labelPortDstValue = manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelPortDstValue->set_line_wrap(false);
	
	m_chkIFaceOut = manage(new Gtk::CheckButton(strIFaceOut, true));
	m_chkIFaceOut->set_flags(Gtk::CAN_FOCUS);
	m_chkIFaceOut->set_relief(Gtk::RELIEF_NORMAL);
	m_chkIFaceOut->set_mode(true);
	m_chkIFaceOut->set_active(false);
	m_labelIFaceOutValue= manage(new Gtk::Label("", Gtk::ALIGN_LEFT));
	m_labelIFaceOutValue->set_line_wrap(false);
/* =-=-=-=-=-=-=-=-=- */


/* options */
/* =-=-=-=-=-=-=-=-=- */
	m_chkTracking = manage(new Gtk::CheckButton(strTracking, true));
	m_chkTracking->set_flags(Gtk::CAN_FOCUS);
	m_chkTracking->set_relief(Gtk::RELIEF_NORMAL);
	m_chkTracking->set_mode(true);
	m_chkTracking->set_active(false);
	
	m_cbTimeout = manage(new Gtk::Combo());
	m_cbTimeout->get_entry()->set_flags(Gtk::CAN_FOCUS);
	m_cbTimeout->get_entry()->set_editable(false);
	m_cbTimeout->set_case_sensitive(false);
	{
		const char* const items[] = 
		{
			strTimeoutForever.c_str(), 
			strTimeout01.c_str(), 
			strTimeout02.c_str(), 
			strTimeout03.c_str(), 
			strTimeout04.c_str(), 
			0
		};
		m_cbTimeout->set_popdown_strings(items);
	}
	m_cbTimeout->get_entry()->set_text(strTimeoutForever);
	
	m_labelTimeout = manage(new Gtk::Label(strLabelTimeout, Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER, true));
	m_labelTimeout->set_mnemonic_widget(*(m_cbTimeout->get_entry()));
/* =-=-=-=-=-=-=-=-=- */

	
/* dlg action buttons ``accept" and ``drop" */
/* =-=-=-=-=-=-=-=-=- */
	/* accept */
	Gtk::Image *imgButAccept = manage(new Gtk::Image(Gtk::StockID(Gtk::Stock::YES), Gtk::IconSize(4)));
	
	Gtk::Label *labelButAccept = manage(new Gtk::Label(strAccept, true));
	labelButAccept->set_justify(Gtk::JUSTIFY_LEFT);
	labelButAccept->set_line_wrap(false);
	
	Gtk::HBox *hboxButAccept = manage(new Gtk::HBox(false, 2));
	hboxButAccept->pack_start(*imgButAccept);
	hboxButAccept->pack_start(*labelButAccept);
	
	Gtk::Alignment *alignButAccept = manage(new Gtk::Alignment(Gtk::ALIGN_CENTER, Gtk::ALIGN_CENTER, 0.0, 0.0));
	alignButAccept->add(*hboxButAccept);
	
	m_butAccept = manage(new Gtk::Button());
	m_butAccept->set_flags(Gtk::CAN_FOCUS);
	m_butAccept->set_relief(Gtk::RELIEF_NORMAL);
	m_butAccept->add(*alignButAccept);
	
	
	/* drop */
	Gtk::Image *imgButDrop = manage(new Gtk::Image(Gtk::StockID(Gtk::Stock::NO), Gtk::IconSize(4)));
	
	Gtk::Label *labelButDrop = manage(new Gtk::Label(strDrop, true));
	labelButDrop->set_justify(Gtk::JUSTIFY_LEFT);
	labelButDrop->set_line_wrap(false);
	
	Gtk::HBox *hboxButDrop = manage(new Gtk::HBox(false, 2));
	hboxButDrop->pack_start(*imgButDrop);
	hboxButDrop->pack_start(*labelButDrop);
	
	Gtk::Alignment *alignButDrop = manage(new Gtk::Alignment(Gtk::ALIGN_CENTER, Gtk::ALIGN_CENTER, 0.0, 0.0));
	alignButDrop->add(*hboxButDrop);
	
	m_butDrop = manage(new Gtk::Button());
	m_butDrop->set_flags(Gtk::CAN_FOCUS);
	m_butDrop->set_relief(Gtk::RELIEF_NORMAL);
	m_butDrop->add(*alignButDrop);
/* =-=-=-=-=-=-=-=-=- */


/* fill containers */
/* =-=-=-=-=-=-=-=-=- */
	Gtk::VBox *vboxRuleCommand = manage(new Gtk::VBox(false, 0));
	vboxRuleCommand->set_border_width(5);
	vboxRuleCommand->pack_start(*m_radioThisPacket);
	vboxRuleCommand->pack_start(*m_radioQueuedPackets);
	vboxRuleCommand->pack_start(*m_radioCreateRule);
	
	// general characteristics
	Gtk::VBox* vboxGL = manage(new Gtk::VBox(true));
	Gtk::VBox* vboxGLValue = manage(new Gtk::VBox(true));
	vboxGL->pack_start(*m_labelChain, Gtk::PACK_SHRINK);
	vboxGL->pack_start(*m_labelLen, Gtk::PACK_SHRINK);
	vboxGL->pack_start(*m_labelMAC, Gtk::PACK_SHRINK);
	vboxGL->pack_start(*m_chkProgram, Gtk::PACK_SHRINK);
	vboxGLValue->pack_start(*m_labelChainValue);
	vboxGLValue->pack_start(*m_labelLenValue);
	vboxGLValue->pack_start(*m_labelMACValue);
	vboxGLValue->pack_start(*m_labelProgramValue);
	Gtk::HBox* hboxGeneralLeft = manage(new Gtk::HBox());
	hboxGeneralLeft->set_border_width(5);
	hboxGeneralLeft->pack_start(*vboxGL, Gtk::PACK_SHRINK);
	hboxGeneralLeft->pack_start(*vboxGLValue);

	Gtk::VBox* vboxGR = manage(new Gtk::VBox(true));
	Gtk::VBox* vboxGRValue = manage(new Gtk::VBox(true));
	vboxGR->pack_start(*m_labelTimestamp, Gtk::PACK_SHRINK);
	vboxGR->pack_start(*m_labelTCPFlags, Gtk::PACK_SHRINK);
	vboxGR->pack_start(*m_labelICMPType, Gtk::PACK_SHRINK);
	vboxGR->pack_start(*m_chkProtocol, Gtk::PACK_SHRINK);
	vboxGRValue->pack_start(*m_labelTimestampValue);
	vboxGRValue->pack_start(*m_labelTCPFlagsValue);
	vboxGRValue->pack_start(*m_labelICMPTypeValue);
	vboxGRValue->pack_start(*m_labelProtocolValue);
	Gtk::HBox* hboxGeneralRight = manage(new Gtk::HBox());
	hboxGeneralRight->set_border_width(5);
	hboxGeneralRight->pack_start(*vboxGR, Gtk::PACK_SHRINK);
	hboxGeneralRight->pack_start(*vboxGRValue);
	
	Gtk::HBox* hboxGeneral = manage(new Gtk::HBox(true, 5));
	//hboxGeneral->set_border_width(5);
	hboxGeneral->pack_start(*hboxGeneralLeft);
	hboxGeneral->pack_start(*hboxGeneralRight);
	
	m_frameGeneral = manage(new Gtk::Frame("general characteristics of packet"));
	m_frameGeneral->set_shadow_type(Gtk::SHADOW_ETCHED_OUT);
	m_frameGeneral->set_border_width(5);
	m_frameGeneral->add(*hboxGeneral);
	
	// special packet characteristics
	// source info
	Gtk::VBox *vboxPacketSrc = manage(new Gtk::VBox(true));
	Gtk::VBox *vboxPacketSrcValue = manage(new Gtk::VBox(true));
	vboxPacketSrc->pack_start(*m_chkIPSrc, Gtk::PACK_SHRINK);
	vboxPacketSrc->pack_start(*m_labelHostSrc, Gtk::PACK_SHRINK);
	vboxPacketSrc->pack_start(*m_chkPortSrc, Gtk::PACK_SHRINK);
	vboxPacketSrc->pack_start(*m_chkIFaceIn, Gtk::PACK_SHRINK);
	vboxPacketSrcValue->pack_start(*m_labelIPSrcValue);
	vboxPacketSrcValue->pack_start(*m_labelHostSrcValue);
	vboxPacketSrcValue->pack_start(*m_labelPortSrcValue);
	vboxPacketSrcValue->pack_start(*m_labelIFaceInValue);
	
	Gtk::HBox* hboxPacketSrc = manage(new Gtk::HBox(false));
	hboxPacketSrc->set_border_width(5);
	hboxPacketSrc->pack_start(*vboxPacketSrc, Gtk::PACK_SHRINK);
	hboxPacketSrc->pack_start(*vboxPacketSrcValue);
	
	m_frameSrc = manage(new Gtk::Frame("source of packet"));
	m_frameSrc->set_shadow_type(Gtk::SHADOW_ETCHED_OUT);
	m_frameSrc->add(*hboxPacketSrc);
	
	// destination info
	Gtk::VBox *vboxPacketDst = manage(new Gtk::VBox(true));
	Gtk::VBox *vboxPacketDstValue = manage(new Gtk::VBox(true));
	vboxPacketDst->pack_start(*m_chkIPDst, Gtk::PACK_SHRINK);
	vboxPacketDst->pack_start(*m_labelHostDst, Gtk::PACK_SHRINK);
	vboxPacketDst->pack_start(*m_chkPortDst, Gtk::PACK_SHRINK);
	vboxPacketDst->pack_start(*m_chkIFaceOut, Gtk::PACK_SHRINK);
	vboxPacketDstValue->pack_start(*m_labelIPDstValue);
	vboxPacketDstValue->pack_start(*m_labelHostDstValue);
	vboxPacketDstValue->pack_start(*m_labelPortDstValue);
	vboxPacketDstValue->pack_start(*m_labelIFaceOutValue);
	
	Gtk::HBox *hboxPacketDst = manage(new Gtk::HBox(false));
	hboxPacketDst->set_border_width(5);
	hboxPacketDst->pack_start(*vboxPacketDst, Gtk::PACK_SHRINK);
	hboxPacketDst->pack_start(*vboxPacketDstValue);

	m_frameDst = manage(new Gtk::Frame("destination of packet"));
	m_frameDst->set_shadow_type(Gtk::SHADOW_ETCHED_OUT);
	m_frameDst->add(*hboxPacketDst);
	
	Gtk::HBox *hboxPacketInfo = manage(new Gtk::HBox(true, 5));
	hboxPacketInfo->set_border_width(5);
	hboxPacketInfo->pack_start(*m_frameSrc);
	hboxPacketInfo->pack_start(*m_frameDst);
			
	
	// options
	Gtk::HBox* hboxTimeout = manage(new Gtk::HBox);
	hboxTimeout->set_border_width(5);
	hboxTimeout->pack_start(*m_labelTimeout, Gtk::PACK_SHRINK);
	hboxTimeout->pack_start(*m_cbTimeout);
	Gtk::HBox* hboxOptions = manage(new Gtk::HBox(true, 5));
	hboxOptions->set_border_width(5);
	hboxOptions->pack_start(*m_chkTracking);
	hboxOptions->pack_start(*hboxTimeout);
	
	m_frameOptions = manage(new Gtk::Frame("options"));
	m_frameOptions->set_shadow_type(Gtk::SHADOW_ETCHED_OUT);
	m_frameOptions->set_border_width(5);
	m_frameOptions->add(*hboxOptions);
	
	
	// accept/drop buttons
	Gtk::HBox *hboxDlgAction = manage(new Gtk::HBox(true, 5));
	hboxDlgAction->set_border_width(5);
	hboxDlgAction->pack_start(*m_butAccept);
	hboxDlgAction->pack_start(*m_butDrop);

	// compile whole ui
	Gtk::VBox *vboxWhole = manage(new Gtk::VBox(false));
	vboxWhole->pack_start(*menuBarFireFlier, Gtk::PACK_SHRINK);
	vboxWhole->pack_start(*toolbarFireFlier, Gtk::PACK_SHRINK);
	vboxWhole->pack_start(*vboxRuleCommand, Gtk::PACK_SHRINK);
	vboxWhole->pack_start(*m_frameGeneral);
	vboxWhole->pack_start(*hboxPacketInfo);
	vboxWhole->pack_start(*m_frameOptions);
	vboxWhole->pack_start(*hboxDlgAction, Gtk::PACK_SHRINK);
	vboxWhole->pack_start(*m_pStatusbar, Gtk::PACK_SHRINK);
/* =-=-=-=-=-=-=-=-=- */


/* tooltips */
/* =-=-=-=-=-=-=-=-=- */
	m_tooltips.set_tip(*m_radioThisPacket, "allow or deny single packets");
	m_tooltips.set_tip(*m_radioQueuedPackets, "take an action for all packets in the server queue");
	m_tooltips.set_tip(*m_radioCreateRule, "select on the checkboxes below, which fields take part in the rule");

	m_tooltips.set_tip(*m_labelChain, "firewall chain where this packet is coming from");
	m_tooltips.set_tip(*m_labelLen, "The length of the packet including headers");
	m_tooltips.set_tip(*m_labelMAC, "This is the MAC address of the remote network interface card");
	m_tooltips.set_tip(*m_chkProgram, "program on the local computer, which is sending the packet or where the packet is being sent to.");
	m_tooltips.set_tip(*m_labelTimestamp, "when did the packet arrive at the firewall");
	m_tooltips.set_tip(*m_labelTCPFlags, "if TCP protocol then this describes the active flags of this message");
	m_tooltips.set_tip(*m_labelICMPType, "if this packet is an ICMP packet, then this field describes the ICMP Type of the packet");
	m_tooltips.set_tip(*m_chkProtocol, "network protocol of this packet");

	m_tooltips.set_tip(*m_chkIPSrc, "IP address of the sender");
	m_tooltips.set_tip(*m_labelHostSrc, "hostname of the sender if resolvable");
	m_tooltips.set_tip(*m_chkPortSrc, "IP port of the sender");
	m_tooltips.set_tip(*m_chkIFaceIn, "network interface if outgoing packet");
	m_tooltips.set_tip(*m_chkIPDst, "IP address of the destination");
	m_tooltips.set_tip(*m_labelHostDst, "hostname of the destination if resolvable");
	m_tooltips.set_tip(*m_chkPortDst, "IP port of the destination");
	m_tooltips.set_tip(*m_chkIFaceOut, "network interface if incoming packet");

	m_tooltips.set_tip(*m_chkTracking, "for TCP and UDP rules connection tracking can be activated (cf iptables manual)");
	m_tooltips.set_tip(*m_labelTimeout, strToolTipTimeout);
	m_tooltips.set_tip(*m_cbTimeout, strToolTipTimeout);
	m_tooltips.set_tip(*m_butAccept, "allow packet(s) (inserts a rule if you have chosen ``create rule\")");
	m_tooltips.set_tip(*m_butDrop, "deny packet(s) (inserts a rule if you have chosen ``create rule\")");
/* =-=-=-=-=-=-=-=-=- */


	add(*vboxWhole);
	set_title(strAppTitle);
	set_modal(false);
	set_resizable(true);
	show_all_children();

#ifdef WITHGCONF
	m_gconfUI.add_dir(gb_pGConfClient, strGConfUIMainWindow, SigC::slot(*this, &CFireFlierClient::on_value_changed));
	on_value_changed("", Gnome::Conf::Value());
	m_signalList.push_back(signal_delete_event().connect(SigC::slot(*this, &CFireFlierClient::on_delete)));
#else
	set_position(Gtk::WIN_POS_MOUSE);
#endif
	m_signalList.push_back(m_radioThisPacket->signal_toggled().connect(SigC::bind <ff::Rulecommands> (SigC::slot(*this, &CFireFlierClient::on_radioRuleCmds_toggled), ff::RC_THIS_PACKET)));
	m_signalList.push_back(m_radioQueuedPackets->signal_toggled().connect(SigC::bind <ff::Rulecommands> (SigC::slot(*this, &CFireFlierClient::on_radioRuleCmds_toggled), ff::RC_QUEUED_PACKETS)));
	m_signalList.push_back(m_radioCreateRule->signal_toggled().connect(SigC::bind <ff::Rulecommands> (SigC::slot(*this, &CFireFlierClient::on_radioRuleCmds_toggled), ff::RC_CREATE_RULE)));
	m_signalList.push_back(m_chkIPSrc->signal_toggled().connect(SigC::bind<Gtk::CheckButton*>(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), NULL)));
	m_signalList.push_back(m_chkIPDst->signal_toggled().connect(SigC::bind<Gtk::CheckButton*>(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), NULL)));
	m_signalList.push_back(m_chkPortSrc->signal_toggled().connect(SigC::bind(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), m_chkPortSrc)));
	m_signalList.push_back(m_chkPortDst->signal_toggled().connect(SigC::bind(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), m_chkPortDst)));
	m_signalList.push_back(m_chkIFaceIn->signal_toggled().connect(SigC::bind<Gtk::CheckButton*>(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), NULL)));
	m_signalList.push_back(m_chkIFaceOut->signal_toggled().connect(SigC::bind<Gtk::CheckButton*>(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), NULL)));
	m_signalList.push_back(m_chkProtocol->signal_toggled().connect(SigC::bind(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), m_chkProtocol)));
	m_signalList.push_back(m_chkProgram->signal_toggled().connect(SigC::bind<Gtk::CheckButton*>(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), NULL)));
	m_signalList.push_back(m_chkTracking->signal_toggled().connect(SigC::bind<Gtk::CheckButton*>(SigC::slot(*this, &CFireFlierClient::on_Rule_compile), NULL)));
	m_signalList.push_back(m_cbTimeout->get_list()->signal_selection_changed().connect(SigC::slot(*this, &CFireFlierClient::on_timeout_changed)));
	m_signalList.push_back(m_butAccept->signal_clicked().connect(SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_sendCmd), ff::CMD_ACCEPT)));
	m_signalList.push_back(m_butDrop->signal_clicked().connect(SigC::bind <ff::Commands> (SigC::slot(*this, &CFireFlierClient::on_sendCmd), ff::CMD_DROP)));
}


#ifdef WITHGCONF
bool CFireFlierClient::on_delete(GdkEventAny*)
{
	save_pos_and_size();
	return false;
}

void CFireFlierClient::on_quit()
{
	save_pos_and_size();
	hide();
}

void CFireFlierClient::save_pos_and_size()
{
	int nX, nY;
	get_position(nX, nY);
	m_gconfUI[strGConfUIMainWindow_posX].set(nX);
	m_gconfUI[strGConfUIMainWindow_posY].set(nY);
}

void CFireFlierClient::on_value_changed(const ustring& strKey, const Gnome::Conf::Value& value)
{
	bool bFFConcerned = (strKey.find(strGConfUIMainWindow) != ustring::npos);
#if FF_DEBUG
	cerr << "CFireFlierClient::on_value_changed(): strKey=" << strKey << endl;
	cerr << "CFireFlierClient::on_value_changed()::bFFConcerned=" << bFFConcerned << endl;
#endif

	if (bFFConcerned && strKey.length())
		m_gconfUI[strKey] = value;
	if (bFFConcerned || !strKey.length())
	{
#if FF_DEBUG
		cerr << "CFireFlierClient::on_value_changed(): moving window" << endl;
#endif
		move(m_gconfUI[strGConfUIMainWindow_posX].get_int(), m_gconfUI[strGConfUIMainWindow_posY].get_int());
	}
}
#endif // WITHGCONF

bool CFireFlierClient::on_idle()
{
	m_bAuthOpen = true;
	CDlgAuthentication().run();
	m_bAuthOpen = false;
	return false; // disconnect from idle signal
}

void CFireFlierClient::on_about()
{
#ifdef WITHGNOME
	// note to translators: please fill in your names and email addresses
	//Glib::ustring translators = _("translator_credits");
	//if (translators == "translator_credits")
	//translators = ""; 
	list <ustring> authors;
	list <ustring> documenters;
	authors.push_back("triendl klaus <fireflier@gibraltar.at>");
	Gnome::UI::About dlg(PACKAGE, VERSION, authors.front(), authors, documenters);
#else
	Gtk::Dialog dlg(strAppTitle+"::About", *this, true, true);
	Gtk::Label labelApp("application:", Gtk::ALIGN_LEFT);
	Gtk::Label labelAppValue(PACKAGE, Gtk::ALIGN_LEFT);
	Gtk::Label labelVersion("version:", Gtk::ALIGN_LEFT);
	Gtk::Label labelVersionValue(VERSION, Gtk::ALIGN_LEFT);
	Gtk::Label labelAuthor("author:", Gtk::ALIGN_LEFT);
	Gtk::Label labelAuthorValue("triendl klaus <fireflier@gibraltar.at>", Gtk::ALIGN_LEFT);
	Gtk::Label labelCR("copyright:", Gtk::ALIGN_LEFT);
	Gtk::Label labelCRValue("GPL", Gtk::ALIGN_LEFT);
	Gtk::VBox vbox(true);
	vbox.pack_start(labelApp, Gtk::PACK_SHRINK);
	vbox.pack_start(labelVersion, Gtk::PACK_SHRINK);
	vbox.pack_start(labelAuthor, Gtk::PACK_SHRINK);
	vbox.pack_start(labelCR, Gtk::PACK_SHRINK);
	Gtk::VBox vboxValue(true);
	vboxValue.pack_start(labelAppValue);
	vboxValue.pack_start(labelVersionValue);
	vboxValue.pack_start(labelAuthorValue);
	vboxValue.pack_start(labelCRValue);
	
	Gtk::HBox hbox(false, 5);
	hbox.pack_start(vbox, Gtk::PACK_SHRINK);
	hbox.pack_start(vboxValue);
	dlg.get_vbox()->pack_start(hbox);
	dlg.add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
	dlg.get_action_area()->set_layout(Gtk::BUTTONBOX_SPREAD);
	dlg.show_all_children();
#endif
	dlg.run();
}

void CFireFlierClient::on_login()
{
	m_bAuthOpen = true;
	CDlgAuthentication().run();
	m_bAuthOpen = false;
}

void CFireFlierClient::on_resolved(const char* szHostName, Gtk::Label* label)
{
	if (m_pCurPacket)
		label->set_text(szHostName);
}


void CFireFlierClient::on_Connection(bool bConnected)
{
	if (bConnected)
	{
		m_pStatusbar->pop();
#if FF_DEBUG
		cout << "connection established" << endl;
#endif
	}
	else
	{
		m_pStatusbar->pop();
		m_pStatusbar->push(strNoConnection);
#if FF_DEBUG
		cerr << "connection failed" << endl;
#endif
	}
}

void CFireFlierClient::on_Authentication(int nAuthenticated)
{
	authenticated = nAuthenticated;
	if (nAuthenticated == 1)
	{
		m_menuItemLogin->set_sensitive(false);
		m_menuItemViewIPTablesRules->set_sensitive();
		m_menuItemViewUSpaceRules->set_sensitive();
		m_butViewIPTablesRules->set_sensitive();
		m_butViewUSpaceRules->set_sensitive();
		m_pStatusbar->pop();
		m_pStatusbar->push(strNoPacketAvail);
		try
		{
			if (m_dlgIPTablesRules.is_visible())
				ffIO << CCO_SimpleRequest(ff::CMD_RULES);
			if (m_dlgUSpaceRules.is_visible())
				ffIO << CCO_SimpleRequest(ff::CMD_URULES);
		}
		catch (...)
		{
		}
	}
}


void CFireFlierClient::on_NetworkThread_finished()
{
}

void CFireFlierClient::on_networkthread_error(CffIO::pCffIOError pErr, bool bDisconnected)
{
	if (!m_bAuthOpen)
	{
#if FF_DEBUG
		cerr << "error while communication with fireflier-server: " << pErr->getErrorNum() << endl;
#endif
	
		if (bDisconnected && is_visible())
		{
			connected = false;
			m_pStatusbar->pop();
			m_pStatusbar->push(strNoConnection);
			if (authenticated == 1)
			{
				authenticated = 0;
				m_menuItemLogin->set_sensitive();
				m_menuItemViewIPTablesRules->set_sensitive(false);
				m_menuItemViewUSpaceRules->set_sensitive(false);
				m_butViewIPTablesRules->set_sensitive(false);
				m_butViewUSpaceRules->set_sensitive(false);
				clearInterface();
				Gtk::MessageDialog dlg(*this, "connection to fireflier-server lost.", Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
				dlg.run();
			}
		}
	}
}

void CFireFlierClient::on_Packet_avail(CRefPtr <const CPacket> pPacket)
{
	m_pCurPacket = pPacket;
	ff::Chains enChain = ff::CHAIN_UNUSED;
	
#ifdef ALREADY_12
	switch (m_pCurPacket->hook)
	{
		case ff::CHAIN_INPUT:
			if (m_menuItemDropInAuto->get_active())
				enChain = ff::CHAIN_INPUT;
#if FF_DEBUG
			cout << "dropping incoming packet automatically" << endl;
#endif
			break;
		case ff::CHAIN_FORWARD:
			if (m_menuItemDropFwdAuto->get_active())
				enChain = ff::CHAIN_FORWARD;
#if FF_DEBUG
				cout << "dropping packet to forward automatically" << endl;
#endif
			break;
		case ff::CHAIN_OUTPUT:
			if (m_menuItemDropOutAuto->get_active())
				enChain = ff::CHAIN_OUTPUT;
#if FF_DEBUG
				cout << "dropping outgoing packet automatically" << endl;
#endif
			break;
		default:
			;
			if (FF_DEBUG)
				cout << "other chains are not yet supported" << endl;
	}
#endif // ALREADY_12

	if (enChain != ff::CHAIN_UNUSED)
		on_sendCmd(ff::CMD_DROP);
	else
	{
		m_resSrcThread.resolve(m_pCurPacket->ip_src);
		m_resDstThread.resolve(m_pCurPacket->ip_dst);
		setLabels();
		if (m_dlgSrc.is_visible())
		{
			try
			{
				ffIO << CCO_SimpleRequest(ff::CMD_SOURCE);
			}
			catch (...)
			{
			}
		}
	}
}

#ifdef ALREADY_12
void CFireFlierClient::on_dropAuto_toggled(ff::Chains enChain)
{
	if (m_pCurPacket)
		on_Packet_avail(m_pCurPacket);
}
#endif // ALREADY_12


void CFireFlierClient::on_Request(ff::Commands enCmd)
{
	bool bDo = true;
	switch (enCmd)
	{
		case ff::CMD_RULES:
			if (!m_dlgIPTablesRules.is_visible())
				m_dlgIPTablesRules.show();
			break;
		
		case ff::CMD_URULES:
			if (!m_dlgUSpaceRules.is_visible())
				m_dlgUSpaceRules.show();
			break;
		
		case ff::CMD_SOURCE:
			if (!m_dlgSrc.is_visible())
				m_dlgSrc.show();
			break;
		
		default:
			bDo = false; //assert
	}
	
	if (bDo)
	{
		try
		{
			ffIO << CCO_SimpleRequest(enCmd);
		}
		catch (...)
		{
		}
	}
}


void CFireFlierClient::on_radioRuleCmds_toggled(ff::Rulecommands enCmd)
{
	if (!m_bProcessing)
	{
		m_bProcessing = true;
		switch (enCmd)
		{
			case ff::RC_THIS_PACKET:
			case ff::RC_QUEUED_PACKETS:
				m_chkIPSrc->set_active(false);
				m_chkIPDst->set_active(false);
				m_chkPortSrc->set_active(false);
				m_chkPortDst->set_active(false);
				m_chkIFaceIn->set_active(false);
				m_chkIFaceOut->set_active(false);
				m_chkProtocol->set_active(false);
				m_chkProgram->set_active(false);
				m_chkTracking->set_active(false);
				m_butAccept->set_sensitive();
				m_butDrop->set_sensitive();
				break;
			
			case ff::RC_CREATE_RULE:
				// deactivate buttons because no rule can be created yet;
				// will be activated in on_Rule_compile()
				m_butAccept->set_sensitive(false);
				m_butDrop->set_sensitive(false);
				break;

			default:
				;
		}
		m_bProcessing = false;
	}
}


void CFireFlierClient::on_timeout_changed()
{
	on_Rule_compile();
	if (!m_radioCreateRule->get_active())
		m_radioCreateRule->set_active();
}


void CFireFlierClient::on_Rule_compile(Gtk::CheckButton* EventSrc)
{
	if (!m_bProcessing)
	{
		m_bProcessing = true;
		
		if (((EventSrc == m_chkPortSrc) || (EventSrc == m_chkPortDst)) &&
		    (m_chkPortSrc->get_active() || m_chkPortDst->get_active()))
		    m_chkProtocol->set_active();

		if ((EventSrc == m_chkProtocol) && (!m_chkProtocol->get_active()))
		{
		    m_chkPortSrc->set_active(false);
                    m_chkPortDst->set_active(false);
		}
		
		// mutual exclusion of program name and connection tracking
		bool bSensitive = !m_chkProgram->get_active();
		m_chkTracking->set_sensitive(bSensitive);
		bSensitive = (!m_chkTracking->get_active()) && (m_pCurPacket->programname.length());
		m_chkProgram->set_sensitive(bSensitive);

		if (m_chkIPSrc->get_active()	|| 
			m_chkIPDst->get_active()	|| 
			m_chkPortSrc->get_active()	|| 
			m_chkPortDst->get_active()	|| 
			m_chkIFaceIn->get_active()	|| 
			m_chkIFaceOut->get_active()	|| 
			m_chkProtocol->get_active()	|| 
			m_chkProgram->get_active()	|| 
			m_chkTracking->get_active()	)
		{
			// always select ``create rule" if user clicks a checkbox to compile the rule
			m_radioCreateRule->set_active();
			
			m_butAccept->set_sensitive();
			m_butDrop->set_sensitive();
		}
		else
		{
			m_butAccept->set_sensitive(false);
			m_butDrop->set_sensitive(false);
		}

		m_bProcessing = false;
	}
}

void CFireFlierClient::on_sendCmd(ff::Commands enCmd)
{
	if (m_pCurPacket && authenticated)
	{
		if (FF_DEBUG)
			switch (enCmd)
			{
				case ff::CMD_ACCEPT:
#if FF_DEBUG
					cout << "accepting" << endl;
#endif
					break;
				
				case ff::CMD_DROP:
#if FF_DEBUG
					cout << "dropping" << endl;
#endif
					break;
				
				default:
#if FF_DEBUG
					cout << "command not defined, returning" << endl;
#endif
					return;
			}
		
		ff::Rulecommands enRuleCommand = ff::RC_THIS_PACKET;
		if (m_radioQueuedPackets->get_active())
			enRuleCommand = ff::RC_QUEUED_PACKETS;
		else if (m_radioCreateRule->get_active())
			enRuleCommand = ff::RC_CREATE_RULE;
		
		guint32 nTimeout = m_mapTimeout[m_cbTimeout->get_entry()->get_text()];
		
		bool	bSrcIP		= m_chkIPSrc->get_active(), 
				bDstIP		= m_chkIPDst->get_active(), 
				bSrcPort	= m_chkPortSrc->get_active(), 
				bDstPort	= m_chkPortDst->get_active(), 
				bIFaceIn	= m_chkIFaceIn->get_active(), 
				bIFaceOut	= m_chkIFaceOut->get_active(), 
				bProtocol	= m_chkProtocol->get_active(), 
				bTracking	= m_chkTracking->get_active(), 
				bProgram	= m_chkProgram->get_active();
#if FF_DEBUG
		cerr << "bProtocol=" << bProtocol << endl;
#endif
		m_pCurPacket = NULL;
		clearInterface();
		
		try
		{
			ffIO << CCO_PacketRule(	enCmd, 
									enRuleCommand, 
									bSrcIP, 
									bDstIP, 
									bSrcPort, 
									bDstPort, 
									bIFaceIn, 
									bIFaceOut, 
									bProtocol, 
									bTracking, 
									bProgram, 
									nTimeout);
			
			if (enRuleCommand == ff::RC_CREATE_RULE)
			{
				if (bProgram)
				{
					if (m_dlgUSpaceRules.is_visible())
						ffIO << CCO_SimpleRequest(ff::CMD_URULES);
				}
				else if (m_dlgIPTablesRules.is_visible())
					ffIO << CCO_SimpleRequest(ff::CMD_RULES);
			}
		}
		catch (...)
		{
		}

#if FF_DEBUG
			cout << "command sent" << endl;
#endif
	}
}

void CFireFlierClient::setLabels()
{
#if FF_DEBUG
	cout << "Setting labels..." << endl;
#endif
	m_bProcessing = true;

	//Gtk::ResizeMode enResizeMode = get_resize_mode();
	//set_resize_mode(Gtk::RESIZE_QUEUE);

	activateInterface();
	ustring strTemp;
	ostringstream ost;

	
	m_pStatusbar->pop();
	
	if (m_pCurPacket)
	{
	const unsigned char* it = (unsigned char*) &m_pCurPacket->ip_src;
	ost << (unsigned short)*it << '.' << (unsigned short)*(it+1) << '.' << (unsigned short)*(it+2) << '.' << (unsigned short)*(it+3);
	m_labelIPSrcValue->set_text(ost.str());
	
	it = (unsigned char*) &m_pCurPacket->ip_dst;
	ost.str("");
	ost << (unsigned short)*it << '.' << (unsigned short)*(it+1) << '.' << (unsigned short)*(it+2) << '.' << (unsigned short)*(it+3);
	m_labelIPDstValue->set_text(ost.str());

	if (m_pCurPacket->port_src)
	{
		m_chkPortSrc->set_sensitive();
		ost.str("");
		ost << m_pCurPacket->port_src;
        ost << " (";
        ost << getService(m_pCurPacket->port_src, m_pCurPacket->protocol, true);
        ost << ")";
		m_labelPortSrcValue->set_text(ost.str());
	}
	
	if (m_pCurPacket->port_dst)
	{
		m_chkPortDst->set_sensitive();
		ost.str("");
		ost << m_pCurPacket->port_dst;
        ost << " (";
        ost << getService(m_pCurPacket->port_dst, m_pCurPacket->protocol, true);
        ost << ")";
		m_labelPortDstValue->set_text(ost.str());
	}
	
	switch (m_pCurPacket->protocol)
	{
		case 1:
			strTemp = strProtocol_ICMP;
			break;
		case 6:
			strTemp = strProtocol_TCP;
			break;
		case 17:
			strTemp = strProtocol_UDP;
			break;
		case 47:
			strTemp = strProtocol_GRE;
			break;
		case 0:
			ost.str("");
			ost << '(' << m_pCurPacket->protocol << ')';
			strTemp = strProtocol_UNKNOWN + ost.str();
			break;
		default:
			strTemp.clear();
			break;
	}

	m_labelProtocolValue->set_text(strTemp);
	
	if (m_pCurPacket->programname.length())
	{
		m_chkProgram->set_sensitive();
		m_labelProgramValue->set_text(m_pCurPacket->programname);
		m_labelProgramValue->set_sensitive();
	}
	
	//if (strcmp((char*)m_pCurPacket->interface_in, ""))
	if (*(char*) m_pCurPacket->interface_in)
	{
		m_chkIFaceIn->set_sensitive();
		m_labelIFaceInValue->set_text((char*) m_pCurPacket->interface_in);
		m_labelIFaceInValue->set_sensitive();
	}
	
	//if (strcmp((char*)m_pCurPacket->interface_out, ""))
	if (*(char*) m_pCurPacket->interface_out)
	{
		m_chkIFaceOut->set_sensitive();
		m_labelIFaceOutValue->set_text((char*) m_pCurPacket->interface_out);
		m_labelIFaceOutValue->set_sensitive();
	}
	
	switch (m_pCurPacket->hook)
	{
		case ff::CHAIN_INPUT:
			strTemp = strChainInput;
			break;
		case ff::CHAIN_FORWARD:
			strTemp = strChainForward;
			break;
		case ff::CHAIN_OUTPUT:
			strTemp = strChainOutput;
			break;
		default:
			strTemp = strNotAvailable;
			break;
	}

	m_labelChainValue->set_text(strTemp);
	
	
	ost.str("");
	ost << m_pCurPacket->len;
	m_labelLenValue->set_text(ost.str());
	
	strTemp.clear();
	if (m_pCurPacket->tcp_flags & 1)
		strTemp = strTCPFlag_FIN;
	if (m_pCurPacket->tcp_flags & 2)
		strTemp += strTCPFlag_SYN;
	if (m_pCurPacket->tcp_flags & 4)
		strTemp += strTCPFlag_ACK;
	if (m_pCurPacket->tcp_flags & 8)
		strTemp += strTCPFlag_RST;
	if (m_pCurPacket->protocol == 6)
	{
		m_labelTCPFlags->set_sensitive();
		m_labelTCPFlagsValue->set_text(strTemp);
		m_labelTCPFlagsValue->set_sensitive();
	}

    if (m_pCurPacket->protocol == 1)
    {
		m_labelICMPType->set_sensitive();
		m_labelICMPTypeValue->set_text(ICMP_TYPES[m_pCurPacket->icmp_type]);
		m_labelICMPTypeValue->set_sensitive();
    }

    char* szTemp = ctime((long*)&(m_pCurPacket->arrived));
	// ctime appends a newline according to tests and docu (see http://www.cplusplus.com/ref/ctime/ctime.html);
	// not needed here;
	szTemp[strlen(szTemp)-1] = 0;
	
	m_labelTimestampValue->set_text(szTemp);

	if (m_pCurPacket->mac_addrlen > 0)
	{
		ost.str("");
		ost.setf(ios::hex, ios::basefield);
		ost.width(2);
		ost.fill('0');
		ost << (int)m_pCurPacket->mac_addr[0] << ':' << 
			(int)m_pCurPacket->mac_addr[1] << ':' << 
			(int)m_pCurPacket->mac_addr[2] << ':' << 
			(int)m_pCurPacket->mac_addr[3] << ':' << 
			(int)m_pCurPacket->mac_addr[4] << ':' << 
			(int)m_pCurPacket->mac_addr[5];
		m_labelMACValue->set_text(ost.str());
		m_labelMACValue->set_sensitive();
		m_labelMAC->set_sensitive();
	}
	
	//set_resize_mode(enResizeMode);
	}
	m_bProcessing = false;
#if FF_DEBUG
	cout << "-Setting labels..." << endl;
#endif
}

void CFireFlierClient::clearInterface()
{
#if FF_DEBUG
	cout << "Clearing Interface..." << endl;
#endif
	m_bProcessing = true;
	//Gtk::ResizeMode enResizeMode = get_resize_mode();
	//set_resize_mode(Gtk::RESIZE_QUEUE);

	m_pStatusbar->pop();
	m_pStatusbar->push(strNoPacketAvail);
	m_menuItemViewSrc->set_sensitive(false);
	m_butViewSrc->set_sensitive(false);

	m_butAccept->set_sensitive(false);
	m_butDrop->set_sensitive(false);

	m_radioThisPacket->set_sensitive(false);
	m_radioThisPacket->set_active();
	m_radioQueuedPackets->set_sensitive(false);
	m_radioCreateRule->set_sensitive(false);
	
	m_labelChain->set_sensitive(false);
	m_labelChainValue->set_sensitive(false);
	m_labelChainValue->set_text("");

	m_cbTimeout->set_sensitive(false);
	m_cbTimeout->get_entry()->set_sensitive(false);
	m_cbTimeout->get_entry()->set_text(strTimeoutForever);
	m_labelTimeout->set_sensitive(false);

/*	const std::list <Widget*> cont = m_frameSrc->get_children();
	std::list <Widget*>::const_iterator it = cont.begin();
	for (; it != cont.end(); it++)
		(*it)->set_sensitive(false);
	
	const std::list <Widget*> cont1 = m_frameDst->get_children();
	for (it = cont1.begin(); it != cont1.end(); it++)
		(*it)->set_sensitive(false);
*/
	m_frameSrc->set_sensitive(false);
	m_frameSrc->get_label_widget()->set_sensitive(false);
	m_frameDst->set_sensitive(false);
	m_frameDst->get_label_widget()->set_sensitive(false);
	m_frameGeneral->set_sensitive(false);
	m_frameGeneral->get_label_widget()->set_sensitive(false);
	m_frameOptions->set_sensitive(false);
	m_frameOptions->get_label_widget()->set_sensitive(false);
	
	m_chkIPSrc->set_sensitive(false);
	m_chkIPSrc->set_active(false);
	m_labelIPSrcValue->set_text("");
	
	m_chkIPDst->set_sensitive(false);
	m_chkIPDst->set_active(false);
	m_labelIPDstValue->set_label("");
	
	m_chkPortSrc->set_sensitive(false);
	m_chkPortSrc->set_active(false);
	m_labelPortSrcValue->set_label("");
	
	m_chkPortDst->set_sensitive(false);
	m_chkPortDst->set_active(false);
	m_labelPortDstValue->set_label("");
	
	m_chkIFaceIn->set_sensitive(false);
	m_chkIFaceIn->set_active(false);
	m_labelIFaceInValue->set_text("");
	
	m_chkIFaceOut->set_sensitive(false);
	m_chkIFaceOut->set_active(false);
	m_labelIFaceOutValue->set_text("");
	
	m_chkProtocol->set_sensitive(false);
	m_chkProtocol->set_active(false);
	m_labelProtocolValue->set_label("");
	
	m_chkTracking->set_sensitive(false);
	m_chkTracking->set_active(false);
	
	m_chkProgram->set_sensitive(false);
	m_chkProgram->set_active(false);
	m_labelProgramValue->set_label("");
	
	m_labelMAC->set_sensitive(false);
	m_labelMACValue->set_text("");
	
	m_labelLen->set_sensitive(false);
	m_labelLenValue->set_text("");
	
	m_labelTCPFlags->set_sensitive(false);
	m_labelTCPFlagsValue->set_text("");
	
	m_labelICMPType->set_sensitive(false);
	m_labelICMPTypeValue->set_text("");
	
	m_labelTimestamp->set_sensitive(false);
	m_labelTimestampValue->set_text("");
										   
	m_labelHostSrc->set_sensitive(false);
	m_labelHostSrcValue->set_text("");
	
	m_labelHostDst->set_sensitive(false);
	m_labelHostDstValue->set_text("");	
	
	//set_resize_mode(enResizeMode);
	m_bProcessing = false;
#if FF_DEBUG
		cout << "-Clearing Interface..." << endl;
#endif
}

void CFireFlierClient::activateInterface()
{
#if FF_DEBUG
	cout << "activating interface..." << endl;
#endif
	m_bProcessing = true;
	
	m_butViewSrc->set_sensitive();
	m_menuItemViewSrc->set_sensitive();
	m_frameSrc->set_sensitive();
	m_frameSrc->get_label_widget()->set_sensitive();
	m_frameDst->set_sensitive();
	m_frameDst->get_label_widget()->set_sensitive();
	m_frameGeneral->set_sensitive();
	m_frameGeneral->get_label_widget()->set_sensitive();
	m_frameOptions->set_sensitive();
	m_frameOptions->get_label_widget()->set_sensitive();
	
	m_chkIPSrc->set_sensitive();
	m_labelIPSrcValue->set_sensitive();
	m_chkIPDst->set_sensitive();
	m_labelIPDstValue->set_sensitive();
	m_chkProtocol->set_sensitive();
	m_labelProtocolValue->set_sensitive();
	m_chkTracking->set_sensitive();
	
	m_radioThisPacket->set_sensitive();
	m_radioQueuedPackets->set_sensitive();
	m_radioCreateRule->set_sensitive();
	
	m_cbTimeout->set_sensitive();
	m_cbTimeout->get_entry()->set_sensitive();
	m_labelTimeout->set_sensitive();

	m_labelLen->set_sensitive();
	m_labelLenValue->set_sensitive();
	m_labelTimestamp->set_sensitive();
	m_labelTimestampValue->set_sensitive();
	
	m_labelHostSrcValue->set_text(strResolving);
	m_labelHostSrcValue->set_sensitive();
	m_labelHostSrc->set_sensitive();
	m_labelHostDstValue->set_sensitive();
	m_labelHostDstValue->set_text(strResolving);
	m_labelHostDst->set_sensitive();
	m_labelChain->set_sensitive();
	m_labelChainValue->set_sensitive();
	
	m_butAccept->set_sensitive();
	m_butDrop->set_sensitive();
	
	m_bProcessing = false;
#if FF_DEBUG
	cout << "-activating interface..." << endl;
#endif
}
