/*
 * Copyright (C) 2002 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include "enigma.hh"
#include "game.hh"
#include "gui.hh"
#include "px/pxfwd.hh"
#include "px/cache.hh"
#include "px/geom.hh"
#include "px/video.hh"

namespace enigma
{
    class OptionsMenu : public gui::Menu {
    public:
        OptionsMenu(px::Surface *background_);
    private:
        void update_info();

        // ActionListener interface.
        bool on_event (const SDL_Event &e);
        void on_action(gui::Widget *w);

        // Menu interface.
        void draw_background(px::GC &gc);
        void tick(double dtime);

        // Variables.
        gui::Widget *back, *fullscreen;
        gui::Label  *m_restartinfo;
        px::Surface *background;
    };

    void GUI_MainMenu(LevelPack *lp, unsigned ilevel_pack);
    void GUI_OptionsMenu(px::Surface *background);
}
