/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#include "dom.hh"
#include "TNode.hh"
#include "ALogger.hh"
#include "TDocument.hh"
#include "CMathMLFactoryXSLT.hh"
#include "AMathMLConsumer.hh"
#include <cassert>

CMathMLFactoryXSLT::CMathMLFactoryXSLT(ALogger& l, const DOMX::XSLTStylesheet& s)
  : AMathMLFactory(l), style(s)
{
  DOM::DOMImplementation di;
  DOM::DocumentType dt;
  result = di.createDocument(MATHML_NS_URI, "m:math", dt);
}

#if 1
void
CMathMLFactoryXSLT::documentModified(TDocument& doc)
{
  std::vector< std::pair<DOM::GdomeString, DOM::GdomeString> > dirtyId;
  if (TNode dirty = doc.dirtyNode())
    if (result.get_documentElement().hasAttribute("xref"))
      dirtyId.push_back(std::make_pair(DOM::GdomeString("id"),
				       DOM::GdomeString("'" + std::string(dirty["id"]) + "'")));
  DOM::Document res = style.apply(doc.document(), dirtyId);
  assert(res);
  //style.save(doc.document(), stdout);

  if (DOM::Element wrapper = res.get_documentElement())
    {
      if (DOM::Element root = wrapper.get_firstChild())
	if (DOM::Element oldRoot = result.get_documentElement().get_firstChild())
	  {
	    bool ok = subst(oldRoot, root.getAttribute("xref"), result.importNode(root, true));
	    assert(ok);
	    doc.clearDirty();
	  }
	else
	  {
	    result.get_documentElement().appendChild(result.importNode(root, true));
	  }
    }
  else
    {
      // Something wrong happened while applying the stylesheet.
      DOM::Element root = result.get_documentElement();
      DOM::Node p = root.get_firstChild();
      while (p) {
	DOM::Node next = p.get_nextSibling();
	root.removeChild(p);
	p = next;
      }
      logger.error("The stylesheet produced an empty document");
    }

  //style.save(result, stdout);
}
#else
void
CMathMLFactoryXSLT::documentModified(TDocument& doc)
{
  DOM::Document res = style.apply(doc.document());
  assert(res);

  if (DOM::Element root = res.get_documentElement())
    {
      DOM::Element newRoot = root.get_firstChild();
      assert(newRoot);

      if (DOM::Element oldSubRoot = result.get_documentElement().get_firstChild())
        {
	  result.get_documentElement().replaceChild(result.importNode(newRoot, true), oldSubRoot);
        }
      else
	{
	  result.get_documentElement().appendChild(result.importNode(newRoot, true));
	}
    }
  else
    {
      // Something wrong happened while applying the stylesheet.
      DOM::Element root = result.get_documentElement();
      DOM::Node p = root.get_firstChild();
      while (p) {
	DOM::Node next = p.get_nextSibling();
	root.removeChild(p);
	p = next;
      }
      logger.error("The stylesheet produced an empty document");
    }
}
#endif

bool
CMathMLFactoryXSLT::subst(const DOM::Element& e1, const DOM::GdomeString& id, const DOM::Element& e2)
{
  assert(e1);
  assert(e2);
  if (e1.getAttribute("xref") == id)
    {
      DOM::Node parent = e1.get_parentNode();
      assert(parent);
      parent.replaceChild(e2, e1);
      return true;
    }
  else
    {
      DOM::Node p = e1.get_firstChild();
      while (p)
	{
	  while (p && p.get_nodeType() != DOM::Node::ELEMENT_NODE) p = p.get_nextSibling();
	  if (p)
	    if (subst(p, id, e2)) return true;
	    else p = p.get_nextSibling();
	}
      return false;
    }
}

