/*
 * DEVICE dependent, built-in font dependent
 */

#include	"defs.h"
#include	"emit.h"
#include	"global.h"
#include	"bifont.h"
#include	"jsub.h"
#include	"ps.h"


/* TYPE: tfm
 */
void
dev_tfm_initfontdict(fe)
struct font_entry *fe;
{
    struct psbiops po;

    fe->k = dev_newdevfont();
    get_tfm_psbiops(fe, &po);
    psfindfontop(psfname(fe->k), &po);
    fe->ncdl = 0;
}

void
dev_tfm_initfe(fe)
struct font_entry *fe;
{
    DEV_FONT tfm_fontdict();
    int tfm_setchar(), tfm_setstring();
    int tfm_setchar_abs(), tfm_setstring_abs();

    fe->dev_fontdict = tfm_fontdict;
    if (bifpos_relun(tfmfinfo(fe)->tfm_bf)) {
	fe->dev_setchar = tfm_setchar;
	fe->dev_setstring = tfm_setstring;
    } else {
	fe->dev_setchar = tfm_setchar_abs;
	fe->dev_setstring = tfm_setstring_abs;
    }
}

tfm_setchar(c)
int c;
{
    struct tfmchar_entry *ce = &(tfmfinfo(curfontent)->ch[c]);
    int cw;

    begin_string();
    pschar(ce->dev_char);
    *ps_move += (cw = ce->tfmw);
    return cw;
}

tfm_setstring(s, len)
char *s;
int len;
{
    char *sp;
    struct tfmchar_entry *ce = tfmfinfo(curfontent)->ch;
    int cw;

    begin_string();
    for (sp = s, cw = 0; sp < s+len; sp++) {
	pschar((ce+*sp)->dev_char);
	cw += (ce+*sp)->tfmw;
    }
    *ps_move += cw;
    return cw;
}

tfm_setchar_abs(c)
int c;
{
    int cw;

    cw = tfm_setchar(c);
    dev_setposn_abs(ps_h, ps_v);
    return cw;
}

tfm_setstring_abs(s, len)
char *s;
int len;
{
    char *sp;
    struct tfmchar_entry *ce = tfmfinfo(curfontent)->ch;
    int cw, w;

    for (sp = s, cw = 0; sp < s+len; sp++) {
	begin_string();
	pschar((ce+*sp)->dev_char);
	end_string();
	cw += (w = (ce+*sp)->tfmw);
	*ps_move += w;
	dev_setposn_abs(ps_h, ps_v);
    }
    return cw;
}


/* TYPE: jstfm
 */
void
dev_jstfm_initfontdict(fe)
struct font_entry *fe;
{
    struct jsubshare *jss;
    struct psbiops po;

    jss = jstfmfinfo(fe)->js_share;
    jss->jss_dev_font = dev_newdevfont();
    get_jstfm_psbiops(fe, &po);
    psfindfontop(psfname(jss->jss_dev_font), &po);
    /*fe->ncdl = 0;*/
}

void
dev_jstfm_initfe(fe)
struct font_entry *fe;
{
    DEV_FONT jstfm_fontdict();
    int jstfm_setchar(), jstfm_setstring();
    int jstfm_setchar_abs(), jstfm_setstring_abs();

    fe->dev_fontdict = jstfm_fontdict;
    if (bifpos_relun(jstfmfinfo(fe)->js_bf)) {
	fe->dev_setchar = jstfm_setchar;
	fe->dev_setstring = jstfm_setstring;
    } else {
	fe->dev_setchar = jstfm_setchar_abs;
	fe->dev_setstring = jstfm_setstring_abs;
    }
}

jstfm_setchar(c)
int c;
{
    struct jstfmchar_entry *ce = &(jstfmfinfo(curfontent)->ch[c]);
    int cw;

    begin_string();
    pschar((int)ce->dev_ku);
    pschar((int)ce->dev_ten);
    *ps_move += (cw = ce->tfmw);
    return cw;
}

jstfm_setstring(s, len)
char *s;
int len;
{
    char *sp;
    struct jstfmchar_entry *ce = jstfmfinfo(curfontent)->ch;
    int cw;

    begin_string();
    for (sp = s, cw = 0; sp < s+len; sp++) {
	pschar((int)(ce+*sp)->dev_ku);
	pschar((int)(ce+*sp)->dev_ten);
	cw += (ce+*sp)->tfmw;
    }
    *ps_move += cw;
    return cw;
}

jstfm_setchar_abs(c)
int c;
{
    int cw;

    cw = jstfm_setchar(c);
    dev_setposn_abs(ps_h, ps_v);
    return cw;
}

jstfm_setstring_abs(s, len)
char *s;
int len;
{
    char *sp;
    struct jstfmchar_entry *ce = jstfmfinfo(curfontent)->ch;
    int cw, w;

    for (sp = s, cw = 0; sp < s+len; sp++) {
	begin_string();
	pschar((int)(ce+*sp)->dev_ku);
	pschar((int)(ce+*sp)->dev_ten);
	end_string();
	cw += (w = (ce+*sp)->tfmw);
	*ps_move += w;
	dev_setposn_abs(ps_h, ps_v);
    }
    return cw;
}


/* TYPE: jfm
 */
void
dev_jfm_initfontdict(fe)
struct font_entry *fe;
{
    struct psbiops po;

    fe->k = dev_newdevfont();
    get_jfm_psbiops(fe, &po);
    psfindfontop(psfname(fe->k), &po);
    fe->ncdl = 0;
}

void
dev_jfm_initfe(fe, id)
struct font_entry *fe;
int id;
{
    DEV_FONT tfm_fontdict();
    int jfm_setchar(), jfm_setstring();
    int jfm_setchar_abs(), jfm_setstring_abs();
    int jfm_setchar_v(), jfm_setstring_v();
    int jfm_setchar_vabs(), jfm_setstring_vabs();

    fe->dev_fontdict = tfm_fontdict;
    if (id == JFM_ID) {
	if (bifpos_rel(jfmfinfo(fe)->jfm_bf)) {
	    fe->dev_setchar = jfm_setchar;
	    fe->dev_setstring = jfm_setstring;
	} else {
	    fe->dev_setchar = jfm_setchar_abs;
	    fe->dev_setstring = jfm_setstring_abs;
	}
    } else {
	if (bifpos_rel(jfmfinfo(fe)->jfm_bf)) {
	    fe->dev_setchar = jfm_setchar_v;
	    fe->dev_setstring = jfm_setstring_v;
	} else {
	    fe->dev_setchar = jfm_setchar_vabs;
	    fe->dev_setstring = jfm_setstring_vabs;
	}
    }
}

jfm_setchar(c)
int c;
{
    int cw;
    struct jfmfntinfo *jfmfi = jfmfinfo(curfontent);

    begin_string();
    pschar(c>>8);
    pschar(c&0xff);
    *ps_move += (cw = jfmfi->ch[getctype(c,jfmfi)].tfmw);
    return cw;
}

/* ARGSUSED */
jfm_setstring(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: jfm_setstring", G_progname);
}

jfm_setchar_abs(c)
int c;
{
    int cw;

    cw = jfm_setchar(c);
    dev_setposn_abs(ps_h, ps_v);
    return cw;
}

/* ARGSUSED */
jfm_setstring_abs(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: jfm_setstring_abs", G_progname);
}

jfm_setchar_v(c)
int c;
{
    int cw;
    struct jfmfntinfo *jfmfi = jfmfinfo(curfontent);

    begin_string_v();
    pschar(c>>8);
    pschar(c&0xff);
    *ps_move += (cw = jfmfi->ch[getctype(c,jfmfi)].tfmw);
    return cw;
}

/* ARGSUSED */
jfm_setstring_v(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: jfm_setstring_v", G_progname);
}

/* quick hack to disable USERELPOS */
#define	no_userelpos()	--ps_v;

jfm_setchar_vabs(c)
int c;
{
    int cw;

    cw = jfm_setchar_v(c);
    no_userelpos();
    /*dev_setposn_abs(ps_h, ps_v);*/
    return cw;
}

/* ARGSUSED */
jfm_setstring_vabs(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: jfm_setstring_vabs", G_progname);
}
