<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: division.xsl,v 1.17 2003/06/22 15:50:33 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="/">
  <xsl:choose>
    <xsl:when test="set">
      <xsl:apply-templates />
    </xsl:when>

    <xsl:otherwise>
      <xsl:call-template name="make-texinfo-document" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="set">
  <texinfoset>
    <xsl:apply-templates />
  </texinfoset>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="set/book">
  <texinfo>
    <xsl:attribute name="file">
      <xsl:call-template name="get-texinfo-file-name" />
    </xsl:attribute>
        
    <xsl:call-template name="make-texinfo-directory" />

    <xsl:call-template name="section" />
  </texinfo>
</xsl:template>

<xsl:template match="book">
  <xsl:call-template name="section" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="part">
  <xsl:call-template name="section">
    <xsl:with-param name="level">majorheading</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="partintro">
  <xsl:apply-templates />
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>

