/**************************************************************
  (C) 1998 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "wmicon.h"
#include "global.h"
#include "iwc.h"
#include "extension.h"
#include "includepixmaps/icon.xpm"
#include "pixmap.h"
#include <stdlib.h>
#include <string.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

void SetWMIcon()
{
  Atom WinIcons;
  Pixmap elem[6];
  static Pixmap pmain=None;
  static Pixmap p1=None,s1=None;
  static Pixmap p2=None,s2=None;
  char *icon=NULL,*start=NULL,*pos=NULL;
  XWMHints hints;
  
  GetFileInfoFromDesktop(GetPath(),&pos,&icon,&start);
  if (icon==NULL) {
    GetExtensionParameter(GetPath(),&icon,&start);  
  }
  if (p1!=None) {
    XFreePixmap(GetDisplay(),p1);
    p1=None;
  }
  if (s1!=None) {
    XFreePixmap(GetDisplay(),s1);
    s1=None;
  }
  if (p2!=None) {
    XFreePixmap(GetDisplay(),p2);
    p2=None;
  }
  if (s2!=None) {
    XFreePixmap(GetDisplay(),s2);
    s2=None;
  }
  LoadPixmap(icon,16,&p1,&s1);
  LoadPixmap(icon,32,&p2,&s2);
  if (pmain==None) {
    DataPixmap(icon_xpm,&pmain,None);
    hints.flags=IconPixmapHint|IconMaskHint;
    hints.icon_pixmap=pmain;
    hints.icon_mask=None;
    XSetWMHints(GetDisplay(),GetWindow(),&hints);
  }
  free(icon);
  free(pos);
  free(start);
  elem[0]=2;
  elem[1]=2;
  elem[2]=p1;
  elem[3]=s1;
  elem[4]=p2;
  elem[5]=s2;

  WinIcons=XInternAtom(GetDisplay(),"_WIN_ICONS",False);
  XChangeProperty(GetDisplay(),GetWindow(),WinIcons,WinIcons,32,
		    PropModeReplace,(unsigned char*)elem,6);
}
