<?php
/*
 * $Id: class.reportPersonnelActivity.inc.php,v 1.2.4.5 2003/11/05 06:01:14 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wost');
LoadStringResource('vw');

class reportPersonnelActivity
{
	function getparameters($needHdr = true)
	{
		global $dcl_info;

		if ($needHdr == true)
			commonHeader();

		IncludeCalendar();

		$objPersonnel = CreateObject('dcl.htmlPersonnel');
		$oDept = CreateObject('dcl.htmlDepartments');

		$oDBPersonnel = CreateObject('dcl.dbPersonnel');
		$oDBPersonnel->Connect();
		if ($oDBPersonnel->Load($GLOBALS['DCLID']) == -1)
			return;

		$Template = CreateTemplate(array('hForm' => 'htmlPersonnelActivity.tpl'));

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WOST_PERSONNELACTIVITY);
		$Template->set_var('TXT_GENERATEREPORTFOR', STR_WOST_GENERATEREPORTFOR);
		$Template->set_var('TXT_DATERANGE', STR_WOST_DATERANGE);
		$Template->set_var('TXT_GROUPING', STR_CMMN_GROUPING);

		$Template->set_var('TXT_BEGINNING', STR_WOST_BEGIN);
		$Template->set_var('TXT_ENDING', STR_WOST_ENDING);
		$Template->set_var('BTN_EXECUTE', STR_CMMN_GO);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('CMB_RESPONSIBLE', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'responsible', 'lastfirst', 0, false));
		$Template->set_var('CMB_DEPARTMENTS', $oDept->GetCombo($oDBPersonnel->department, 'department', 'name', 0, false, true));

		$oSelect = CreateObject('dcl.htmlSelect');

		// By department or responsible
		$oSelect->sZeroOption = '';
		$oSelect->sName = 'bytype';
		$oSelect->sOnChange = 'onChangeByType();';
		$oSelect->aOptions = array(array('1', 'By Responsible'), array('2', 'By Department'));
		$Template->set_var('CMB_BYTYPE', $oSelect->GetHTML());

		// Optional group by
		$oSelect->sZeroOption = 'None';
		$oSelect->sName = 'groupby';
		$oSelect->sOnChange = '';
		$oSelect->aOptions = array(array('1', 'Project'), array('2', 'Action'), array('3', 'Date'));
		$Template->set_var('CMB_GROUPBY', $oSelect->GetHTML());

		if (IsSet($GLOBALS['begindate']))
			$Template->set_var('VAL_BEGINDATE', $GLOBALS['begindate']);
		else
			$Template->set_var('VAL_BEGINDATE', '');

		if (IsSet($GLOBALS['enddate']))
			$Template->set_var('VAL_ENDDATE', $GLOBALS['enddate']);
		else
			$Template->set_var('VAL_ENDDATE', '');

		$Template->pparse('out', 'hForm');
	}

	function execute()
	{
		$bExport = (IsSet($GLOBALS['export']) && $GLOBALS['export'] == '1');

		if (!$bExport)
			commonHeader();

		if ($GLOBALS['begindate'] == '' || $GLOBALS['enddate'] == '')
		{
			if ($bExport)
				commonHeader();

			print('<center>');
			PrintWithChocoFont(STR_WOST_DATEERR);
			print('</center><p>');
			$this->GetParameters(false);
			return;
		}

		$objP = CreateObject('dcl.dbPersonnel');
		$objS = CreateObject('dcl.dbStatuses');
		$objPr = CreateObject('dcl.dbPriorities');
		$objSe = CreateObject('dcl.dbSeverities');
		$objW = CreateObject('dcl.dbWorkorders');
		$objT = CreateObject('dcl.dbTimeCards');
		$objD = CreateObject('dcl.dbDepartments');
		$objDB = new dclDB;

		$objP->Connect();
		$objS->Connect($objP->conn);
		$objPr->Connect($objP->conn);
		$objSe->Connect($objP->conn);
		$objW->Connect($objP->conn);
		$objT->Connect($objP->conn);
		$objDB->Connect($objP->conn);
		$objD->Connect($objP->conn);

		$sReportFor = '';
		$sCols = 'timecards.jcn, timecards.seq, timecards.hours';
		if ($GLOBALS['bytype'] == '2')
			$sCols .= ', personnel.short';

		if ($GLOBALS['groupby'] == '1')
			$sCols .= ', dcl_projects.name';
		else if ($GLOBALS['groupby'] == '2')
			$sCols .= ', actions.name';
		else if ($GLOBALS['groupby'] == '3')
			$sCols .= ', timecards.actionon';

		if ($GLOBALS['bytype'] == '1')
		{
			$objP->Load($GLOBALS['responsible']);
			$sReportFor = $objP->firstNameLast;
		}
		else
		{
			$objD->Load($GLOBALS['department']);
			$sReportFor = $objD->name;
		}

		$iGroupColumn = -1;
		$query = "select $sCols from timecards ";
		if ($GLOBALS['groupby'] == '0' || $GLOBALS['groupby'] == '3')
		{
			if ($GLOBALS['bytype'] == '1')
			{
				$query .= ' where actionby=' . $GLOBALS['responsible'];
				$query .= ' and actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
			}
			else
			{
				$query .= $objDB->JoinKeyword . ' personnel on actionby = personnel.id ';
				$query .= 'where personnel.department=' . $GLOBALS['department'];
				$query .= ' and actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
			}

			if ($GLOBALS['groupby'] == '0')
				$query .= ' order by jcn, seq';
			else
			{
				$query .= ' order by actionon, jcn, seq';
				$iGroupColumn = 13;
				if ($GLOBALS['bytype'] != '1')
					$iGroupColumn++;
			}
		}
		else if ($GLOBALS['groupby'] == '1')
		{
			// projects
			if ($GLOBALS['bytype'] == '1')
			{
				$query .= 'left join projectmap on timecards.jcn = projectmap.jcn and projectmap.seq in (timecards.seq, 0) ';
				$query .= 'left join dcl_projects on dcl_projects.projectid = projectmap.projectid ';
				$query .= ' where timecards.actionby=' . $GLOBALS['responsible'];
				$query .= ' and timecards.actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
				$iGroupColumn = 13;
			}
			else
			{
				$query .= $objDB->JoinKeyword . ' personnel on actionby = personnel.id ';
				$query .= 'left join projectmap on timecards.jcn = projectmap.jcn and projectmap.seq in (timecards.seq, 0) ';
				$query .= 'left join dcl_projects on dcl_projects.projectid = projectmap.projectid ';
				$query .= 'where personnel.department=' . $GLOBALS['department'];
				$query .= ' and actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
				$iGroupColumn = 14;
			}

			$query .= ' order by dcl_projects.name, timecards.jcn, timecards.seq';
		}
		else
		{
			// actions
			if ($GLOBALS['bytype'] == '1')
			{
				$query .= $objDB->JoinKeyword . ' actions on timecards.action = actions.id ';
				$query .= ' where timecards.actionby=' . $GLOBALS['responsible'];
				$query .= ' and timecards.actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
				$iGroupColumn = 13;
			}
			else
			{
				$query .= $objDB->JoinKeyword . ' personnel on actionby = personnel.id ';
				$query .= $objDB->JoinKeyword . ' actions on timecards.action = actions.id ';
				$query .= 'where personnel.department=' . $GLOBALS['department'];
				$query .= ' and actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
				$iGroupColumn = 14;
			}

			$query .= ' order by actions.name, timecards.jcn, timecards.seq';
		}

		if ($objDB->Query($query) != -1)
		{
			if ($objDB->next_record())
			{
				$lastJCN = 0;
				$lastSeq = 0;
				$lastGroup = $thisGroup = '<< undefined >>';
				$arrayIndex = -1;
				$count = 0;
				$totalEstHours = 0.0;
				$totalAppliedHours = 0.0;
				$totalEtcHours = 0.0;
				$totalTimeHours = 0.0;
				$oDate = new DCLDate;
				$aByDate = array();
				do
				{
					$thisJCN = $objDB->f('jcn');
					$thisSeq = $objDB->f('seq');
					if ($GLOBALS['groupby'] == '3')
					{
						$oDate->SetFromDB($objDB->f('actionon'));
						$thisGroup = $oDate->ToDisplay();
					}
					else if ($GLOBALS['groupby'] != '0')
						$thisGroup = $objDB->f('name');

					// Skip multiple time cards
					if ($thisJCN != $lastJCN || $thisSeq != $lastSeq || $thisGroup != $lastGroup)
					{
						$arrayIndex++;
						$objW->Load($thisJCN, $thisSeq);
						$objS->Load($objW->status);
						$objPr->Load($objW->priority);
						$objSe->Load($objW->severity);

						if ($bExport)
							$reportArray[$arrayIndex][0] = '[' . $thisJCN . '-' . $thisSeq . '] ' . $objW->summary;
						else
							$reportArray[$arrayIndex][0] = '[<a class="adark" href="main.php?menuAction=boWorkorders.viewjcn&jcn=' . $thisJCN . '&seq=' . $thisSeq . '">' . $thisJCN . '-' . $thisSeq . '</a>] ' . $objW->summary;

						if ($GLOBALS['bytype'] == '2')
							$reportArray[$arrayIndex][] = $objDB->f('short');

						$reportArray[$arrayIndex][] = $objS->short;
						$reportArray[$arrayIndex][] = $objPr->short;
						$reportArray[$arrayIndex][] = $objSe->short;
						$reportArray[$arrayIndex][] = (double)$objW->esthours;
						$reportArray[$arrayIndex][] = (double)$objW->etchours;
						$reportArray[$arrayIndex][] = (double)$objW->totalhours;
						$reportArray[$arrayIndex][] = $objW->eststarton;
						$reportArray[$arrayIndex][] = $objW->estendon;
						$reportArray[$arrayIndex][] = $objW->starton;
						$reportArray[$arrayIndex][] = $objW->closedon;
						$reportArray[$arrayIndex][] = (double)$objDB->f('hours');
						$ouHours = -($objW->esthours - $objW->totalhours);
						$diffHours = $ouHours;
						if ($diffHours < 0)
							$diffHours = -$diffHours;

						$ouPct = 0.0;
						$sign = '';
						if ($objW->esthours > 0)
						{
							$ouPct = $diffHours / $objW->esthours * 100;
							if ($objW->esthours > $objW->totalhours && $objW->esthours > 0)
								$sign = '-';
							else if ($objW->totalhours > $objW->esthours && $objW->totalhours > 0)
									$sign = '+';
						}

						if ($bExport)
							$reportArray[$arrayIndex][] = sprintf('%s%0.2f (%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct));
						else
							$reportArray[$arrayIndex][] = sprintf('%s%0.2f&nbsp;(%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct));

						if ($GLOBALS['groupby'] != '0')
							$reportArray[$arrayIndex][] = $thisGroup;

						$sKey = sprintf('%d-%d', $thisJCN, $thisSeq);
						if ($GLOBALS['groupby'] != '3' || !isset($aByDate[$sKey]))
						{
							$totalEstHours += (double)$objW->esthours;
							$totalAppliedHours += (double)$objW->totalhours;
							$totalEtcHours += (double)$objW->etchours;

							$aByDate[$sKey] = true;
						}

						$lastJCN = $thisJCN;
						$lastSeq = $thisSeq;
						$lastGroup = $thisGroup;
					}
					else
					{
						if ($GLOBALS['bytype'] == '2')
							$reportArray[$arrayIndex][12] += (double)$objDB->f('hours');
						else
							$reportArray[$arrayIndex][11] += (double)$objDB->f('hours');
					}

					$totalTimeHours += $objDB->f('hours');
					$count++;
				}
				while ($objDB->next_record());

				$arrayIndex++;
				if ($bExport)
					$reportArray[$arrayIndex][0] = 'Totals';
				else
					$reportArray[$arrayIndex][0] = '<b>Totals</b>';

				if ($GLOBALS['bytype'] == '2')
					$reportArray[$arrayIndex][] = '';

				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = $totalEstHours;
				$reportArray[$arrayIndex][] = $totalEtcHours;
				$reportArray[$arrayIndex][] = $totalAppliedHours;
				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = '';
				$reportArray[$arrayIndex][] = $totalTimeHours;
				$ouHours = -($totalEstHours - $totalAppliedHours);
				$diffHours = $ouHours;
				if ($diffHours < 0)
					$diffHours = -$diffHours;

				$ouPct = 0.0;
				$sign = '';
				if ($totalEstHours > 0)
				{
					$ouPct = $diffHours / $totalEstHours * 100;
					if ($totalEstHours > $totalAppliedHours && $totalEstHours > 0)
						$sign = '-';
					else if ($totalAppliedHours > $totalEstHours && $totalAppliedHours > 0)
							$sign = '+';
				}

				if ($bExport)
					$reportArray[$arrayIndex][] = sprintf('%s%0.2f (%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct));
				else
					$reportArray[$arrayIndex][] = sprintf('%s%0.2f&nbsp;(%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct));

				$nameArray = array();
				$nameArray[] = STR_WOST_SUMMARY;
				if ($GLOBALS['bytype'] == '2')
					$nameArray[] = STR_CMMN_BY;

				$nameArray[] = STR_WOST_STATUSABB;
				$nameArray[] = STR_WOST_PRIORITYABB;
				$nameArray[] = STR_WOST_SEVERITYABB;
				$nameArray[] = STR_WOST_BUDGET;
				$nameArray[] = STR_WOST_ETC;
				$nameArray[] = STR_WOST_TODATE;
				$nameArray[] = STR_WOST_ESTSTART;
				$nameArray[] = STR_WOST_ESTEND;
				$nameArray[] = STR_WOST_START;
				$nameArray[] = STR_WOST_END;
				$nameArray[] = STR_WOST_TIME;
				$nameArray[] = '+&nbsp;/&nbsp;-';

				if ($GLOBALS['groupby'] != '0')
					$nameArray[] = '';

				if ($bExport)
				{
					$nameArray[12] = '+ / -';
					ExportArray($nameArray, $reportArray);
				}
				else
					PrintArrayAsChocoTable(
							$nameArray,
							$reportArray,
							sprintf(STR_WOST_ACTIVITYTITLE, $sReportFor, $GLOBALS['begindate'], $GLOBALS['enddate']),
							'',
							'<a href="' . menuLink('', sprintf('menuAction=reportPersonnelActivity.execute&export=1&responsible=%s&begindate=%s&enddate=%s', $GLOBALS['responsible'], $GLOBALS['begindate'], $GLOBALS['enddate'])) . '" class="adark">' . STR_VW_EXPORTRESULTS . '</a>',
							false,
							$iGroupColumn,
							false,
							$iGroupColumn - 2,
							sprintf('[%%0.2f%s]', STR_WOST_HOURSABBREV)
						);
			}
			else
			{
				if ($bExport)
					commonHeader();

				print('<center>');
				PrintWithChocoFont(STR_WOST_NOACTIVITY);
				print('</center>');
			}
		}
		else
		{
			if ($bExport)
				commonHeader();

			print(STR_WOST_QUERYERR);
		}
	}
}
?>
