<?php
/*
 * $Id: class.htmlFaqquestions.inc.php,v 1.3.2.1.2.1 2002/07/03 18:35:04 dneighbors Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('faq');

class htmlFaqquestions
{
	function DisplayForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlFaqquestionsForm.tpl'));

		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', STR_FAQ_EDITFAQQUESTION);
			$Template->set_var('VAL_SEQ', $obj->seq);
			$Template->set_var('VAL_QUESTIONTEXT', htmlspecialchars($obj->questiontext));
			$hiddenvars = '<input type="hidden" name="menuAction" value="boFaqquestions.dbmodify">' .
				'<input type="hidden" name="questionid" value="' . $obj->questionid . '">';
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_FAQ_ADDFAQQUESTION);
			$Template->set_var('VAL_SEQ', '');
			$Template->set_var('VAL_QUESTIONTEXT', '');
			$hiddenvars = '<input type="hidden" name="menuAction" value="boFaqquestions.dbadd">' .
				'<input type="hidden" name="topicid" value="' . $GLOBALS['topicid'] . '">';
		}

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		$Template->set_var('TXT_DISPLAYSEQ', STR_FAQ_DISPLAYSEQ);
		$Template->set_var('TXT_QUESTION', STR_FAQ_QUESTION);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_FAQ_HIGHLIGHTEDNOTE);

		$Template->pparse('out', 'hForm');
	}

	function ShowQuestion($obj)
	{
		global $dcl_info;

		if (!is_object($obj))
		{
			print('<p><center>');
			PrintWithChocoFont('[htmlFaqquestions::ShowQuestion] ' . STR_FAQ_QUESTIONOBJECTNOTPASSED);
			print('</center>');
			return;
		}

		$objFaqT = CreateObject('dcl.dbFaqtopics');
		$objFaqT->Connect($obj->conn);
		$objFaqT->Load($obj->topicid);

		$objFaq = CreateObject('dcl.dbFaq');
		$objFaq->Connect($obj->conn);
		$objFaq->Load($objFaqT->faqid);

		$Template = CreateTemplate(array('hForm' => 'htmlFaqquestionsDetail.tpl'));
		$Template->set_block('hForm', 'answers', 'hAnswers');
		$Template->set_block('hForm', 'noanswers', 'hNoAnswers');
		$Template->set_var('hAnswers', '');
		$Template->set_var('hNoAnswers', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_VIEWFAQLINK', menuLink('', 'menuAction=boFaq.view&faqid=' . $objFaq->faqid));
		$Template->set_var('VAL_VIEWTOPICLINK', menuLink('', 'menuAction=boFaqtopics.view&topicid=' . $objFaqT->topicid));
		$Template->set_var('VAL_ADDANSWERLINK', menuLink('', 'menuAction=boFaqanswers.add&questionid=' . $obj->f('questionid')));
		$Template->set_var('TXT_QUESTIONFOR', STR_FAQ_QUESTIONFOR);
		$Template->set_var('TXT_FAQ', STR_FAQ_FAQ);
		$Template->set_var('TXT_TOPIC', STR_FAQ_TOPIC);
		$Template->set_var('TXT_ANSWERS', STR_FAQ_ANSWERS);
		$Template->set_var('TXT_NEW', STR_FAQ_NEW);

		$Template->set_var('VAL_FAQID', $objFaq->faqid);
		$Template->set_var('VAL_FAQNAME', htmlspecialchars($objFaq->name));
		$Template->set_var('VAL_TOPICID', $objFaqT->topicid);
		$Template->set_var('VAL_TOPICNAME', htmlspecialchars($objFaqT->name));
		$Template->set_var('VAL_QUESTIONTEXT', htmlspecialchars($obj->questiontext));
		$Template->set_var('VAL_QUESTIONID', $obj->f('questionid'));

		$objF = CreateObject('dcl.dbFaqanswers');
		$objF->Connect($obj->conn);
		$objF->LoadByQuestionID($obj->questionid);
		if ($objF->next_record())
		{
			$i = 0;
			do
			{
				if ($i++ % 2 == 0)
					$Template->set_var('ROW_COLOR', '#ffffff');
				else
					$Template->set_var('ROW_COLOR', $dcl_info['DCL_COLOR_LIGHT']);

				$Template->set_var('VAL_ANSWERTEXT', htmlspecialchars($objF->f('answertext')));
				$Template->parse('hAnswers', 'answers', true);
			}
			while ($objF->next_record());
		}
		else
		{
			$Template->set_var('TXT_NOANSWERS', STR_FAQ_NOANSWERS);
			$Template->parse('hNoAnswers', 'noanswers');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
