/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * seen_hub_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: seen_hub_clist.c,v 1.7 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <fcntl.h>
#include <signal.h>
#include <dirent.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "seen_hub_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "status.h"
#include "init_fnc.h"
#include "bdb.h"
#include "gtk_helper.h"
#include "hublist_converter.h"

static GtkListStore *build_empty_seen_hub_clist(void);

/*************************************************************************************/
/* this function updates the gnome vector containing seen hub to include the new one */
/*************************************************************************************/
/* input: GArray of HUB_ENTRY */
/******************************/
void update_seen_hub_list(GArray *new_seen)
{
	int i;
	GString *tmp;
	char buf[2048];

	tmp=g_string_new("");

	for(i=0;i<new_seen->len;i++)
	{
		HUB_ENTRY *he;

		he=&(g_array_index(new_seen,HUB_ENTRY,i));
		/* rebuild the initial string */
		sprintf(buf,"%s|%s|%s|%d|%s|%llu|%s|%llu|%u|%u|%u|%f|%d",
						he->hubname,he->hubaddr,he->hubdesc,he->nb_users,
						he->country,he->shares,he->status,he->minshare,
						he->minslots,he->maxhub,he->maxusers,he->reliability,he->rating
						);

		/* to ease future usage of values, the key and its value is stored with the trailing '\0' (==C string format)*/
		set_key_data(seen_hub_db,he->hubaddr,strlen(he->hubaddr)+1,buf,strlen(buf)+1);
	}

	g_string_free(tmp,TRUE);
}

/********************************************************************/
/* fill the clist named "seen_hub_clist" with the list of seen hubs */
/********************************************************************/
void fill_seen_hub_clist(int flag)
{
	GtkWidget *w;
	GtkListStore *gls;
	GtkTreeModel *gtm;
	GtkTreeIter iter;
	DBC *cursor;
	int ret;
	SORT_VARS( )

	w=get_widget_by_widget_name(main_window,"seen_hub_clist");
	if(w==NULL)
		return;

	gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w));

	if((flag==FALSE)&&(gtk_tree_model_is_not_empty(gtm)))
		return;

	/* save current sort order */
	SORT_GET(,gtm)

	gls=build_empty_seen_hub_clist();

	/* we must get all keys of seen_hub berkeley Database */
	/* the value of the keys are to put in buf and to process */
	ret=seen_hub_db->cursor(seen_hub_db,NULL,&cursor,0);
	if(ret==0)
	{
		DBT key;
		DBT data;
		int counter=0;
		char buf1[8192];
		char buf2[8192];

		memset(&key,0,sizeof(key));
		memset(&data,0,sizeof(data));

		key.data=buf1;
		key.ulen=sizeof(buf1)-1;
		key.flags=DB_DBT_USERMEM;

		data.data=buf2;
		data.ulen=sizeof(buf2)-1;
		data.flags=DB_DBT_USERMEM;

		ret=cursor->c_get(cursor,&key,&data,DB_FIRST);
		while(ret==0)
		{
			char *ent[4];
			char *t;

			/* should not be useful but who knows what appends if someone enters invalid keys */
			buf2[data.size]='\0';

			ent[0]=buf2;
	
#warning to UPDATE 
			t=strchr(buf2,'|');
			if(t==NULL)
				continue;
			*t++='\0';

			ent[3]=t;
			t=strchr(t,'|');
			if(t==NULL)
				continue;
			*t++='\0';

			ent[2]=t;
			t=strchr(t,'|');
			if(t==NULL)
				continue;
			*t++='\0';

			ent[1]=t;
			t=strchr(t,'|');
			if(t==NULL)
				continue;
			*t++='\0';

			gtk_list_store_append (gls, &iter);
			if(utf8_mode==TRUE)
			{
				gtk_list_store_set(gls,&iter,SHC_HUB_NAME_COL,ent[0],
														SHC_NB_USERS_COL,atoi(ent[1]),
														SHC_DESC_COL,ent[2],
														SHC_HUB_ADDR_COL,ent[3],
														SHC_RIGHT_ALIGN_COL,1.0,
														SHC_HUB_NAME,ent[0],
														SHC_DESC,ent[2],
														-1);
			}
			else
			{
				gchar *utf8_e0, *utf8_e2;

				utf8_e0=g_locale_to_utf8(ent[0],-1,NULL,NULL,NULL);
				utf8_e2=g_locale_to_utf8(ent[2],-1,NULL,NULL,NULL);
				gtk_list_store_set(gls,&iter,SHC_HUB_NAME_COL,utf8_e0,
														SHC_NB_USERS_COL,atoi(ent[1]),
														SHC_DESC_COL,utf8_e2,
														SHC_HUB_ADDR_COL,ent[3],
														SHC_RIGHT_ALIGN_COL,1.0,
														SHC_HUB_NAME,ent[0],
														SHC_DESC,ent[2],
														-1);
				g_free(utf8_e0);
				g_free(utf8_e2);
			}

			counter++;

			ret=cursor->c_get(cursor,&key,&data,DB_NEXT);
		}

		/* end of scan, destroy the cursor */
		cursor->c_close(cursor);
		printf("total: %d entrys.\n",counter);
	}

	/* restore original sort order */
	SORT_RESTORE(,GTK_TREE_MODEL(gls))

	/* install the new store in place of the current want (will be automatically released) */
	gtk_tree_view_set_model(GTK_TREE_VIEW(w),GTK_TREE_MODEL(gls));
}

/************************************************/
/* create an empty store for the seen_hub_clist */
/************************************************/
static GtkListStore *build_empty_seen_hub_clist(void)
{
	return gtk_list_store_new(NB_SHC_COL, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING,G_TYPE_STRING, G_TYPE_FLOAT, G_TYPE_STRING, G_TYPE_STRING);
}

/************************************************/
/* build modele and view for the seen hub clist */
/************************************************/
void bmav4_seen_hub_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=build_empty_seen_hub_clist();

	view=get_widget_by_widget_name(main_window,"seen_hub_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),SHC_HUB_NAME_COL,_("Hubname"),rend,"text",SHC_HUB_NAME_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),SHC_NB_USERS_COL,_("#users"),rend,"text",SHC_NB_USERS_COL,"xalign",SHC_RIGHT_ALIGN_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),SHC_DESC_COL,_("Description"),rend,"text",SHC_DESC_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),SHC_HUB_ADDR_COL,_("Address"),rend,"text",SHC_HUB_ADDR_COL,NULL);


	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}


