/* Distributed Checksum Clearinghouse
 *
 * Copyright (c) 2005 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.74-1.10 $Revision$
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"


char *
dcc_cnt2str(char *buf, u_int buf_len, DCC_TGTS tgts, u_char grey_on)
{
	switch (tgts) {
	case DCC_TGTS_TOO_MANY:
		if (grey_on)
			STRLIMCPY(buf, buf_len, DCC_XHDR_GREY_PASS);
		else
			STRLIMCPY(buf, buf_len, DCC_XHDR_TOO_MANY);
		break;
	case DCC_TGTS_OK:
		STRLIMCPY(buf, buf_len, DCC_XHDR_OK);
		break;
	case DCC_TGTS_OK2:
		if (grey_on)
			STRLIMCPY(buf, buf_len, DCC_XHDR_OK);
		else
			STRLIMCPY(buf, buf_len, DCC_XHDR_OK2);
		break;
	case DCC_TGTS_DEL:
		STRLIMCPY(buf, buf_len, DCC_XHDR_DEL);
		break;
	case DCC_TGTS_INVALID:
		STRLIMCPY(buf, buf_len, DCC_XHDR_INVALID);
		break;
	default:
		snprintf(buf, buf_len, "%d", tgts);
		break;
	}

	return buf;
}
