<?php
/**
 * Class to manage user's session 
 *
 * daCode http://www.dacode.org/
 * src/phplib/session.php3
 * $Id: session.php3,v 1.70.2.18 2002/08/04 20:40:48 ruffy Exp $
 */
Class Session {
	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * user's id
	 *@var integer
	 */
	var $user_id;

	/**
	 * user's first name
	 *@var string
	 */
	var $fname;

	/**
	 * user's last name
	 *@var string
	 */
	var $lname;

	/**
	 * user's login
	 *@var string
	 */
	var $login;

	/**
	 * user's email
	 *@var string
	 */
	var $email;

	/**
	 * user's level give info about his right
	 *@var integer
	 */
	var $level;

	/**
	 * user's parameters (sig, userboxes...) 
	 *@var integer
	 */
	var $param;

	/**
	 * user's account creation date
	 *@var integer
	 */
	var $timestamp;

	/**
	 * user's last login date
	 *@var integer
	 */
	var $last;

	/**
	 * user's have a valid session or not
	 *@var boolean
	 */
	var $checked;

	/**
	 * user's sig_id in table "sig"
	 *@var boolean
	 */
	var $sig_id;

	/**
	 * user's want to hide his sig or not
	 *@var boolean
	 */
	var $hide_sig;

	/**
	 * user's home site url
	 *@var string
	 */
	var $homesite;

	/**
	 * user's signature
	 *@var string
	 */
	var $signature;

	/**
	 * user's encrypted password
	 *@var string
	 */
	var $password;

	/**
	 * tell if a user was ever logged.
	 *@var boolean
	 */
	var $status;

	/**
	 * user's inferior limit of visible comments
	 *@var integer
	 */
	var $score;

	/**
	 * number of the theme selected by user
	 *@var integer
	 */
	var $theme;

	/**
	 * user's additionnal information
	 *@var array
	 */
	var $supp_info;

	/**
	 * user's boxes
	 *@var array
	 */
	var $user_boxes;

	/**
	 * did user selected boxes ?
	 *@var boolean
	 */
	var $has_user_boxes;

	/**
	 * Tells whether the user is identified or not.
	 *@var boolean
	 *@access public
	 */
	var $checked;

	/**
	 * Class constructor 
	 */
	Function Session() {
		global $HTTP_COOKIE_VARS, $HTTP_SERVER_VARS, $config;
		
		$this->db = LoadClass('Db');
		$this->utils = LoadClass('Utils');
		
		$this->user_id=1;
		$this->fname="";
		$this->lname="";
		$this->login=(isset($HTTP_COOKIE_VARS['login']) ?
			$HTTP_COOKIE_VARS['login'] : lecho("Anonymous"));
		$this->email="";
		$this->level=0;
		$this->param=128;
		$this->timestamp=0;
		$this->lastseen=0;
		$this->homesite="";
		$this->last=0;
		$this->checked=0;
		$this->sig_id=1;
		$this->status=0;
		$this->user_boxes=array();
		$this->has_user_boxes=0;
		$this->score=$config->dft_prefs['score'];
		$this->hide_sig=$config->dft_prefs['hide_sig'];
		$this->theme=$config->dft_prefs['theme'];
		$this->signature="";
		$this->password="";
		$this->HTTP_REFERER=isset($HTTP_SERVER_VARS['HTTP_REFERER'])?$HTTP_SERVER_VARS['HTTP_REFERER']:'';
		$this->supp_info = array();
		// Used in case of moderation type 2
		$this->karma_name="";
		$this->vote_nb=0;
		$this->vote_nb_orig=0;
		$this->experience=0;

		$this->check();

		//  Adjust some variables
		$config->score=$this->score;
		$config->hide_sig=$this->hide_sig;
		$config->theme=$this->theme;
		$config->theme_name=$config->listofthemes[$config->theme];

		$this->is_moderator = $this->checked && ($this->level&pow(2,21));
		$this->is_admin  = $this->checked && ($this->level&pow(2,22));
		$this->is_scoror = $this->checked && ($this->level&pow(2,23));
		$this->is_anonym = (!isset($HTTP_COOKIE_VARS['session_id']));

		//  Make sure this theme is valid
		if (empty($config->theme_name)) {
			$config->theme = $config->dft_prefs['theme'];
			$config->theme_name=$config->listofthemes[$config->theme];
		}

		$config->ext = ','.$config->theme.",".$this->has_user_boxes;
		if ($this->checked) {
			$config->ext .= '.'.$config->php;
		} else {
			$config->ext .= '.html';
		}
		$config->extraopts = ','.$this->hide_sig.','.$this->score;

	}

	/**
	 * Close the session of a user
	 *
	 * remove session_id from db and 
	 * call to header() and exit
	 *
	 *@access public
	 *@param string $reload the reload argument to put after the url
	 */
	Function close($reload) {
		global $HTTP_COOKIE_VARS,$config;
		if ($HTTP_COOKIE_VARS['session_id']) {

			// Delete from database
			$c = new User; // FixMe When Thereis $this->user = LoadClass('User); in constructor it's bug
			$current[] = $HTTP_COOKIE_VARS['session_id'];
			$c->do_delete_sessions($current);
			
			setcookie("session_id","",0,"/",$config->cookiedomain);
			if (!empty($this->HTTP_REFERER)) {
				$ref = $this->HTTP_REFERER;
			} else {
				$ref = $config->basehref;
			}
			
			//  Reset session variables
			$this->Session();
			header("Location: ".$ref.$reload);
			exit;
		} else {
			header("Location: ".$config->basehref.$reload);
			exit;
		}
	}

	/**
	 * Check the session of the user
	 *
	 * Warning: call to exit if DB is off.
	 *
	 *@access private
	 *@return mixed Error message or boolean, 1 if ok, 0 if not, -1 db error
	 */
	Function check() {
		global $HTTP_COOKIE_VARS;
		global $config;

		$session_id=isset($HTTP_COOKIE_VARS['session_id'])?
			$HTTP_COOKIE_VARS['session_id']:'';

		if (empty($session_id))
			return 0;
		$ip=$this->utils->ip();
		$sqlc_q = "SELECT expire,".
			$config->tables['users'].".id,fname,lname,".
			$config->tables['users'].".login,email,level,".
			"param,created,".
			$config->tables['users'].".lastseen,sig_id,homesite,passwd,theme,status,".
			"score,".
			$config->tables['sessions'].".lastseen FROM ".
			$config->tables['users'].",".
			$config->tables['sessions']." WHERE ".
			$config->tables['sessions'].".id='".addslashes($session_id)."'".
			" AND expire>=CURRENT_TIMESTAMP AND ".
			$config->tables['users'].".id=".
			$config->tables['sessions'].".user_id";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("It looks like admins are working on the server") . $this->db->error();
			exit;
		}

		if ($this->db->num_rows()==1) {
			$c=$this->db->fetch_array();
			if ($c['expire']) {
				$this->user_id=$c['id'];
				$this->fname=(isset($c['fname'])) ? $c['fname'] : "";
				$this->lname=(isset($c['lname'])) ? $c['lname'] : "";
				$this->login=$c['login'];
				$this->email=$c['email'];
				$this->level= (int) $c['level'];
				$this->param=$c['param'];
				$this->timestamp=$c['created'];
				$this->lastseen=$c['lastseen'];
				$this->last=$c['lastseen'];
				$this->sig_id=$c['sig_id'];
				$this->homesite=(isset($c['homesite'])) ? $c['homesite'] : "";
				$this->password=$c['passwd'];
				$this->theme=$c['theme'];
				$this->status=$c['status'];
				$this->score=$c['score'];
			}

			$this->checked = 1;
			$this->hide_sig = ($this->param & pow(2,2) ? 1 : 0);
			//echo "<font color=green>Shall be OK</font>\n";
			$this->has_user_boxes = (($this->param & pow(2,5)) ? 1 : 0);

			$this->db->free();

			/*
			 * We fetch supplementary info
			 */
			$sqlc_q = "SELECT supp_info FROM ".$config->tables['users_supp'].
				" WHERE user_id='".addslashes($c['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
				return "<span class=\"newstext\">".
					lecho("Something went wrong. ").
					lecho("Please contact the webmaster.")."</span><br />";
			}
			if ($this->db->num_rows()) {
				$c=$this->db->fetch_array();
				$this->supp_info = unserialize($c['supp_info']);
				$this->db->free();
			} else {
				$this->supp_info = array ();
			}

			/*
			 * We do fetch user boxes
			 */
			if ($this->has_user_boxes) {
				$sqlc_q = "SELECT user_boxes FROM ".
						$config->tables['users_boxes'].
						" WHERE user_id='".addslashes($this->user_id)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
					return "<span class=\"newstext\">".
						lecho("Something went wrong. ").
						lecho("Please contact the webmaster.")."</span><br />";
				}

				if ($this->db->num_rows() > 0) {
					$c=$this->db->fetch_array();
					$this->user_boxes=unserialize($c['user_boxes']);
				} else {
					$this->user_boxes = array();
				}

				$this->db->free();
			}

			/*
			 * In case the second moderation system has been choosen
			 */
			if ($config->moderation_type == 2) {
				$sqlc_q = "SELECT vote_nb,vote_nb_orig,experience FROM ".
					$config->tables['karma_user']." WHERE user_id='".
					addslashes($this->user_id)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
					return "<span class=\"newstext\">".
						lecho("Something went wrong. ").
						lecho("Please contact the webmaster.")."</span><br />";
				}

				if ($this->db->num_rows() > 0) {
					$c=$this->db->fetch_array();
					$this->vote_nb = $c['vote_nb'];
					$this->vote_nb_orig=$c['vote_nb_orig'];
					$this->experience=$c['experience'];
					reset($config->level_values);
					$i=0;
					while(list(,$val) = each($config->level_values)) {
						if ($this->experience >= $val['xp']) {
							$i++;
							continue;
						} else {
							$i--;
							$this->karma_name = lecho($config->level_values[$i]['name']);
							break;
						}
					}
				}
				$this->db->free();
			}


			// This is in case the account hasn't be validated yet
			if ($this->status == 0) {
				$sqlc_q = "UPDATE ".$config->tables['users'].
					" SET status='1',created=created WHERE id='".
					addslashes($this->user_id)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo lecho("SQL Failed: ").$sqlc_q.$this->db->error();
					return -1;
				}
			}
			//

			$sqlc_q = "UPDATE ".$config->tables['sessions'].
				" SET lastseen=CURRENT_TIMESTAMP,ip='". addslashes($ip) ."' WHERE id='".
				addslashes($session_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$sqlc_q.$this->db->error();
				return -1;
			}

			$sqlc_q = "UPDATE ".$config->tables['users'].
				" SET created=created,lastseen=CURRENT_TIMESTAMP WHERE id='".
				addslashes($this->user_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$sqlc_q.$this->db->error();
				return -1;
			}

			return 1;
		}

		return 0;
	}

	/**
	 * This function does change the karma table
	 *
	 * Warning: call to exit if DB is off
	 *
	 *@access public
	 *@param array $c array with the user_id
	 *@param string $type "+=" ou "=" 
	 */
	Function modify_karma($c,$type="=") {
		global $config;

		$sqlc_q = "SELECT user_id FROM ". $config->tables['karma_user'].
			" WHERE user_id='".addslashes($c['user_id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("It looks like admins are working on the server");
			exit;
		}

		if ($this->db->num_rows()>=1) {
			$sqlc_q = "UPDATE ".$config->tables['karma_user']." SET ";
			while (list ($a,$b) = each ($c)) {
				if ($a == "user_id") {
					continue;
				}
				$sqlc_q .= addslashes($a)."=";

				if ($type == "+=") {
					$sqlc_q .= addslashes($a)."+'".addslashes($b)."'";
				} else {
					$sqlc_q .= "'".addslashes($b)."'";
				}

				if (next($c)) {
					$sqlc_q .= ",";
					prev($c);
				}
			}

			$sqlc_q .= " WHERE user_id='".addslashes($c['user_id'])."'";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("It looks like admins are working on the server");
				exit;
			}
		} else {
			$sqlc_q = "INSERT INTO ".$config->tables['karma_user'].
				" (vote_nb,vote_nb_orig,experience,user_id) VALUES ".
				"('0','0','0','".addslashes($c['user_id'])."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("It looks like admins are working on the server");
				exit;
			}
		}

	}

	/**
	 * Returns the relative url for the news based on the session
	 *
	 *@access public
	 *@param integer $id the id of the news
	 *@param string $section the section of the news, 0 for none
	 *@param string $topic the topic of the news, 0 for none
	 *@param integer $yea the year of the news's date
	 *@param integer $mon the month of the news's date
	 *@param integer $day the day of the news's date
	 *@param integer $score the score for the comments
	 *@param boolean $absolute absolute url if true, relative if false.
	 *@param boolean $generic true if the URL is to be generic, 0 if it is for the current users's set of preferences
	 *@return string the url of the news
	 */
	Function newsurls ($id,$section,$topic,$yea,$mon,$day,$score=-2,$absolute=true, $generic = false) {
		global $config;
		$this->utils->debug ("Generic : $generic\n");
		if ($generic) {
			$this->utils->debug( "Aqui");
			$ext = ',' . $config->dft_prefs["theme"] . ',0.' . $config->php;
			$score = $config->dft_prefs['score'];
			$hide_sig = $config->dft_prefs['hide_sig'];
		} else {
			$ext = $config->ext;
			$hide_sig = $config->hide_sig;
		}
		$this->utils->debug("Session:".__LINE__." newsurls: score='".
			$score."'\n");
		if ($score == -2) {
			$score = $config->score;
		}
		if ($absolute == 1) {
			$tmp = $config->baseurl;
		} else {
			$tmp = $config->basehref;
		}
		if ($config->visiblenewsfile)
			$tmp .= $config->newsfile . "/";
		if (!empty($section)) {
			$tmp .= "section/".urlencode($section).
				(empty($id) ? '' : '/'.$id).
				','.$hide_sig.','.$score. $ext;
		} elseif (!empty($topic)) {
			$tmp .= "topic/".urlencode($topic).
				(empty($id) ? '' : '/'.$id).
				','.$hide_sig.','.$score. $ext;
		} else {
			$this->utils->debug("Session: " . __LINE__ . " hide_sig: $hide_sig; ext $ext\n");
			$tmp .= "$yea/$mon/$day/".(empty($id) ? 'index' : $id).
				','.$hide_sig.','.$score. $ext;
		}
		$this->utils->debug("Session:".__LINE__." newsurls: tmp='".$tmp."'\n");
		return $tmp;
	}

	/**
	 * Return an url of a themable file
	 *
	 *@access public
	 *@param string the file name.
	 *@return string the url 
	 */
	Function href_theme ($file) {
		global $config;

		$themefile = "themes/".$config->theme_name."/".$file;
		$theme_contrib_file = "themes/".$config->theme_subdir.
			$config->theme_name."/".$file;
		$tmp = $config->basehref.
			(file_exists($config->topdir.$themefile) ?
				$themefile :
				(file_exists($config->topdir.$theme_contrib_file) ?
					$theme_contrib_file : $file));
		return $tmp;
	}

	/**
	 *  Return images URL depending on current theme
	 * Name of the file is name.format
	 *
	 *@access public
	 *@param string the file name
	 *@param string the format (extension) of the file. Default (png) should be kept whenever possible
	 *@return string the url
	 */
	Function imgurl ($name,$format="png") {
		return $this->href_theme("images/".$name.".".$format);
	}

}

?>
