/*  
 * Copyright (C) 2004 Tony Sin(x) '76 <tony@becrux.com>
 *  All rights reserved.
 *
 */

/*
 *			 GNU GENERAL PUBLIC LICENSE
 *			    Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
  #ifndef __main_config_h__
    #define __main_config_h__
    #include "../config.h"
  #endif

  #include <pthread.h>
  #include <unistd.h>
  #include <syslog.h>
  #include <stdlib.h>
#endif

#include "clam.h"
#include "courier.h"
#include "log.h"

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t connected = PTHREAD_COND_INITIALIZER;
cCourierClient *cour_client;
cClamClient *clam_client;

void *inspector(void *arg)
{
  int my_sock = *((int *) arg);
  pthread_setcancelstate(PTHREAD_CANCEL_DISABLE,NULL);

  pthread_mutex_lock(&mutex);
  pthread_cond_signal(&connected);
  pthread_mutex_unlock(&mutex);

  putenv(CLAM_TMP_VAR);
  clam_client->TestInfection(my_sock);  

  return NULL;
}

void *listener(void *arg)
{
  pthread_attr_t thattr;
  pthread_t msg_thread;
  int msg_sock;
  cLog *sys_log;

  pthread_attr_init(&thattr);
  pthread_attr_setdetachstate(&thattr,PTHREAD_CREATE_DETACHED);

  sys_log = new cLog("Listener");
  putenv(CLAM_TMP_VAR);

  close(3);

  sys_log->WriteLog("ClamCour filter active");

  while ((msg_sock = cour_client->WaitForMail()) > 0)
  {
    sys_log->WriteLog("Launched Inspector for scan");
  
    pthread_mutex_lock(&mutex);
    pthread_create(&msg_thread,&thattr,inspector,(void *) &msg_sock);
    pthread_cond_wait(&connected,&mutex);
    pthread_mutex_unlock(&mutex);
  }

  sys_log->WriteLog("ClamCour filter shutdown");
  delete sys_log;

  return NULL;
}
  
int main()
{
  pthread_t thread;
  pthread_attr_t thattr;
  char c;
  cLog *sys_log;

  putenv(CLAM_TMP_VAR);

  openlog(PACKAGE_NAME,LOG_PID,LOG_MAIL);

  sys_log = new cLog();

  cour_client = new cCourierClient;
  sys_log->WriteLog("Courier socket initialized");
  clam_client = new cClamClient;
  if (!clam_client->InitVirDB())
    sys_log->WriteLog(clam_client->GetErrStr());
  else
    sys_log->WriteLog("ClamAV database loaded");

  pthread_attr_init(&thattr);
  pthread_attr_setdetachstate(&thattr,PTHREAD_CREATE_DETACHED);

  pthread_create(&thread,&thattr,listener,NULL);

  read(0,&c,sizeof(c));

  delete clam_client;
  delete cour_client;

  sys_log->WriteLog("Terminated");

  delete sys_log;

  closelog();

  return 0;
}
