/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_sample_display.h  -  description
                             -------------------
    begin                : Fri Jul 5 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_SAMPLE_DISPLAY_H
#define INTERFACE_WIDGET_SAMPLE_DISPLAY_H


#include <gtkmm/drawingarea.h>
#include <gtkmm/style.h>
#include "typedefs.h"


#include "sample_editor.h"
#include "components/audio/sample_data.h"
/**
  *@author Juan Linietsky
  */

class Widget_Sample_Display : public Gtk::DrawingArea {
	
	enum Colormap {

                Col_SampleData,
		Col_LoopPoint,
		Col_LoopPointSample,
                Max_Colors
        };
       	void init_colors();
	static int color_values[];

        Gdk::Color colors[Max_Colors];
        Glib::RefPtr<Gdk::GC> GC[Max_Colors];
        

	void allocate_colormap ();

	Sample_Data *sample_data;
public: 

	void set_sample_data(Sample_Data *p_sample_data);
	Widget_Sample_Display();
	~Widget_Sample_Display();
};
  #endif
