/* $Id: LuaScript.h,v 1.6 2003/03/22 23:51:49 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef LUA_SCRIPT_H
#define LUA_SCRIPT_H

#include <Modules/Lua/ArkLua.h>

#include <Engine/Script.h>
#include <Engine/Script.h>
#include <Engine/Entity.h>
#include <Engine/Engine.h>


#include <Modules/Lua/LuaEntity.h>
#include <Modules/Lua/luna.h>

namespace Ark
{
   class ARKLUA_DLL_API LuaScript : public Script
   {
      public:
	 LuaScript ();
	 virtual ~LuaScript ();

	 virtual bool LoadLibrary (const String &file);
	 virtual bool LoadScript (const String &file);
	 virtual bool NextFrame ();
	 virtual bool Main ();

	 virtual EngineEntity *NewEntity ();
   };

   class ARKLUA_DLL_API LuaEngine : public LunaObject
   {
      public:
	 static const char className[];
	 static const Luna<LuaEngine>::RegType Register[];

      public:
	 LuaEngine(lua_State *L);
	 ~LuaEngine();

	 /// Name, short name, identifier
	 int require (lua_State *L);
	 int version (lua_State *L);
	 int get_env (lua_State *L);
   };

} // namespace Ark

#include <Ark/ArkFactoryDef.h>
ARK_REGISTER_DEF(ARKLUA_DLL_API);


#endif // LUA_SCRIPT_H
