/*
 * $Id: cc.wrapper.c 491 2005-03-20 18:53:21Z acid $
 * gcc.wrapper - Wrapper for gcc used for apt-build
 * (c) 2004 - Julien Danjou <acid@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 */


#include "apt-build.h"
#include "config.h"

#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


int
gcc_real(char **argv)
{
  char *s;
  
  s = strdup(basename(argv[0]));
  
  /* Compare the end */
  s += strlen(basename(argv[0])) - 2;

  if(!strncmp(s, "cc", 2))
	return execv(GCC_PATH, argv);

  if(!strncmp(s, "++", 2))
	return execv(GPP_PATH, argv);

  fprintf(stderr, "Unable to guess the compiler you want\n");
  return -1;
}

int
gcc_apt_build(int argc, char **argv)
{
  return gcc_real(parse_conf(argc, argv));
}

int
main(int argc, char **argv)
{
  if(getenv(APT_BUILD_STRING_ENV))
	return gcc_apt_build(argc, argv);

  return gcc_real(argv);
}
