// ---------------------------------------------------------------------------
// - t_cnet.cpp                                                              -
// - standard platform library - network function tester                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cnet.hpp"
#include "cstr.hpp"

int main (int, char**) {
  using namespace aleph;

  // get the loopback name
  const char* lname = c_loopname ();
  if (lname == nilp) return 1;

  // resolve it
  t_byte* addr = c_ipaddr (lname);
  if (addr == nilp) return 1;

  // convert back the ip address to a string
  char* ipname = c_iprepr (addr);
  if (ipname == nilp) return 1;
  if ((long) (addr[0]) == 4)
    if (c_strcmp (ipname, "127.0.0.1") == false) return 1;
  else if ((long) (addr[0]) == 16)
    if (c_strcmp (ipname, "0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:1") == false) 
      return 1;
    else
      return 1;

  // clean and exit
  delete [] addr;
  return 0;
}
