/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.*;
import java.io.*;
import java.math.*;
import java.util.*;
import java.net.*;

public class ClientPreparedStatementSapDB
    implements PreparedStatement
{
    PreparedStatement originalPreparedStatement;
    ClientConnectionSapDB clientConnection;
    
    public ClientPreparedStatementSapDB(PreparedStatement originalPreparedStatement,
                                        ClientConnectionSapDB clientConnection)
    {
        this.originalPreparedStatement=originalPreparedStatement;
        this.clientConnection=clientConnection;
    }

    public void exceptionOccured(SQLException sqlEx) 
    {
        clientConnection.exceptionOccurred(sqlEx);
    }

    // Code for delegation of java.sql.Statement methods to originalPreparedStatement

    public void close() throws SQLException
    {
        try {
            originalPreparedStatement.close();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, int param2) throws SQLException
    {
        try {
            return originalPreparedStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, String[] param2) throws SQLException
    {
        try {
            return originalPreparedStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1) throws SQLException
    {
        try {
            return originalPreparedStatement.execute(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, int[] param2) throws SQLException
    {
        try {
            return originalPreparedStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public Connection getConnection() throws SQLException
    {
        try {
            return originalPreparedStatement.getConnection();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public SQLWarning getWarnings() throws SQLException
    {
        try {
            return originalPreparedStatement.getWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void clearWarnings() throws SQLException
    {
        try {
            originalPreparedStatement.clearWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet executeQuery(String param1) throws SQLException
    {
        try {
            ResultSet tmp=originalPreparedStatement.executeQuery(param1);
            return tmp==null ? null : new ClientResultSetSapDB(tmp, clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, String[] param2) throws SQLException
    {
        try {
            return originalPreparedStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1) throws SQLException
    {
        try {
            return originalPreparedStatement.executeUpdate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, int[] param2) throws SQLException
    {
        try {
            return originalPreparedStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, int param2) throws SQLException
    {
        try {
            return originalPreparedStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxFieldSize() throws SQLException
    {
        try {
            return originalPreparedStatement.getMaxFieldSize();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setMaxFieldSize(int param1) throws SQLException
    {
        try {
            originalPreparedStatement.setMaxFieldSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxRows() throws SQLException
    {
        try {
            return originalPreparedStatement.getMaxRows();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setMaxRows(int param1) throws SQLException
    {
        try {
            originalPreparedStatement.setMaxRows(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setEscapeProcessing(boolean param1) throws SQLException
    {
        try {
            originalPreparedStatement.setEscapeProcessing(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getQueryTimeout() throws SQLException
    {
        try {
            return originalPreparedStatement.getQueryTimeout();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setQueryTimeout(int param1) throws SQLException
    {
        try {
            originalPreparedStatement.setQueryTimeout(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void cancel() throws SQLException
    {
        try {
            originalPreparedStatement.cancel();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setCursorName(String param1) throws SQLException
    {
        try {
            originalPreparedStatement.setCursorName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getResultSet() throws SQLException
    {
        try {
            ResultSet tmp = originalPreparedStatement.getResultSet();
            return tmp==null ? null : new ClientResultSetSapDB(tmp, clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getUpdateCount() throws SQLException
    {
        try {
            return originalPreparedStatement.getUpdateCount();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getMoreResults(int param1) throws SQLException
    {
        try {
            return originalPreparedStatement.getMoreResults(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getMoreResults() throws SQLException
    {
        try {
            return originalPreparedStatement.getMoreResults();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchDirection(int param1) throws SQLException
    {
        try {
            originalPreparedStatement.setFetchDirection(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchDirection() throws SQLException
    {
        try {
            return originalPreparedStatement.getFetchDirection();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchSize(int param1) throws SQLException
    {
        try {
            originalPreparedStatement.setFetchSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchSize() throws SQLException
    {
        try {
            return originalPreparedStatement.getFetchSize();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetConcurrency() throws SQLException
    {
        try {
            return originalPreparedStatement.getResultSetConcurrency();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetType() throws SQLException
    {
        try {
            return originalPreparedStatement.getResultSetType();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void addBatch(String param1) throws SQLException
    {
        try {
            originalPreparedStatement.addBatch(param1);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void clearBatch() throws SQLException
    {
        try {
            originalPreparedStatement.clearBatch();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int[] executeBatch() throws SQLException
    {
        try {
            return originalPreparedStatement.executeBatch();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException
    {
        try {
            ResultSet tmp = originalPreparedStatement.getGeneratedKeys();
            return tmp==null ? null : new ClientResultSetSapDB(tmp, this.clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetHoldability() throws SQLException
    {
        try {
            return originalPreparedStatement.getResultSetHoldability();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    // Code for delegation of java.sql.PreparedStatement methods to originalPreparedStatement

    public void setBoolean(int param1, boolean param2) throws SQLException
    {
        try {
            originalPreparedStatement.setBoolean(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setByte(int param1, byte param2) throws SQLException
    {
        try {
            originalPreparedStatement.setByte(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setShort(int param1, short param2) throws SQLException
    {
        try {
            originalPreparedStatement.setShort(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setInt(int param1, int param2) throws SQLException
    {
        try {
            originalPreparedStatement.setInt(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setLong(int param1, long param2) throws SQLException
    {
        try {
            originalPreparedStatement.setLong(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setFloat(int param1, float param2) throws SQLException
    {
        try {
            originalPreparedStatement.setFloat(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setDouble(int param1, double param2) throws SQLException
    {
        try {
            originalPreparedStatement.setDouble(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setURL(int param1, URL param2) throws SQLException
    {
        try {
            originalPreparedStatement.setURL(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setTime(int param1, Time param2) throws SQLException
    {
        try {
            originalPreparedStatement.setTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setTime(int param1, Time param2, Calendar param3) throws SQLException
    {
        try {
            originalPreparedStatement.setTime(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute() throws SQLException
    {
        try {
            return originalPreparedStatement.execute();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException
    {
        try {
            return originalPreparedStatement.getMetaData();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet executeQuery() throws SQLException
    {
        try {
            ResultSet tmp = originalPreparedStatement.executeQuery();
            return tmp==null ? null : new ClientResultSetSapDB(tmp, this.clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate() throws SQLException
    {
        try {
            return originalPreparedStatement.executeUpdate();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void addBatch() throws SQLException
    {
        try {
            originalPreparedStatement.addBatch();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setNull(int param1, int param2, String param3) throws SQLException
    {
        try {
            originalPreparedStatement.setNull(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setNull(int param1, int param2) throws SQLException
    {
        try {
            originalPreparedStatement.setNull(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setBigDecimal(int param1, BigDecimal param2) throws SQLException
    {
        try {
            originalPreparedStatement.setBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setString(int param1, String param2) throws SQLException
    {
        try {
            originalPreparedStatement.setString(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setBytes(int param1, byte[] param2) throws SQLException
    {
        try {
            originalPreparedStatement.setBytes(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setDate(int param1, java.sql.Date param2) throws SQLException
    {
        try {
            originalPreparedStatement.setDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setDate(int param1, java.sql.Date param2, Calendar param3) throws SQLException
    {
        try {
            originalPreparedStatement.setDate(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setTimestamp(int param1, Timestamp param2) throws SQLException
    {
        try {
            originalPreparedStatement.setTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setTimestamp(int param1, Timestamp param2, Calendar param3) throws SQLException
    {
        try {
            originalPreparedStatement.setTimestamp(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setAsciiStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalPreparedStatement.setAsciiStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setUnicodeStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalPreparedStatement.setUnicodeStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setBinaryStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalPreparedStatement.setBinaryStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void clearParameters() throws SQLException
    {
        try {
            originalPreparedStatement.clearParameters();
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(int param1, Object param2) throws SQLException
    {
        try {
            originalPreparedStatement.setObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(int param1, Object param2, int param3) throws SQLException
    {
        try {
            originalPreparedStatement.setObject(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(int param1, Object param2, int param3, int param4) throws SQLException
    {
        try {
            originalPreparedStatement.setObject(param1, param2, param3, param4);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setCharacterStream(int param1, Reader param2, int param3) throws SQLException
    {
        try {
            originalPreparedStatement.setCharacterStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setRef(int param1, Ref param2) throws SQLException
    {
        try {
            originalPreparedStatement.setRef(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setBlob(int param1, Blob param2) throws SQLException
    {
        try {
            originalPreparedStatement.setBlob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setClob(int param1, Clob param2) throws SQLException
    {
        try {
            originalPreparedStatement.setClob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public void setArray(int param1, Array param2) throws SQLException
    {
        try {
            originalPreparedStatement.setArray(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException
    {
        try {
            ParameterMetaData pm = originalPreparedStatement.getParameterMetaData();
            return pm == null ? null : ClientParameterMetaDataSapDB.createNew(pm, clientConnection);
        } catch(SQLException sqlEx) {
            exceptionOccured(sqlEx);
            throw sqlEx;
        }
    }

}
