/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.ValueOverflow;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.DataType;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

class DateTranslator
extends CharDataTranslator {
    public static final String zeroPadC = "0000";
    private static final int DateSize_C = 10;

    protected DateTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
        }
        return string;
    }

    public Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Date date = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            int n = (byArray[0] - 48) * 1000;
            n += (byArray[1] - 48) * 100;
            n += (byArray[2] - 48) * 10;
            n += byArray[3] - 48;
            int n2 = (byArray[5] - 48) * 10;
            n2 += byArray[6] - 48;
            int n3 = (byArray[8] - 48) * 10;
            n3 += byArray[9] - 48;
            if (calendar == null) {
                date = new Date(n - 1900, n2 - 1, n3);
            } else {
                calendar.clear();
                calendar.set(n, n2 - 1, n3, 0, 0, 0);
                date = DBTechTranslator.CalendarUtil.getDateFromCalendar(calendar);
            }
        }
        return date;
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getDate(sQLParamController, structuredMem, null);
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Date date = this.getDate(sQLParamController, structuredMem, calendar);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transDateForInput(Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        byte[] byArray = new byte[10];
        int n = calendar.get(1);
        if (n < 0 || n > 9999) {
            throw this.newParseException(date.toString(), "Date");
        }
        byArray[0] = (byte)(48 + n / 1000);
        byArray[1] = (byte)(48 + (n %= 1000) / 100);
        byArray[2] = (byte)(48 + (n %= 100) / 10);
        byArray[3] = (byte)(48 + (n %= 10));
        byArray[4] = 45;
        n = calendar.get(2) + 1;
        byArray[5] = CharDataTranslator.HighTime_C[n];
        byArray[6] = CharDataTranslator.LowTime_C[n];
        byArray[7] = 45;
        n = calendar.get(5);
        byArray[8] = CharDataTranslator.HighTime_C[n];
        byArray[9] = CharDataTranslator.LowTime_C[n];
        return byArray;
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        byte[] byArray = (byte[])object;
        if (byArray.length > this.physicalLength - 1) {
            throw new ValueOverflow(DataType.stringValuesC[this.dataType], -1);
        }
        dataPart.putInt1(32, this.bufpos - 1);
        dataPart.putStringBytes(byArray, this.bufpos, this.physicalLength - 1);
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof Date) {
            object2 = this.transDateForInput((Date)object, Calendar.getInstance());
        }
        return object2;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return this.transDateForInput(Date.valueOf(string), Calendar.getInstance());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                return this.transDateForInput(new Date(timestamp.getTime()), Calendar.getInstance());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Date");
            }
        }
    }
}

