/*
	reverse.c - animate reverse

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static XColor rvcolors[256];
static long dr[256],dg[256],db[256];
static int mapsize;

static void ReverseColors()
{
int i,j;

	j=mapsize;

	for(i = 0; i < j; i++){
		rvcolors[i].red	  = 0xffffffff - xcolors[i].red;
		rvcolors[i].green = 0xffffffff - xcolors[i].green;
		rvcolors[i].blue  = 0xffffffff - xcolors[i].blue;
		rvcolors[i].flags = xcolors[i].flags;
		rvcolors[i].pixel = xcolors[i].pixel;
		dr[i] = (long)(xcolors[i].red	- rvcolors[i].red  );
		dg[i] = (long)(xcolors[i].green - rvcolors[i].green);
		db[i] = (long)(xcolors[i].blue	- rvcolors[i].blue );
	}
}

#if defined(__STDC__) || defined(__cplusplus)
static void AnimateReverse(int mode)
#else
static void AnimateReverse(mode)
int mode;
#endif
{
int i,j,k;

	k = mapsize;

	if(mode){

		for(j = 255; j > 0; j -= app_data.reverseSteps){

			for(i = 0; i < k; i++){
				fcolors[i].red	=(word)((int)rvcolors[i].red   + dr[i] * j / 255);
				fcolors[i].green=(word)((int)rvcolors[i].green + dg[i] * j / 255);
				fcolors[i].blue =(word)((int)rvcolors[i].blue  + db[i] * j / 255);
				fcolors[i].flags=rvcolors[i].flags;
				fcolors[i].pixel=rvcolors[i].pixel;
			}

			StoreColors(fcolors,mapsize);
			myusleep(app_data.reverseTicks);
			if(gotSomeAction == True)
				return;
		}

	}

	else{

		for(j = 1; j < 256; j += app_data.reverseSteps){

			for(i = 0; i < k; i++){
				fcolors[i].red	=(word)((short)rvcolors[i].red	 + dr[i] * j / 255);
				fcolors[i].green=(word)((short)rvcolors[i].green + dg[i] * j / 255);
				fcolors[i].blue =(word)((short)rvcolors[i].blue	 + db[i] * j / 255);
				fcolors[i].flags=rvcolors[i].flags;
				fcolors[i].pixel=rvcolors[i].pixel;
			}

			StoreColors(fcolors,mapsize);
			myusleep(app_data.reverseTicks);
			if(gotSomeAction == True)
				return;
		}

	}

}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xreverseshow(char *fname)	/* Animate reverse colors */
#else
ActionStatus xreverseshow(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();
	ReverseColors();

	if(app_data.showFileName)
		createFileNameWindow(fname);

	ShowImage(	(windowWidth - gim.subImageList->width) / 2,
				(windowHeight - gim.subImageList->height) / 2,
				gim.subImageList->width, gim.subImageList->height);

	PreFadeColors(mapsize);
	FadeColors(False, mapsize);
	StoreColors(xcolors,mapsize);

	if(app_data.showFileName)
		raiseFileNameWindow();

	AnimateReverse(True);

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxreverseshow(char *fname)	/* Animate reverse colors */
#else
void postxreverseshow(fname)
char *fname;
#endif
{
	AnimateReverse(False);

	if(app_data.showFileName)
		removeFileNameWindow();

	FadeColors(True, mapsize);
}

