/*
 * mtrev24.c   Adachi, J.   1996.03.01
 * Copyright (C) 1996 J. Adachi & M. Hasegawa. All rights reserved.
 */

#include "protml.h"

void 
mtrev(r, f) /* Data of Amino Acid Substitution Model */
	dmattpmty r;    /* Relative Substitution Rate Matrix */
	double *f;      /* Frequency */
{
	int i, j;

	/*
	 * mtREV(24) model data.
	 * complete sequence data of mtDNA from 24 vertebrate species.
	 * Adachi, J. and Hasegawa, M. (1996)
	 * sum of lower triangular is 100000 and lower limit is 10.
	 */

	/* Relative Substitution Rate Matrix (lower triangular) */
	r[ 1][ 0]=1.2199217606346e+02;
	r[ 2][ 0]=1.4182139942122e+02; r[ 2][ 1]=6.9661274444534e+01;
	r[ 3][ 0]=9.2985091873208e+01; r[ 3][ 1]=1.0000000000000e+01;
	r[ 3][ 2]=4.1809325468160e+03;
	r[ 4][ 0]=3.1542792981957e+02; r[ 4][ 1]=5.4384584796568e+02;
	r[ 4][ 2]=3.1020979842967e+02; r[ 4][ 3]=1.0000000000000e+01;
	r[ 5][ 0]=1.0025852846688e+01; r[ 5][ 1]=1.1631134513343e+03;
	r[ 5][ 2]=9.1349622725361e+02; r[ 5][ 3]=2.9097352675564e+02;
	r[ 5][ 4]=3.9599394038972e+02;
	r[ 6][ 0]=5.1418866803338e+01; r[ 6][ 1]=1.0000000000000e+01;
	r[ 6][ 2]=3.3185663516310e+02; r[ 6][ 3]=3.0713149855302e+03;
	r[ 6][ 4]=1.0000000000000e+01; r[ 6][ 5]=1.6503249008836e+03;
	r[ 7][ 0]=6.3531246495131e+02; r[ 7][ 1]=1.2122831341194e+02;
	r[ 7][ 2]=2.8052324651124e+02; r[ 7][ 3]=2.9877072751897e+02;
	r[ 7][ 4]=1.6163581056674e+02; r[ 7][ 5]=3.5530760735494e+01;
	r[ 7][ 6]=1.4884496769963e+02;
	r[ 8][ 0]=7.3137132861715e+01; r[ 8][ 1]=8.6961067087353e+02;
	r[ 8][ 2]=2.6112087577885e+03; r[ 8][ 3]=5.9995408885817e+02;
	r[ 8][ 4]=7.4467985406234e+02; r[ 8][ 5]=3.0652523140859e+03;
	r[ 8][ 6]=2.5853576435567e+02; r[ 8][ 7]=1.0000000000000e+01;
	r[ 9][ 0]=5.0782382656186e+02; r[ 9][ 1]=1.0000000000000e+01;
	r[ 9][ 2]=1.4261453863336e+02; r[ 9][ 3]=2.2827096245105e+01;
	r[ 9][ 4]=3.3018175376623e+02; r[ 9][ 5]=4.3905393139325e+01;
	r[ 9][ 6]=1.7418201388328e+01; r[ 9][ 7]=3.1466649021550e+01;
	r[ 9][ 8]=6.4536986087271e+01;
	r[10][ 0]=1.3399741808481e+02; r[10][ 1]=8.1976829394538e+01;
	r[10][ 2]=7.9775653461977e+01; r[10][ 3]=1.0000000000000e+01;
	r[10][ 4]=1.3500725995091e+02; r[10][ 5]=2.0895470525345e+02;
	r[10][ 6]=1.0000000000000e+01; r[10][ 7]=1.2699794194865e+01;
	r[10][ 8]=6.0472584534958e+01; r[10][ 9]=1.7320653206333e+03;
	r[11][ 0]=4.4021672780560e+01; r[11][ 1]=7.4423215395318e+02;
	r[11][ 2]=3.2036829276162e+03; r[11][ 3]=1.2183938185384e+01;
	r[11][ 4]=1.0000000000000e+01; r[11][ 5]=2.4504076430724e+03;
	r[11][ 6]=1.6519126809071e+03; r[11][ 7]=1.1962111069278e+02;
	r[11][ 8]=6.7197196398961e+02; r[11][ 9]=1.0298655619743e+02;
	r[11][10]=7.8314019154706e+01;
	r[12][ 0]=7.4673480520104e+02; r[12][ 1]=1.0000000000000e+01;
	r[12][ 2]=3.4424354918739e+02; r[12][ 3]=1.0000000000000e+01;
	r[12][ 4]=3.2504095376923e+01; r[12][ 5]=2.4931300477797e+02;
	r[12][ 6]=1.0000000000000e+01; r[12][ 7]=1.0000000000000e+01;
	r[12][ 8]=6.2977633277779e+01; r[12][ 9]=2.7262244199514e+03;
	r[12][10]=2.8290920517725e+03; r[12][11]=4.8092094826036e+02;
	r[13][ 0]=3.3513021631978e+01; r[13][ 1]=2.4659158338099e+01;
	r[13][ 2]=7.9996445145608e+01; r[13][ 3]=2.6221929413096e+01;
	r[13][ 4]=3.7264767083096e+02; r[13][ 5]=1.0059428264289e+02;
	r[13][ 6]=1.4067850525292e+01; r[13][ 7]=1.0000000000000e+01;
	r[13][ 8]=2.5347805183364e+02; r[13][ 9]=4.4561065036310e+02;
	r[13][10]=1.1371735519833e+03; r[13][11]=3.3887559483420e+01;
	r[13][12]=4.7798798034572e+02;
	r[14][ 0]=2.8582502221773e+02; r[14][ 1]=1.2439947713615e+02;
	r[14][ 2]=3.8586541461044e+02; r[14][ 3]=7.0708004204733e+01;
	r[14][ 4]=1.6454136037822e+02; r[14][ 5]=7.2256314165467e+02;
	r[14][ 6]=6.7547121641947e+01; r[14][ 7]=1.0000000000000e+01;
	r[14][ 8]=3.2089868698728e+02; r[14][ 9]=1.0856482766156e+02;
	r[14][10]=2.1105885757279e+02; r[14][11]=2.6368577564199e+02;
	r[14][12]=9.9165053447429e+01; r[14][13]=9.1089574817139e+01;
	r[15][ 0]=2.0413623195312e+03; r[15][ 1]=3.1791814866372e+01;
	r[15][ 2]=2.6020426225852e+03; r[15][ 3]=3.6327934317139e+02;
	r[15][ 4]=1.4581783243113e+03; r[15][ 5]=2.8480937892158e+02;
	r[15][ 6]=2.8794794140840e+02; r[15][ 7]=6.6277950574411e+02;
	r[15][ 8]=4.0766987134407e+02; r[15][ 9]=2.5107659603898e+02;
	r[15][10]=3.8741359395934e+02; r[15][11]=5.5679895711418e+02;
	r[15][12]=5.8505442466161e+02; r[15][13]=3.3835737720574e+02;
	r[15][14]=8.9421193040709e+02;
	r[16][ 0]=2.5301305153906e+03; r[16][ 1]=1.0935327216119e+01;
	r[16][ 2]=1.2550758780474e+03; r[16][ 3]=1.4743408713748e+02;
	r[16][ 4]=9.4720031458442e+02; r[16][ 5]=4.9962974409828e+02;
	r[16][ 6]=7.8001372062558e+01; r[16][ 7]=5.8800079133028e+01;
	r[16][ 8]=2.3570850628539e+02; r[16][ 9]=1.9391167162525e+03;
	r[16][10]=6.6524559321657e+02; r[16][11]=7.1750284708933e+02;
	r[16][12]=2.7798190504760e+03; r[16][13]=1.7815549567056e+02;
	r[16][14]=6.7485067008375e+02; r[16][15]=3.1432036618746e+03;
	r[17][ 0]=1.0000000000000e+01; r[17][ 1]=1.1550775790126e+02;
	r[17][ 2]=5.6207759736659e+01; r[17][ 3]=1.0453246057102e+02;
	r[17][ 4]=1.7684087896962e+02; r[17][ 5]=1.0000000000000e+01;
	r[17][ 6]=1.0000000000000e+01; r[17][ 7]=5.7494182626674e+01;
	r[17][ 8]=3.7286635325194e+01; r[17][ 9]=1.0000000000000e+01;
	r[17][10]=1.7071378554833e+02; r[17][11]=1.2631893872825e+02;
	r[17][12]=1.1427000119701e+02; r[17][13]=4.1272404968214e+01;
	r[17][14]=2.2161693733113e+01; r[17][15]=2.0305343047059e+02;
	r[17][16]=5.2559565123081e+01;
	r[18][ 0]=3.4084158197615e+01; r[18][ 1]=1.0000000000000e+01;
	r[18][ 2]=1.0071406219571e+03; r[18][ 3]=1.1165627147496e+02;
	r[18][ 4]=1.3409157685926e+03; r[18][ 5]=2.0430790980529e+02;
	r[18][ 6]=6.9067239183061e+01; r[18][ 7]=1.6887657206208e+01;
	r[18][ 8]=3.5270764890474e+03; r[18][ 9]=1.3161329199391e+02;
	r[18][10]=2.3234516108847e+02; r[18][11]=2.6932728996777e+02;
	r[18][12]=2.1029990530586e+02; r[18][13]=2.4504156395152e+03;
	r[18][14]=8.5338209390745e+01; r[18][15]=3.4167877957799e+02;
	r[18][16]=2.0382362288681e+02; r[18][17]=1.3814733274637e+02;
	r[19][ 0]=1.0266468401249e+03; r[19][ 1]=4.0211417480338e+01;
	r[19][ 2]=1.0000000000000e+01; r[19][ 3]=1.0000000000000e+01;
	r[19][ 4]=1.0000000000000e+01; r[19][ 5]=9.9986289000676e+01;
	r[19][ 6]=1.1127702362585e+02; r[19][ 7]=1.3320553471351e+01;
	r[19][ 8]=1.0000000000000e+01; r[19][ 9]=6.4365086389428e+03;
	r[19][10]=4.8247261078055e+02; r[19][11]=1.0000000000000e+01;
	r[19][12]=2.0397078683768e+03; r[19][13]=3.3435675442163e+01;
	r[19][14]=4.3342126659660e+01; r[19][15]=1.0000000000000e+01;
	r[19][16]=1.0765527137500e+03; r[19][17]=2.8259139240676e+01;
	r[19][18]=1.0000000000000e+01; /* sum:  100000.088581 */

	/* Amino Acid Frequency */
	f[ 0]=0.072; f[ 1]=0.019; f[ 2]=0.039; f[ 3]=0.019; f[ 4]=0.006;
	f[ 5]=0.025; f[ 6]=0.024; f[ 7]=0.056; f[ 8]=0.028; f[ 9]=0.088;
	f[10]=0.168; f[11]=0.023; f[12]=0.054; f[13]=0.061; f[14]=0.054;
	f[15]=0.072; f[16]=0.086; f[17]=0.029; f[18]=0.033; f[19]=0.043;

	for (i = 1; i < 20; i++) {
		for (j = 0; j < i; j++) r[j][i] = r[i][j];
	}
	for (i = 0; i < 20; i++) r[i][i] = 0.0;

} /* mtrev */
