#
# Test ZAttachmentAttribute
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

# Permissions / security
##from Products.ZAttachmentAttribute.Permissions import MyDefinedPermission
from AccessControl.Permissions import access_contents_information, view, add_documents_images_and_files, change_images_and_files, view_management_screens
from AccessControl import Unauthorized

_standard_permissions = ZopeTestCase._standard_permissions
_access_permissions   = [view_management_screens,]                      # Access attachment attributes (this is a silly permissions, for test purposes only)
_edit_permissions     = _standard_permissions+_access_permissions+[change_images_and_files,]                      # Edit attachment attributes (silly permission as well)
_all_permissions      = _standard_permissions+_access_permissions+_edit_permissions


# Create a dummy product that will be a support for our tests and the create the initialize method
import Products.ZAAPloneDemo.AttachmentDemo
##import Products.ZAttachmentAttribute.__init__
##def dummy_initialize(context):
##    context.registerClass(
##        ZAAPloneDemo.ZAAPloneDemo,
##        permission=add_documents_images_and_files,
##        constructors=(ZAAPloneDemo.ZAAPloneDemo_add,),
##        visibility=None,
##        )

##Products.ZAttachmentAttribute.__init__.initialize = dummy_initialize


# Install product
ZopeTestCase.installProduct('ZAttachmentAttribute')


# Load particular product modules
import ZAttachmentAttribute
import ZAttachmentRegistry
import ZAbstractAttachment
from Products.ZAttachmentAttribute.global_symbols import *
from Products import ZAttachmentAttribute

class TestZAttachmentAttribute(ZopeTestCase.ZopeTestCase):

    def test_00_registry_overload(self,):
        """
        Registry machinery must work correctly, ensuring that a non-derived method will be catched
        """
        test_pass = 0
        class DummyAttribute(ZAbstractAttachment.ZAbstractAttachment):
            icon_file = "azerty"

        try:
            ZAttachmentRegistry.AttachmentRegistry.registerClass(DummyAttribute)
        except NotImplementedError:
            pass
        else:
            self.fail('Non-overloaded method not reported when registering a ZAbstractAttachment-derived attachment class')

        
    def AA(self,):
        """
        AA(self) => ZAAPloneDemo object
        get a sample ZAAPloneDemo object instanciated in ZODB
        """
        zaatest = self.folder.manage_addProduct['ZAAPloneDemo'].addAttachmentDemo('ZAAtest')
##        return self.folder.restrictedTraverse("toto")
        return self.folder.toto

    def test_01_registry_PDF(self,):
        """
        Ensure registry works for application/pdf type
        """
        self.AA()
        

    def test_02_AccessDenied(self,):
        """
        Should not access getIcon() with no permissions
        """
        zaatest = self.AA()
        self.setPermissions(_standard_permissions)
        try:
            zaatest.restrictedTraverse('myAttachment/getIcon')()
        except Unauthorized:
            pass
        except:
            raise
        else:
            self.fail('ZAttachmentAttribute.getIcon() has security hole (one can access it without having access_contents_information permission)')

        self.setPermissions(_access_permissions)
        try:
            zaatest.restrictedTraverse('myAttachment/uploadAttachment')()
        except Unauthorized:
            pass
        except:
            raise
        else:
            self.fail('Security hole !')

    def test_02_AccessDeniedBis(self,):
        """
        Should access getIcon() with edit permissions
        """
        zaatest = self.AA()
##        self.setPermissions(_edit_permissions)
        self.setPermissions(_standard_permissions)
        zaatest.restrictedTraverse('myAttachment')
        zaatest.restrictedTraverse('myAttachment/getIcon')
        zaatest.restrictedTraverse('myAttachment/uploadAttachment')

    def test_03_AccessUnderlying(self,):
        """
        Should not access __underlyingFile__ even with manager permission
        """
        zaatest = self.AA()
        self.setRoles(['Manager'])
        try:
            zaatest.restrictedTraverse('myAttachment/__underlyingFile__')
        except (Unauthorized, "NotFound"):
            pass
        except:
            raise
        else:
            self.fail('ZAttachmentAttribute.__underlyingFile__ has security hole (is accessible through Zope code !)')


    def uploadPDF(self, zaatest, filename):
        """
        uploadPDF(self, zaatest, filename) => upload a PDF file into the attribute
        """
        # Upload a PDF file containing the string "Consortium" for example
        self.setPermissions(_edit_permissions)
        pdf = open(filename, "rb")           # Sample [valid] PDF file
        zaatest.restrictedTraverse('myAttachment').uploadAttachment(ZAttachmentAttribute.PDFAttachment.PDFAttachment, pdf)
        pdf.close()
    

##    def test_04_UploadPDF(self,):
##        """
##        Manual upload of a PDF file
##        """
##        # Upload file
##        zaatest = self.AA()
##        self.uploadPDF(zaatest, 'ref.pdf')
        
##        # Test attachment file length
##        self.failUnless(zaatest.myAttachment.getFile(), "Attachment file is empty ! (ie. the uploaded file is not stored)")

##        # Test attachment file content
##        pdf = open('ref.pdf', 'rb')
##        self.failUnless(zaatest.myAttachment.getFile() == pdf.read(), "Stored attachment file is not correct (ie. not the same as uploaded file)")

##        # Check for an indexed value
##        self.failUnless(zaatest.myAttachment.listIndexableValues(), "Nothing has been indexed !")
        
##        # Check for "Consortium" in indexed value
##        self.failUnless("consortium" in zaatest.myAttachment.listIndexableValues(), "Indexed PDF file doesn't contain the 'Consortium' word as it should")


    def test_05_title(self,):
        """
        test title
        """
        zaatest = self.AA()
        zaatest.restrictedTraverse('myAttachment/setTitle')('Mon titre')
        self.failUnless(zaatest.restrictedTraverse('myAttachment/title_or_id')() == "Mon titre", "Incorrect title management")


##    def test_00_ItemPatched(self):
##        '''Item should have been patched'''
##        ob = getattr(self.app, 'aq_base', self.app)
##        self.failUnless(hasattr(ob, 'showDocumentation'))
##        self.failUnless(hasattr(ob, 'analyseDocumentation'))

##    def test_01_AccessAllowed(self):
##        'showDocumentation should be accessible'
##        self.setPermissions(_standard_permissions+_access_permissions)
##        try:
##            dummy = self.folder.restrictedTraverse('showDocumentation')
##        except Unauthorized:
##            self.fail('Access to showDocumentation was denied')
            
##    def test_02_AccessDenied(self):
##        'showDocumentation should be protected'
##        self.setPermissions(_standard_permissions)
##        try:
##            dummy = self.folder.restrictedTraverse('showDocumentation')
##        except Unauthorized:
##            pass
##        else:
##            self.fail('Access to showDocumentation was allowed')
            
##    def test_03_ManagerAccessAllowed(self):
##        'showDocumentation should be accessible to Managers'
##        self.setRoles(['Manager'])
##        try:
##            dummy = self.folder.restrictedTraverse('showDocumentation')
##        except Unauthorized:
##            self.fail('Access to showDocumentation was denied to Manager')
            
##    def test_04_ManagerAccessDenied(self):
##        'showDocumentation should be protected from Managers'
##        self.folder.manage_permission(ViewDocPermission, ['Owner'], acquire=0)
##        self.setRoles(['Manager'])
##        try:
##            dummy = self.folder.restrictedTraverse('showDocumentation')
##        except Unauthorized:
##            pass
##        else:
##            self.fail('Access to showDocumentation was allowed to Manager')
            
##    def test_05_AccessAllowed(self):
##        'analyseDocumentation should be accessible'
##        self.setPermissions(_standard_permissions+_access_permissions)
##        try:
##            dummy = self.folder.restrictedTraverse('analyseDocumentation')
##        except Unauthorized:
##            self.fail('Access to analyseDocumentation was denied')
            
##    def test_06_AccessDenied(self):
##        'analyseDocumentation should be protected'
##        self.setPermissions(_standard_permissions)
##        try:
##            dummy = self.folder.restrictedTraverse('analyseDocumentation')
##        except Unauthorized:
##            pass
##        else:
##            self.fail('Access to analyseDocumentation was allowed')
            
##    def test_07_ManagerAccessAllowed(self):
##        'analyseDocumentation should be accessible to Managers'
##        self.setRoles(['Manager'])
##        try:
##            dummy = self.folder.restrictedTraverse('analyseDocumentation')
##        except Unauthorized:
##            self.fail('Access to analyseDocumentation was denied to Manager')
            
##    def test_08_ManagerAccessDenied(self):
##        'analyseDocumentation should be protected from Managers'
##        self.folder.manage_permission(ViewDocPermission, ['Owner'], acquire=0)
##        self.setRoles(['Manager'])
##        try:
##            dummy = self.folder.restrictedTraverse('analyseDocumentation')
##        except Unauthorized:
##            pass
##        else:
##            self.fail('Access to analyseDocumentation was allowed to Manager')
            


if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
else:
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(TestZAttachmentAttribute))
        return suite

