##########################################################
##                                                      ##
## INSTALL PROCEDURE FOR CMF/PLONE TYPES                ##
##                                                      ##
## This can be shared across IW products ! :-)          ##
## Just edit the tagged lines (## EDIT)                 ##
##                                                      ##
##########################################################


# EDIT FROM HERE...
from Products.ZAAPlugins.global_symbols import *
# ...TO HERE

from Products.CMFCore.TypesTool import ContentFactoryMetadata
from Products.CMFCore.DirectoryView import addDirectoryViews
from Products.CMFCore.utils import getToolByName

from AccessControl.Permission import pname
import Globals

from cStringIO import StringIO
import string


# EDIT FROM HERE...
fti_list = (
    )
types_list = (
    )
skin_name = "ZAAPlugins"
# ...TO HERE


def installSubSkin(self, out, skinFolder):
    """ Install a subskin, i.e. a folder/directoryview.
    """
    skinsTool = getToolByName(self, 'portal_skins')

    for skin in skinsTool.getSkinSelections():
        path = skinsTool.getSkinPath(skin)
        path = map( string.strip, string.split( path,',' ) )
        if not skinFolder in path:
            try:
                path.insert( path.index( 'custom')+1, skinFolder )
            except ValueError:
                path.append(skinFolder)
            path = string.join( path, ', ' )
            skinsTool.addSkinSelection( skin, path )
            out.write('Subskin successfully installed into %s.\n' % skin)    
        else:
            out.write('*** Subskin was already installed into %s.\n' % skin) 


def setupTypesandSkins(self, out):
    typesTool = getToolByName(self, 'portal_types')
    skinsTool = getToolByName(self, 'portal_skins')
    
    # Former types deletion (added by PJG)
    for f in fti_list:
        if f['id'] in typesTool.objectIds():
            out.write('*** Object "%s" already existed in the types tool => deleting\n' % (f['id']))
            
            typesTool._delObject(f['id'])

    # Type re-creation
    for f in fti_list:
        cfm = apply(ContentFactoryMetadata, (), f)
        typesTool._setObject(f['id'], cfm)
        out.write('Type "%s" registered with the types tool\n' % (f['id']))

        
    # Install de chaque nouvelle subskin/layer
    try:  
        addDirectoryViews(skinsTool, 'skins', install_globals)
        out.write( "Added directory views to portal_skins.\n" )
    except:
        out.write( '*** Unable to add directory views to portal_skins.\n')

    # Param de chaque nouvelle subskin/layer
    installSubSkin(self, out, skin_name)

    
def addNavigationTransitions(self):
    portal_prop = getToolByName(self, 'portal_properties')
    form = portal_prop.form_properties
    nav = portal_prop.navigation_properties

    for ctype in types_list:
        lowertype = ctype.lower()

        # The mapping var provides a way to make properties creation / updating easier
        mapping = [
            ('%s_editForm' % (ctype), 'validate_id,validate_%s_edit' % (ctype), ),
            ('%s_attachmentForm' % (ctype,), 'validate_%s_attachment' % (ctype, ), )
            ]
        
        for (name, value) in mapping:
            try:
                form._setProperty(name, value, 'string')
            except:
                form._updateProperty(name, value)

        mapping = [
            ('%s.%s_editForm.success' % (lowertype, ctype ), 'script:%s_edit' % (ctype), ),
            ('%s.%s_editForm.failure' % (lowertype, ctype ), '%s_editForm' % (ctype), ),
            ('%s.%s_edit.success' % (lowertype, ctype ), 'action:view', ),
            ('%s.%s_edit.failure' % (lowertype, ctype ), 'action:edit', ),
            ('%s.%s_attachmentForm.success' % (lowertype, ctype ), 'script:%s_editAttachment' % (ctype), ),             # Attachment-related forms
            ('%s.%s_attachmentForm.failure' % (lowertype, ctype ), '%s_attachmentForm' % (ctype), ),
            ('%s.%s_editAttachment.success' % (lowertype, ctype ), 'action:view', ),
            ('%s.%s_editAttachment.failure' % (lowertype, ctype ), 'action:attachment', ),
            ]

        for (name, value) in mapping:
            try:
                nav._setProperty(name, value, 'string')
            except:
                nav._updateProperty(name, value)



def setPermissions(self, out):
    """
    setPermissions(self, out) => Set standard permissions / roles
    """
    return
##    p = self

##    # As a default behavior, newly-created permissions are granted to owner and manager.
##    # To change this, just comment this code and grab back the code commented below to
##    # make it suit your needs.
##    for perm in perms_list:
##        p.manage_permission(
##            perm,
##            ('Manager', 'Owner'),
##            acquire = 1
##            )

##    # EDIT FROM HERE...
##    p.manage_permission(
##        MinimalFolderishType_editPermission,
##        ('Manager', 'Owner',),
##        acquire=1
##        )
##    p.manage_permission(
##        MinimalFolderishType_addPermission,
##        ('Manager', 'Owner',),
##        acquire=1
##        )
##    # ...TO HERE
    out.write("Reseted default permissions\n")
                

def install(self):
    out=StringIO()
    setPermissions(self, out)
    setupTypesandSkins(self, out)
    addNavigationTransitions(self)
    out.write('Installation completed.\n')
    return out.getvalue()

