/*
 * chown.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"
#include "zlibc.h"


int chown(__const char *file_name, uid_t owner, gid_t group)
{
  int st;
  char newname[MAXPATHLEN + MAXEXTLEN + 1];

  st = zlib_real_chown(file_name, owner, group);

  if ( st >= 0 || errno != ENOENT )
    return st;

  zlib_initialise();
  if ( zlib_mode & CM_DISAB )
    return st;
  if ( (zlib_getfiletype(file_name,-1) & PM_READ_MASK) == PM_LEAVE_COMPR)
    return st;
  
  if ( zlib_mode & CM_VERBOSE )
    fprintf(stderr,"Chowning %s\n",file_name);

  strncpy(newname,file_name,1024);
  strcat(newname,zlib_ext);
  
  errno = 0;
  return zlib_real_chown(newname, owner, group);
}
