% -*- LaTeX -*-
% $Id: Eval.lhs,v 1.4 2004/08/08 12:05:32 berrueta Exp $
%
% Copyright (c) 2001-2003, Wolfgang Lux
% See LICENSE for the full license.
%
\nwfilename{Eval.lhs}
\codesection{Checking evaluation annotations}
The module \texttt{Eval} computes the evaluation annotation
environment. There is no need to check the annotations because this
happens already while checking the definitions of the module.
\begin{lstlisting}

> module Eval(evalEnv,evalEnvGoal) where
> import CurrySyntax
> import EvalEnv
> import Env

\end{lstlisting}
The function \texttt{evalEnv} collects all evaluation annotations of
the module by traversing the syntax tree.
\begin{lstlisting}

> evalEnv :: [Decl] -> EvalEnv
> evalEnv = foldr collectAnnotsDecl emptyEnv

> evalEnvGoal :: Goal -> EvalEnv
> evalEnvGoal (Goal _ e ds) =
>   collectAnnotsExpr e (foldr collectAnnotsDecl emptyEnv ds)

> collectAnnotsDecl :: Decl -> EvalEnv -> EvalEnv
> collectAnnotsDecl (EvalAnnot _ fs ev) = flip (foldr (flip bindEval ev)) fs
> collectAnnotsDecl (FunctionDecl _ _ eqs) = flip (foldr collectAnnotsEqn) eqs
> collectAnnotsDecl (PatternDecl _ _ rhs) = collectAnnotsRhs rhs
> collectAnnotsDecl d = id

> collectAnnotsEqn :: Equation -> EvalEnv -> EvalEnv
> collectAnnotsEqn (Equation _ _ rhs) = collectAnnotsRhs rhs

> collectAnnotsRhs :: Rhs -> EvalEnv -> EvalEnv
> collectAnnotsRhs (SimpleRhs _ e ds) =
>   collectAnnotsExpr e . flip (foldr collectAnnotsDecl) ds
> collectAnnotsRhs (GuardedRhs es ds) =
>   flip (foldr collectAnnotsCondExpr) es . flip (foldr collectAnnotsDecl) ds

> collectAnnotsCondExpr :: CondExpr -> EvalEnv -> EvalEnv
> collectAnnotsCondExpr (CondExpr _ g e) =
>   collectAnnotsExpr g . collectAnnotsExpr e

> collectAnnotsExpr :: Expression -> EvalEnv -> EvalEnv
> collectAnnotsExpr (Literal _) = id
> collectAnnotsExpr (Variable _) = id
> collectAnnotsExpr (Constructor _) = id
> collectAnnotsExpr (Paren e) = collectAnnotsExpr e
> collectAnnotsExpr (Typed e _) = collectAnnotsExpr e
> collectAnnotsExpr (Tuple es) = flip (foldr collectAnnotsExpr) es
> collectAnnotsExpr (List es) = flip (foldr collectAnnotsExpr) es
> collectAnnotsExpr (ListCompr e qs) =
>   collectAnnotsExpr e . flip (foldr collectAnnotsStmt) qs
> collectAnnotsExpr (EnumFrom e) = collectAnnotsExpr e
> collectAnnotsExpr (EnumFromThen e1 e2) =
>   collectAnnotsExpr e1 . collectAnnotsExpr e2
> collectAnnotsExpr (EnumFromTo e1 e2) =
>   collectAnnotsExpr e1 . collectAnnotsExpr e2
> collectAnnotsExpr (EnumFromThenTo e1 e2 e3) =
>   collectAnnotsExpr e1 . collectAnnotsExpr e2 . collectAnnotsExpr e3
> collectAnnotsExpr (UnaryMinus _ e) = collectAnnotsExpr e
> collectAnnotsExpr (Apply e1 e2) =
>   collectAnnotsExpr e1 . collectAnnotsExpr e2
> collectAnnotsExpr (InfixApply e1 _ e2) =
>   collectAnnotsExpr e1 . collectAnnotsExpr e2
> collectAnnotsExpr (LeftSection e _) = collectAnnotsExpr e
> collectAnnotsExpr (RightSection _ e) = collectAnnotsExpr e
> collectAnnotsExpr (Lambda _ e) = collectAnnotsExpr e
> collectAnnotsExpr (Let ds e) =
>   flip (foldr collectAnnotsDecl) ds . collectAnnotsExpr e
> collectAnnotsExpr (Do sts) = flip (foldr collectAnnotsStmt) sts
> collectAnnotsExpr (IfThenElse e1 e2 e3) =
>   collectAnnotsExpr e1 . collectAnnotsExpr e2 . collectAnnotsExpr e3
> collectAnnotsExpr (Case e alts) =
>   collectAnnotsExpr e . flip (foldr collectAnnotsAlt) alts

> collectAnnotsStmt :: Statement -> EvalEnv -> EvalEnv
> collectAnnotsStmt (StmtExpr e) = collectAnnotsExpr e
> collectAnnotsStmt (StmtDecl ds) = flip (foldr collectAnnotsDecl) ds
> collectAnnotsStmt (StmtBind _ e) = collectAnnotsExpr e

> collectAnnotsAlt :: Alt -> EvalEnv -> EvalEnv
> collectAnnotsAlt (Alt _ _ rhs) = collectAnnotsRhs rhs

\end{lstlisting}
