/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2003  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef SX11Window_h
#define SX11Window_h

#include "swindow/sx11/SX11Impl.h"
#include "swindow/sx11/SX11Color.h"
#include "swindow/sx11/SXInputMethod.h"

#include "swindow/SGEngine.h"

#include "stoolkit/SBinVector.h"
#include "stoolkit/SBinHashtable.h"
#include "stoolkit/SVector.h"

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 * This is the abstract widget toolkit
 */
class SX11Window : public SWindow
{
public:
  SX11Window (const SString &name, SX11Impl* impl, long id);
  virtual ~SX11Window();

  static void setPixmapCacheSize(unsigned int size);
  static void setPixmapCacheOn (bool isOn=true);

  virtual bool cacheOn (bool on=true);

  virtual SS_Matrix2D  getCurrentMatrix() const;
  virtual void setMinimumSize (unsigned int width, unsigned int height);

  /* Low level routines */
  virtual void clear (int x, int y, unsigned int width, unsigned int height);

  virtual void copy (int x, int y, unsigned int width, unsigned int height, int tox, int toy);

  virtual void show ();
  virtual void hide ();

  /*---------------- from canvas --------------*/
  virtual bool newpath (double x, double y, const SString& id);
  virtual void fill (const SPen& pen);
  virtual void stroke (const SPen& pen);

  virtual void moveto (double x, double y);
  virtual void lineto (double x, double y);
  virtual void curveto (double x0, double y0, 
      double x1, double y1, double x3, double y3);
  virtual void closepath();
  virtual void pushmatrix();
  virtual void popmatrix();
  virtual void scale (double x, double y);
  virtual void translate (double x, double y);
  virtual void rotate (double angle);

  virtual void putImage (int x, int y, const SImage& image);
  virtual void bitfont (const SPen& pen, double x, double y, 
      void* native, char* data, unsigned int len);
  virtual void bitfill (const SColor& bg, int x, int y, 
      unsigned int width, unsigned int height);
  virtual void bitline (const SColor& fg, int x, int y, int tox, int toy);
  virtual void bitpoint (const SColor& fg, int x, int y);
  virtual void bitpoints (const SColor& fg, const int* x, const int* y, 
         unsigned int size);
  /*---------------- end of canvas ---------------*/

  virtual void setBackground(const SColor &color);
  virtual void resize (unsigned int width, unsigned int height);
  virtual void redraw (bool clear, int x, int y, 
       unsigned int width, unsigned int height);
  virtual void move (int x, int y);
  virtual void setParent (SWindow* w, int x, int y);
  virtual void getKeyboardFocus();
  virtual long getID();
  virtual void setClippingArea (int x, int y, 
      unsigned int width, unsigned int height);
  virtual void removeClippingArea ();

  virtual bool startInputMethod (const SString& name, const SProperties& prop);
  virtual void stopInputMethod ();
  virtual void setInputMethodProperties (const SProperties& prop);
  virtual SString getInputMethod ();
  virtual bool isVisible ();

  virtual SString  getClipUTF8();
  virtual void putClipUTF8(const SString& utf8);
  virtual void setTitle (const SString& title);

  virtual void addAccelerator (const SAccelerator& a, SAcceleratorListener* l);
  virtual void removeAccelerator (const SAccelerator& a, SAcceleratorListener* l);
  void _acceleratorPressed (const SAccelerator& a);
  void _acceleratorReleased (const SAccelerator& a);

  /*------- xdnd -----------*/
  void setDroppable (const SStringVector& targets);
  const SStringVector& getDroppable() const;

  /* Xutf8LookupString needs this from input context */
  XIC getIC ();
  const SString& getICEncoding () const;
  bool isAsciiInput ();
  bool isKInput ();

  SBinVector<Atom> targetAtoms;
  SStringVector    targets;
  virtual void setModal (SWindow*w, bool decorated);
  virtual void center (SWindow* window);
  virtual void wait ();
  bool mapNotified;
  bool isChild;

  /*--- get an integer id for the underlying window ---*/
  virtual unsigned long getWindowID() const;


private:
  SBinHashtable <SAcceleratorListener*> accelerators;
  void SX11Window::createShadedPixmap (const SImage& im, Pixmap* p, Pixmap* m);
  void SX11Window::createColoredPixmap (const SImage& im, Pixmap* p, Pixmap* m);
  SString         name;
  SXInputMethod inputMethod;
  SPen		pen;
  GC		gc; /* always set to gb and pen fg */
  GC		gc_draw_or; /* always set to gb and pen fg */
  GC		gc_draw_and; /* always set to gb and pen fg */
  GC		gc_default; /* always set to gb and pen fg */

  bool 		clipped; /* gc is clipped */
  SX11Impl*     impl;
  long          id;
  SX11Color     background;
  SGEngine*     engine;
  unsigned long gcFD;
  unsigned long gcFG;
};

#endif /* SX11Window_h */
