/*
 * daycalc.c
 */

/*
 * yank  -  yet another NoteKeeper
 * Copyright (C) 1999, 2000, 2001 Michael Humann <m.hussmann@home.ins.de>
 *
 * This program is free software; you  can redistribute it and/or modify it
 * under the terms of  the GNU General  Public License as published  by the
 * Free Software Foundation;  either version 2 of  the License, or (at your
 * option) any later version.
 *
 * This program  is  distributed in the  hope  that it will  be useful, but
 * WITHOUT  ANY   WARRANTY;  without   even   the  implied    warranty   of
 * MERCHANTABILITY or    FITNESS FOR A PARTICULAR   PURPOSE.   See  the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write to the  Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "daycalc.h"


/* ------------------------------------------------------ */
/*
 * return formatted string with date& time
 */

char*
time2f_date(time_t *t, const char *format)
{
    static struct tm *tms;
    static char      buf[256];
    int              buflen;
    size_t           f_size;

    if (t == NULL)
    {
        return (NULL);
        /* noreached */
    }
    
    if (*t < 0)
    {
        return ("");
        /* notreached */
    }
    
    buflen = sizeof(buf);
    tms = localtime(t);
    f_size = strftime(buf, (buflen - 1), format, tms);
    if (f_size == 0)
    {
        return (NULL);
        /* notreached */
    }
    
    return (buf);
}

/* ------------------------------------------------------ */
/*
 * return a nice formatted standard-string with date& time
 */

char*
time2isodate(time_t *t)
{
    return (time2f_date(t, "%Y-%m-%d %H:%M:%S"));
}

/* ------------------------------------------------------ */
/*
 * transform "2000-02-29 11:45:32" into time_t
 */

time_t
isodate2time(char *str)
{
    time_t           t_val;
    static struct tm p_t;
    char             *pos;

    t_val = -1;

    if (str == NULL)
    {
        return (t_val);
        /* notreached */
    }
    
    if (strlen(str) == 0)
    {
        return (t_val);
        /* notreached */
    }
    
    pos = strptime(str, "%Y-%m-%d %H:%M:%S", &p_t);
    if (pos != NULL)
    {
        t_val = mktime(&p_t);
    }
    
    return (t_val);
}

/* ------------------------------------------------------ */
