/**
 * A client-side 802.1x implementation 
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * File: wpa_hostap_driver.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: wpa_hostap_driver.c,v 1.4 2004/08/20 04:42:28 chessing Exp $
 * $Date: 2004/08/20 04:42:28 $
 * $Log: wpa_hostap_driver.c,v $
 * Revision 1.4  2004/08/20 04:42:28  chessing
 * Set all of the new scanning and WPA code to be disabled by default, so that a 1.0.1 release can be made.  Added additional error message output to AKA code.  Fixed a few memory leaks in the AKA code.
 *
 * Revision 1.3  2004/08/19 04:11:48  chessing
 * More updates to get closer to WPA support.  We can now associate to an AP that has WPA, however we are using a static WPA IE, so that needs to be fixed.  There is also still a fair bit of other things that need to be cleaned up, but we are closer.
 *
 * Revision 1.2  2004/08/19 02:33:31  chessing
 * A few follow-ups from the last patch.
 *
 * Revision 1.1  2004/08/19 02:28:07  chessing
 * First piece of WPA patch.  (The patch is growing fast, and this commit is to save what is done so far.)
 *
 *
 *******************************************************************/

#ifdef EXPERIMENTAL

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/wireless.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdint.h>

typedef uint64_t u64;
typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t u8;
typedef int64_t s64;
typedef int32_t s32;
typedef int8_t s8;

#include "../xsup_debug.h"
#include "linux/ieee80211_crypto.h"
#include "linux/ieee80211_ioctl.h"
#include "linux/hostap_common.h"

char generic_wpa_ie[24] = {0xdd, 0x16, 0x00, 0x50, 0xf2, 0x01, 0x01, 0x00,
			   0x00, 0x50, 0xf2, 0x02, 0x01, 0x00, 0x00, 0x50, 
			   0xf2, 0x02, 0x01, 0x00, 0x00, 0x50, 0xf2, 0x02};

// Taken from wpa_supplicant.
static int hostapd_ioctl(const char *dev, struct prism2_hostapd_param *param,
			 int len, int show_err)
{
	int s;
	struct iwreq iwr;

	s = socket(PF_INET, SOCK_DGRAM, 0);
	if (s < 0) {
		debug_printf(DEBUG_NORMAL, "socket");
		return -1;
	}

	memset(&iwr, 0, sizeof(iwr));
	strncpy(iwr.ifr_name, dev, IFNAMSIZ);
	iwr.u.data.pointer = (caddr_t) param;
	iwr.u.data.length = len;

	if (ioctl(s, PRISM2_IOCTL_HOSTAPD, &iwr) < 0) {
		int ret;
		close(s);
		ret = errno;
		if (show_err) 
			debug_printf(DEBUG_NORMAL, "ioctl[PRISM2_IOCTL_HOSTAPD]");
		return ret;
	}
	close(s);

	return 0;
}

// Taken from WPA supplicant.
static int
set80211param(const char *dev, int op, int arg, int show_err)
{
        struct iwreq iwr;
	int sd;

	sd = socket(PF_INET, SOCK_DGRAM, 0);
	if (sd < 0)
	  {
	    debug_printf(DEBUG_NORMAL, "Couldn't allocate socket in %s!\n",
			 __FUNCTION__);
	    return -1;
	  }

        memset(&iwr, 0, sizeof(iwr));
        strncpy(iwr.ifr_name, dev, 16);
        iwr.u.mode = op;
        memcpy(iwr.u.name+sizeof(unsigned int), &arg, sizeof(arg));

        if (ioctl(sd, IEEE80211_IOCTL_SETPARAM, &iwr) < 0) {
                if (show_err)
                        debug_printf(DEBUG_NORMAL, "ioctl[IEEE80211_IOCTL_SETPARAM]\n");
                return -1;
        }
        return 0;
}
/*
int wpa_hostap_driver_set_wpa_ie(char *intname, char *wpa_ie, int wpa_ie_len)
{
  int sock;
  struct iwreq iwr;

  sock = socket(PF_INET, SOCK_DGRAM, 0);
  if (sock<0)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't allocate socket in %s!\n", 
		   __FUNCTION__);
      return -1;
    }
  
  bzero(&iwr, sizeof(iwr));
  strncpy(iwr.ifr_name, intname, IFNAMSIZ);
  iwr.u.data.pointer = NULL;
  iwr.u.data.length = 0;

  if (ioctl(sock, IEEE80211_IOCTL_SETOPTIE, &iwr) < 0)
    {
      debug_printf(DEBUG_NORMAL, "Error trying to set WPA IE on interface %s!\n",
		   intname);
    }
}
*/

int wpa_hostap_driver_set_wpa_ie(char *ifname, char *wpa_ie,
					int wpa_ie_len)
{
	struct prism2_hostapd_param *param;
	int res, i;
	size_t blen = PRISM2_HOSTAPD_GENERIC_ELEMENT_HDR_LEN + 24;
	if (blen < sizeof(*param))
		blen = sizeof(*param);

	if (wpa_ie != NULL)
	  {
	    printf("WPA IE isn't NULL!!!! (Size : %d)\nIE : ", wpa_ie_len);
	    printf("(%d)\n", PRISM2_HOSTAPD_GENERIC_ELEMENT_HDR_LEN+wpa_ie_len);
	    for (i=0;i<wpa_ie_len;i++)
	      {
		printf("%02X ", wpa_ie[i]);
	      }
	    printf("\n");
	  }

	param = (struct prism2_hostapd_param *) malloc(blen);
	if (param == NULL)
		return -1;

	memset(param, 0, blen);
	param->cmd = PRISM2_HOSTAPD_SET_GENERIC_ELEMENT;
	param->u.generic_elem.len = 24;
	memcpy(param->u.generic_elem.data, &generic_wpa_ie, 24);
	res = hostapd_ioctl(ifname, param, blen, 1);

	free(param);

	return res;
}


int wpa_hostap_driver_wpa_enable(char *intname)
{
  if (set80211param(intname, IEEE80211_PARAM_ROAMING, 1, 1) < 0)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't enable roaming on interface %s!\n",
		   intname);
    }

  if (set80211param(intname, IEEE80211_PARAM_PRIVACY, 1, 1) < 0)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't enable privacy on interface %s!\n",
		   intname);
    }

  if (set80211param(intname, IEEE80211_PARAM_WPA, 1, 1) < 0)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't enable WPA on interface %s!\n",
		   intname);
    }

  if (set80211param(intname, IEEE80211_PARAM_COUNTERMEASURES, 1, 1) < 0)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't enable counter measures for interface %s!\n",
		   intname);
    }

  if (set80211param(intname, IEEE80211_PARAM_DROPUNENCRYPTED, 1, 1) < 0)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't enable \"drop unencrypted packets\" on interface %s!\n",
		   intname);
    }
}

int wpa_hostap_driver_wpa_disable(char *intname)
{

}

#endif
