
/*
 * allocate a block of memory which is shared between processes
 * after a fork()
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include "config.h"
#include "shmalloc.h"
#include <sys/mman.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#ifdef MAP_ANON
# define MAP (MAP_SHARED | MAP_ANON)
#else
# define MAP (MAP_SHARED)
#endif

static char    *syscalls[] =
{
    "shmget",
    "shmat",
    "mmap",
    NULL
};

static int      shared_anonymous_mmap_works = 1;

char           *sh_failed_syscall;

void           *
sh_malloc(int size)
{
    int             shm_id,fd = -1;
    void           *shm_addr = NULL;

    if (shared_anonymous_mmap_works) {
#ifndef MAP_ANON
	if (-1 == (fd = open("/dev/zero",O_RDONLY))) {
	    perror("open /dev/zero");
	    exit(1);
	}
#endif
	shm_addr = mmap(NULL, size + sizeof(int), PROT_READ | PROT_WRITE,
			MAP, fd, 0);
#ifndef MAP_ANON
	close(fd);
#endif

	if ((void *) -1 == shm_addr) {
	    if (errno != EINVAL) {
		/* no memory ? */
		sh_failed_syscall = syscalls[2];
		return NULL;
	    } else {
		/* Hmm, seems we can't do shared anonymous mappings */
		shared_anonymous_mmap_works = 0;
#if 0
		fprintf(stderr, "shared anon mmap failed, trying sysv shm\n");
#endif
	    }
	} else {
	    *(int *) shm_addr = size + sizeof(int);

	    return ((int *) shm_addr) + 1;
	}
    }
    shm_id = shmget(IPC_PRIVATE, size, IPC_CREAT | 0700);
    if (-1 == shm_id) {
	sh_failed_syscall = syscalls[0];
	return NULL;
    }
    shm_addr = shmat(shm_id, 0, 0);
    if ((void *) -1 == shm_addr) {
	shmctl(shm_id, IPC_RMID, 0);
	sh_failed_syscall = syscalls[1];
	return NULL;
    }
    shmctl(shm_id, IPC_RMID, 0);
    return shm_addr;
}

void
sh_free(void *data)
{
    int             size;

    if (shared_anonymous_mmap_works) {
	((int *) data)--;
	size = *(int *) data;
	munmap(data, size);
    } else
	shmdt(data);
}
