/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "sdl_gforce_status.h"
#include "sdl_gforce_config.h"
#include "sdl_gforce_handlers.h"
#include "sdl_helpers.h"

// Since the sdl_gforce is a singleton, keep this global static object
static SingitSingleton       *sdl_gforce_status = NULL;
static SingitSingletonClass  *parent_class = NULL;

static void sdl_gforce_status_class_init (SDLGForceStatusClass *klass);
static void sdl_gforce_status_init (SDLGForceStatus *sstat);
static void sdl_gforce_status_destroy(GtkObject *object);
static gboolean sdl_gforce_status_after_init(SingitSingleton *single);

GtkType sdl_gforce_status_get_type (void)
{
	static GtkType sdl_gforce_status_type = 0;

	if (!sdl_gforce_status_type) {

		static const GtkTypeInfo sdl_gforce_status_info =
		{
			(gchar*) "SDLGForceStatus",
			sizeof (SDLGForceStatus),
			sizeof (SDLGForceStatusClass),
			(GtkClassInitFunc) sdl_gforce_status_class_init,
			(GtkObjectInitFunc) sdl_gforce_status_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		sdl_gforce_status_type = gtk_type_from_name("SDLGForceStatus");
		if ((sdl_gforce_status_type == GTK_TYPE_NONE) ||
			(sdl_gforce_status_type == GTK_TYPE_INVALID))
		{
			sdl_gforce_status_type = gtk_type_unique
				(TYPE_SINGIT_SINGLETON, &sdl_gforce_status_info);
		}
		else { parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON); }
	}

	return sdl_gforce_status_type;
}

static void sdl_gforce_status_class_init (SDLGForceStatusClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	SingitSingletonClass *singleton_class =
		(SingitSingletonClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON);

	object_class->destroy = sdl_gforce_status_destroy;
	singleton_class->after_init = sdl_gforce_status_after_init;
}

static void sdl_gforce_status_init(SDLGForceStatus *sstat)
{
	sstat->song = NULL;

	sstat->toggle_yz = FALSE;
	sstat->print_debug = FALSE;
	sstat->is_fullscreen = FALSE;

	sstat->time = 0;
	sstat->toplines = 2;
	sstat->lines = 5;

	sstat->screen = NULL;
	sstat->current_text = NULL;
	sstat->next_text = NULL;
	sstat->font = NULL;

	sstat->jump_to_song = -1;
	sstat->skd = NULL;

	sstat->sdl_inuse = FALSE;

	sstat->xmms_playing = FALSE;
	sstat->singit_playing = FALSE;

	sstat->longest_line = 0;

	sstat->render_thread = 0;
	sstat->kill_render_thread = FALSE;
	sstat->shutdown = FALSE;

	sstat->sfc = NULL;

	sstat->config = NULL;
}

static void sdl_gforce_status_destroy(GtkObject *object)
{
	SDLGForceStatus *sstat;

	g_return_if_fail(object != NULL);
	g_return_if_fail(IS_SDL_GFORCE_STATUS (object));

	g_print("Destroy\n");

	sstat = SDL_GFORCE_STATUS(object);

	if (sstat->sfc != NULL) {
		gtk_object_destroy(GTK_OBJECT(sstat->sfc));
		sstat->sfc = NULL;
	}

	if (sstat->current_text != NULL) {
		SDL_FreeSurface(sstat->current_text);
		sstat->current_text = NULL;
	}

	if (sstat->next_text != NULL) {
		SDL_FreeSurface(sstat->next_text);
		sstat->next_text = NULL;
	}

	if (sstat->font != NULL) {
		TTF_CloseFont(sstat->font);
		sstat->font = NULL;
	}

	if (sstat->sdl_inuse == FALSE) {
		sdl_helper_blanking(BLANK_RESET);

		sdl_handler_finish();
	}

	sstat->screen = NULL;

	singit_song_detach(&sstat->song);

	singit_config_gen_detach(&sstat->config);

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

static gboolean sdl_gforce_status_after_init(SingitSingleton *single)
{
	g_return_val_if_fail(single != NULL, FALSE);
	g_return_val_if_fail(IS_SDL_GFORCE_STATUS(single), FALSE);

	SDL_GFORCE_STATUS(single)->config =
		displayer_sdl_gforce_config_new();
	singit_config_gen_load(SDL_GFORCE_STATUS(single)->config);

	return (SDL_GFORCE_STATUS(single)->config != NULL);
}

SingitSingleton* sdl_gforce_status_ref(void)
{
	gboolean init;
	SingitSingleton *status = singit_singleton_construct
		(&sdl_gforce_status, TYPE_SDL_GFORCE_STATUS, &init);
	if (init == TRUE)
		{ return status; }
	return singit_singleton_attach(status);
}

void sdl_gforce_status_unref(SingitSingleton** single)
{
	g_return_if_fail(sdl_gforce_status != NULL);

	if (single == NULL) {
		SingitSingleton* unref_single = sdl_gforce_status;
		singit_singleton_detach(&unref_single);
	}
	else {
		g_return_if_fail(*single == sdl_gforce_status);
		singit_singleton_detach(single);
	}
}

SingitSingleton* sdl_gforce_status_noref(void)
{
	if (sdl_gforce_status == NULL)
		{ return NULL; }

	g_return_val_if_fail(IS_SDL_GFORCE_STATUS(sdl_gforce_status), NULL);

	return sdl_gforce_status;
}
